<?php
/**
 * Template part for displaying single posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Strata_Three
 */

global $first_post;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

		<header class="entry-header">
		<?php
			if ( $first_post == true ) {
				the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
			} else {
				the_title( '<h1 class="entry-title">', '</h1>' );
			}
		?>

		<div class="entry-meta">
			<?php s3_posted_on(); ?>
		</div><!-- .entry-meta -->
	</header><!-- .entry-header -->


	<div class="entry-content">
		<?php echo s3_featured_image($post, $first_post); ?>
		<?php the_content(); ?>
<?php
# Check if the flexible content field has rows of data
if ( $content = have_rows('content_within') ) {
	echo acf_content_flexible($content, 'content_within');
}
?>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 's3' ),
				'after'  => '</div>',
			) );
		?>
		<div class="clearfix"></div>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<hr class="s3-b-<?php echo _SITE_HIGHLIGHTS; ?> s3-mt-0 s3-mb-6" />
		<?php s3_entry_footer(); ?>
	</footer><!-- .entry-footer -->

</article><!-- #post-## -->

