<?php
/**
 * Template part for displaying results in search pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Strata_Three
 */

// Continue Button Text
$continue = "Continue Reading";

 // Posted On Categories
$categories_show = true;

// Layout Width
$article_class  = 'article-narrow';
$article_first  = ' col-md-6';
$article_second = ' col-md-6';
$wide_slugs     = array('photo', 'radio', 'video');
if ($categories = get_the_category()) {
	if ( in_array($categories[0]->slug, $wide_slugs) ) {
		$article_class  = 'article-wide';
		$article_first  = ' col-md-12';
		$article_second = ' col-md-12';
	
		// Overwrite Button Text
		switch ($categories[0]->slug) {
			case 'photo':
				$continue = "View Gallery";
				break;
			case 'radio':
				$continue = "Hear Story";
				break;
			case 'video':
				$continue = "View Story";
				break;
		}
	}	
}


// Featured Images
$featured_image = '';
if ( has_post_thumbnail() ) {
	$featured_image = '<a aria-hidden="true" href="' . esc_url( get_permalink() ). '">';
	$featured_image .= '<figure class="featured-image">';
	$featured_image .= get_the_post_thumbnail( $post->ID, 's3-md-3x2', array( 'class' => 'img-responsive' ) );
	$featured_image .= '</figure>';
	$featured_image .= '</a>';
} else {
	$article_class  = 'article-wide';
	$article_first  = ' hidden';
	$article_second = ' col-md-12';
}


// Format Output
?>
<article id="post-<?php the_ID(); ?>" <?php post_class($article_class ); ?>>
	<div class="article s3-<?php echo _SITE_POSTS; ?> s3-p-7 s3-mb-7 s3-bs">
		<div class="row">
			<div class="col-xs-12<?php echo $article_second; ?>">
				<?php echo $featured_image; ?>
			</div>
	
			<div class="col-xs-12<?php echo $article_second; ?>">
				<?php the_title( sprintf( '<h2><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>
				<?php if ( 'post' === get_post_type() ) : ?>
					<p class="small"><?php s3_index_posted_on(); ?></p>
				<?php endif; ?>
				<?php the_excerpt(); ?>
        <p class="s3-mb-0"><a aria-hidden="true" class="btn btn-md btn-go s3-<?php echo _SITE_BUTTONS; ?>" href="<?php echo get_permalink(); ?>" rel="bookmark"><?php echo $continue; ?></a></p>
		</div>
	</div>

</article> <!-- #post-<?php the_ID(); ?> -->



