<?php
/**
 * Template part for displaying page content in page.php.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Strata_Three
 */

$show_title = true;
if (function_exists('get_field')) {
	if ($main_content_content = get_field('main_content_content')) {
		if ($main_content_content[0]['hide_title']) {
			$show_title = false;
		}
	}
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php if ( !is_front_page() && !is_home() ) : ?>
	<header class="entry-header">
		<?php the_title( '<h1 class="entry-title">', '</h1>', $show_title ); ?>
	</header><!-- .entry-header -->
	<?php endif; ?>

	<div class="entry-content">
		<?php the_content(); ?>

		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 's3' ),
				'after'  => '</div>',
			) );
		?>
	</div><!-- .entry-content -->

</article><!-- #post-## -->
<?php
# Check if the flexible content field has rows of data
if ( $content = have_rows('content_within') ) {
	echo acf_content_flexible($content, 'content_within');
}
?>

<?php
	edit_post_link(
		sprintf(
			/* translators: %s: Name of current post */
			esc_html__( 'Edit %s', 's3' ),
			the_title( '<span class="screen-reader-text">"', '"</span>', false )
		),
		'<footer class="entry-footer"><hr class="s3-b-' . _SITE_HIGHLIGHTS . ' s3-mt-0 s3-mb-6" /><span class="edit-link">',
		'</span></footer><!-- .entry-footer -->'
	);
?>
