<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Strata_Three
 */

get_header();

# Check if the page content area needs to be adjusted
$content = s3_layout_content();
$content_format = s3_content_format($content);

// Check if the page needs to be adjusted for a sidebar
$sidebar = s3_layout_sidebar();
$sidebar_format = s3_sidebar_format($sidebar, 'second');

$breadcrumbs = s3_breadcrumbs();
echo $breadcrumbs['first'];
?>


<?php
// check if the flexible content field has rows of data
if ( $content = have_rows('content_above') ) {
	echo acf_content_flexible($content, 'content_above');
}
?>


<div class="s3-<?php echo _SITE_CONTENT; ?>">
<?php echo $breadcrumbs['second']; ?>


<?php
	echo $content_format;

	# Creates the properly columned div
	if ($sidebar['sidebar'] == 'yes') {
		echo $sidebar_format['content'];
	} else {
		echo $sidebar_format;
	}
?>

<main id="content">
<!-- Single page: Begin -->

		<?php while ( have_posts() ) : the_post(); ?>

			<?php get_template_part( 'template-parts/content', 'single' ); ?>

			<?php
				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;
			?>

<?php
			// $post_image_next = get_the_post_thumbnail( get_next_post( array('in_same_term' => true) )->ID, 'large' );
			// $post_image_prev = get_the_post_thumbnail( get_previous_post( array('in_same_term' => true) )->ID, 'large' );

			the_post_navigation( array(
				'next_text' => '<div>' . '<span class="meta-nav">' . __( 'Next Article <span class="fa fa-angle-right" title="Next"></span>', 's3' ) . '</span> ' .
				// $post_image_next . 
				'<span class="meta-title">%title</span>' . '</div>',

				'prev_text' => '<div>' . '<span class="meta-nav">' . __( '<span class="fa fa-angle-left" title="Previous"></span> Previous Article', 's3' ) . '</span> ' .
				// $post_image_prev . 
				'<span class="meta-title">%title</span>' . '</div>',

				'in_same_term' => true,
        'aria_label' => __( '' ),
			) );

?>

		<?php endwhile; // End of the loop. ?>

<!-- Single page: End -->
</main>

		</div><!-- /sidebar or primary content div -->

<?php
if ($sidebar['sidebar'] == 'yes') {
	echo $sidebar_format['sidebar'];
	get_sidebar($sidebar['widget']);
	echo '</div>';
}
?>
		</div><!-- .row -->
	</div><!-- .content -->
</div><!-- s3-<?php echo _SITE_CONTENT; ?> -->


<?php
// check if the flexible content field has rows of data
if ( $content = have_rows('content_below') ) {
	echo acf_content_flexible($content, 'content_below');
}
?>


<?php
get_footer();



