<?php
/**
 * The template for displaying search results pages.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Strata_Three
 */

get_header();
?>


<div class="s3 s3-<?php echo _SITE_CONTENT; ?>">
	<div class="container">
		<div class="row s3-m-10">
			<div class="col-xs-12 col-md-8">

<main id="content">
		<?php if ( have_posts() ) : ?>

			<header class="page-header">
			<h1 class="page-title">
					<?php
					/* translators: %s: search query. */
					printf( esc_html__( 'Search Results for: %s', 'test' ), '<span>' . get_search_query() . '</span>' );
					?>
				</h1>
			</header><!-- .page-header -->

			<div class="s3-<?php echo _SITE_HIGHLIGHTS; ?> s3-p-9 s3-bs">
				<?php get_search_form(); ?>
			</div>

			<hr />

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>

				<?php
				/**
				 * Run the loop for the search to output the results.
				 * If you want to overload this in a child theme then include a file
				 * called content-search.php and that will be used instead.
				 */
				get_template_part( 'template-parts/content', 'search' );
				?>

			<?php endwhile; ?>

			<?php s3_paging_nav(); ?>

		<?php else : ?>

			<?php get_template_part( 'template-parts/content', 'none' ); ?>

		<?php endif; ?>
</main>

			</div><!-- /sidebar or primary content div -->

			<div class="col-xs-12 col-sm-4 hidden-xs hidden-sm">
				<?php s3_decoration(); ?>
			</div><!-- .col -->
		</div><!-- .row -->
	</div><!-- .content -->
</div><!-- s3-<?php echo _SITE_CONTENT; ?> -->


<?php
get_footer();



