// --- Core Search Function (FSU_search) ---
// SAFE FIX: Uses encodeURIComponent() to safely encode the search string (s)
// before injecting it into the URL, preventing Cross-Site Scripting (XSS).
function FSU_search(a, s) {
    var url = "";
    var encodedSearch = encodeURIComponent(s); // Use secure, native URL encoding

    switch (a) {
        case "PHFST":
            url = "https://bb5.fsu.edu/cas/login?service=https://campus.fsu.edu/webapps/portal/frameset.jsp?tab_tab_group_id=_19_1%26SAurl=https%3A%2F%2Fcampus.fsu.edu%2Fwebapps%2FFSU-peoplesearch-bb_bb60%2Fservlet%2FstudentSearchExternal%3FsearchStr%3D" + encodedSearch + "&loginurl=https://campus.fsu.edu/webapps/login/bb_bb60/logincas.jsp?mc=1001";
            break;
        case "PHF":
            url = "https://apps.its.fsu.edu/Directory/Directory.html?searchStr=" + encodedSearch + "+&searchBy=lastname&submit=Search";
            break;
        case "DEPT":
            // Note: DEPT case was not using the custom encoder, using native encoder now.
            url = "https://apps.its.fsu.edu/DepartmentDirectory/app/?TYPE=" + a + "&KEYWORDS=" + encodedSearch;
            break;
        default:
            url = "https://www.fsu.edu/search/results.html?cx=001481282910879549110%3A7l5zcrhp_cg&cof=FORID%3A9&ie=UTF-8&q=" + encodedSearch;
    }
    
    // Using window.open is typically discouraged, but maintained original functionality.
    window.open(url, "_blank");
    return false;
}

// --- jQuery Document Ready Block ---
(function ($) {
    // FSU Utilities (Bootstrap Collapse)
    $(".fsu-utilities").on("show.bs.collapse", function () {
        $(".fsu-utilities .in").collapse("hide");
    });

    // Sticky Header Logic
    $(window).scroll(function () {
        var a = $(window).scrollTop(),
            s = $("#fsu-global").outerHeight(),
            e = $("#fsu-masthead").outerHeight();
        
        if (a > s + e) {
            $("#fsu-header").addClass("nav-fixed");
            $("#fsu-home").addClass("hidden");
            $("#fsu-top").removeClass("hidden");
            $("#fsu-nav-utility").removeClass("col-sm-5 col-sm-offset-2").addClass("col-sm-4");
            $("body").addClass("add-fixed");
        } else {
            $("#fsu-header").removeClass("nav-fixed");
            $("#fsu-home").removeClass("hidden");
            $("#fsu-top").addClass("hidden");
            $("#fsu-nav-utility").addClass("col-sm-5 col-sm-offset-2").removeClass("col-sm-4");
            $("body").removeClass("add-fixed");
        }
    });

    // Icon Injection Logic (Improved for Accessibility and Deprecation)
    // All icons use aria-hidden="true" instead of redundant title attributes.
        function isExternal(hostname) {
        var host_t = hostname.substring(hostname.length - 7);
        var host_l = location.hostname.substring(location.hostname.length - 7);
        return host_t && host_t !== host_l;
    }

    $('main p a').filter(function () {
        return isExternal(this.hostname);
    }).not(".null").not(".btn").after('<small><span class="fas fa-angle-right" aria-hidden="true"></span></small>');
    
    $(".link-external").append('&nbsp;<span class="fa fa-caret-right" aria-hidden="true"></span>');
    
    // File Types
    $('main p a[href*=\\.csv]').after('&nbsp;<span class="fas fa-file-alt" aria-hidden="true"></span>');
    $('main p a[href*=\\.xlsx]').after('&nbsp;<span class="fas fa-file-excel" aria-hidden="true"></span>');
    $('main p a[href*=\\.pdf]').after('&nbsp;<span class="fas fa-file-pdf" aria-hidden="true"></span>');
    $('main p a[href*=\\.pptx]').after('&nbsp;<span class="fas fa-file-powerpoint" aria-hidden="true"></span>');
    $('main p a[href*=\\.docx]').after('&nbsp;<span class="fas fa-file-word" aria-hidden="true"></span>');

    // Mailto links and buttons
    $.expr[':'].mailto = function (obj) { return obj.href.match(/^mailto\:/); };
    $('main a:mailto').not(".list-icons a").after('&nbsp;<span class="fa fa-envelope" aria-hidden="true"></span>');
    $('.btn-download').prepend('<span class="fas fa-download" aria-hidden="true"></span>&nbsp;');
    $('.btn-go').append('&nbsp;<span class="fas fa-angle-right" aria-hidden="true"></span>');
    $('.btn-go-alt').append('&nbsp;<span class="fa fa-chevron-circle-right" aria-hidden="true"></span>');

    // Add icons to .list-icons
    $('.list-icons a').filter(function () {
        return isExternal(this.hostname);
    }).before('<span class="far fa-arrow-alt-circle-right" aria-hidden="true"></span>&nbsp;');
    
    // File Types in Lists
    $('.list-icons a[href*=\\.csv]').before('<span class="fas fa-file-alt" aria-hidden="true"></span>&nbsp;');
    $('.list-icons a[href*=\\.xlsx]').before('<span class="fas fa-file-excel" aria-hidden="true"></span>&nbsp;');
    $('.list-icons a[href*=\\.pdf]').before('<span class="fas fa-file-pdf" aria-hidden="true"></span>&nbsp;');
    $('.list-icons a[href*=\\.pptx]').before('<span class="fas fa-file-powerpoint" aria-hidden="true"></span>&nbsp;');
    $('.list-icons a[href*=\\.docx]').before('<span class="fas fa-file-word" aria-hidden="true"></span>&nbsp;');
    
    // Specific List Icons
    $.expr[':'].fax = function (obj) { return obj.href.match(/^fax\:/); };
    $('ul.list-icons a:fax').before('<span class="fa fa-fax" aria-hidden="true"></span>&nbsp;');
    
    $.expr[':'].mailto = function (obj) { return obj.href.match(/^mailto\:/); };
    $('ul.list-icons a:mailto').before('<span class="fa fa-envelope" aria-hidden="true"></span>&nbsp;');
    
    $.expr[':'].tel = function (obj) { return obj.href.match(/^tel\:/); };
    $('ul.list-icons a:tel').before('<span class="fa fa-phone" aria-hidden="true"></span>&nbsp;');
    
    $('ul.list-icons li.user a').before('<span class="fas fa-user" aria-hidden="true"></span>&nbsp;');
    $('ul.list-icons li.map a').before('<span class="fa fa-map-marker-alt" aria-hidden="true"></span>&nbsp;');

    // Menu arrow toggle
    $('.btn-menu').click(function () {
        $(this).find("span").toggleClass("fa-chevron-circle-down fa-chevron-circle-up");
    });

    // Add the .s3-gt class to buttons with .btn-primary
    $('.btn-primary').addClass('s3-gt');

    // Add the .null class to images within links (removes background-image)
    $('a').has('img').addClass('null');

})(jQuery);