<?php
/**
 * Template Name: S3 Custom 2
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Strata_Three
 */

get_header();

# Check if the page content area needs to be adjusted
$content = s3_layout_content();
$content_format = s3_content_format($content);

// Check if the page needs to be adjusted for a sidebar
$sidebar = s3_layout_sidebar();
$sidebar_format = s3_sidebar_format($sidebar, 'second');

$breadcrumbs = s3_breadcrumbs();
echo $breadcrumbs['first'];
?>




<?php
// check if the flexible content field has rows of data
if ( $content = have_rows('content_above') ) {
	echo acf_content_flexible($content, 'content_above');
}
?>



<div class="s3 s3-<?php echo _SITE_CONTENT; ?>">
<?php
if (!is_front_page()) {
	echo $breadcrumbs['second'];
}
?>


<?php
	echo $content_format;

	# Creates the properly columned div
	if ($sidebar['sidebar'] == 'yes') {
		echo $sidebar_format['content'];
	} else {
		echo $sidebar_format;
	}
?>

<main id="content">
						<?php while ( have_posts() ) : the_post(); ?>
<?php
if ( ($post->post_content != "") || ($content = have_rows('content_within')) ) {
	get_template_part( 'template-parts/content', 'page' );
}
?>
							<?php
								// If comments are open or we have at least one comment, load up the comment template.
								if ( comments_open() || get_comments_number() ) :
									comments_template();
								endif;
							?>
						<?php endwhile; // End of the loop. ?>
</main>

		</div><!-- /sidebar or primary content div -->

<?php
if ($sidebar['sidebar'] == 'yes') {
	echo $sidebar_format['sidebar'];
	get_sidebar($sidebar['widget']);
	echo '</div>';
}
?>
		</div><!-- .row -->
	</div><!-- .content -->
</div><!-- s3-<?php echo _SITE_CONTENT; ?> -->


<?php
// check if the flexible content field has rows of data
if ( $content = have_rows('content_below') ) {
	echo acf_content_flexible($content, 'content_below');
}
?>


<?php #} // acf_content ?>
<?php get_footer(); ?>
