/**
 * File functions.js.
 *
 * Handles toggling the navigation menu for small screens and enables TAB key
 * navigation support for dropdown menus.
 */
( function( $ ) {

  // Wrap centered images in a new figure element
  // $( 'img.aligncenter' ).wrap( '<figure class="centered-image"></figure>');

  $( '.widget > ul' ).wrap(
    '<nav class="navbar nav-vert" role="navigation">'
  );
  $( '.widget > div >  ul' ).wrap(
    '<nav class="navbar nav-vert" role="navigation">'
  );

  $('.widget_calendar .calendar_wrap' ).addClass('s3-bs');
  $('.widget_search .search-submit' ).addClass('btn btn-sm s3-gt');

  $('.current-menu-item').addClass('active');
  $('#fsu-nav-primary .current-page-parent').addClass('active');

  $('.entry-meta').addClass('dimmed');
  $('.entry-footer').addClass('dimmed');
  $('.nav-links').addClass('dimmed');

  $('.post-navigation a').addClass('btn btn-full s3-c');

  $('iframe.soundcloud').contents()
    .find('.g-background-default').addClass('s3-bg-c');

  $("iframe[src^='https://www.youtube.com']").wrap( '<div class="video">' );

} )( jQuery );


/**
 * ADA Title II
 * Date: November 13, 2025
 * Function: Add title tags and ARIA labels to media iframes using APIs
 */


// =========================================================
// YOUTUBE TITLE FETCH FUNCTION
// Fetches the actual title using the YT IFrame Player API
// =========================================================
(function($) {
  // Array to hold references to all created YT.Player objects
  var youtubePlayers = [];

  function initYouTubePlayers() {
    // Select all iframes with the necessary class and API parameter
    $('iframe.youtube-video[src*="enablejsapi=1"]').each(function() {
      var iframe = this;
      var $iframe = $( iframe ); // jQuery object for setting attributes

      // Assign a unique ID if one doesn't exist (required by YT.Player)
      if (!iframe.id) {
        iframe.id = 'ytplayer-' + Math.random().toString(36).substr(2, 9);
      }

      // Create the YT.Player object
      var player = new YT.Player(iframe.id, {
        events: {
          'onReady': onPlayerReady
        }
      });
      youtubePlayers.push(player);
    });
  }

  function onPlayerReady(event) {
    var player = event.target;
    var $iframe = $( player.getIframe() ); // Get jQuery wrapped iframe

    // Poll to wait for the video data to be loaded
    var checkTitleInterval = setInterval(function() {
      var videoData = player.getVideoData();

      if (videoData && videoData.title) {
        var videoTitle = 'Video: ' + videoData.title; // Prepend for clarity
        clearInterval(checkTitleInterval);

        // FIX 6: Always set BOTH title and aria-label with the fetched,
        // specific title
        $iframe.prop('title', videoTitle);
        $iframe.attr('aria-label', videoTitle);
      }
    }, 100);
  }

  // Assign the initialization function to the required global callback
  window.onYouTubeIframeAPIReady = initYouTubePlayers;

  // Dynamically load the YouTube IFrame Player API script
  if ($('iframe.youtube-video[src*="enablejsapi=1"]').length) {
    var tag = document.createElement('script');
    tag.src = "https://www.youtube.com/iframe_api";
    var firstScriptTag = document.getElementsByTagName('script')[0];
    firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);
  }
})(jQuery);


// =========================================================
// SOUNDCLOUD TITLE FETCH FUNCTION
// Fetches the actual title using the SC Widget API
// =========================================================
(function($) {

  // We can dynamically load the API script to ensure it's present
  function loadSoundcloudAPI() {
    if (typeof SC === 'undefined' || typeof SC.Widget !== 'function') {
      var tag = document.createElement('script');
      tag.src = "https://w.soundcloud.com/player/api.js";
      document.body.appendChild(tag);
    }
    // Then, wait for it to load before attempting to run the init function
    setTimeout(initSoundcloudPlayers, 200);
  }

  function initSoundcloudPlayers() {
    // Check for the API after the potential load/delay
    if (typeof SC === 'undefined' || typeof SC.Widget !== 'function') {
      console.warn(
        "Soundcloud Widget API is still not available after attempt."
      );
      return;
    }

    // --- Select all iframes with the NEW class from PHP ---
    $("iframe.soundcloud-embed[src^='https://w.soundcloud.com']").each(
      function() {
        var $this = $( this );
        var iframe = this;

        // Assign a unique ID if one doesn't exist (required by SC.Widget)
        if (!iframe.id) {
          iframe.id = 'scplayer-' + Math.random().toString(36).substr(2, 9);
        }

        var widget = SC.Widget(iframe);

        // Bind an event to run once the widget is ready
        widget.bind(SC.Widget.Events.READY, function() {

          // Fetch the current track information
          widget.getCurrentSound(function(sound) {
            if (sound && sound.title) {
              var trackTitle = 'Audio: ' + sound.title; // Prepend
              var currentTitle = $this.attr("title");

              // FIX 7: Always set BOTH title and aria-label with the
              // fetched, specific title
              $this.prop('title', trackTitle);
              $this.attr('aria-label', trackTitle);
            }
          });
        });
      }
    );
  }

  // Start the process: check/load API and then initialize players
  if ($("iframe.soundcloud-embed[src^='https://w.soundcloud.com']").length) {
    loadSoundcloudAPI();
  }

})(jQuery);


// =========================================================
// VIMEO TITLE FETCH FUNCTION (NEW CHUNK)
// Fetches the actual title using the Vimeo Player API
// =========================================================
(function($) {

  // Function to initialize players once the Vimeo API is ready
  function initVimeoPlayers() {
    // Check for the Vimeo Player object
    if (typeof Vimeo === 'undefined' || typeof Vimeo.Player !== 'function') {
      // Re-attempt initialization after a short delay if the API isn't
      // quite ready
      setTimeout(initVimeoPlayers, 200);
      return;
    }

    // Select all iframes with the required class and API parameter
    $('iframe.vimeo-embed[src*="api=1"]').each(function() {
      var $this = $( this );
      var iframe = this;

      // Create a new Vimeo Player instance using the iframe (or its ID)
      var player = new Vimeo.Player(iframe);

      // Wait for the player to be ready, then fetch the title
      player.ready().then(function() {

        // Use the Vimeo API method to get the video title
        player.getVideoTitle().then(function(title) {
          var videoTitle = 'Video: ' + title; // Prepend for clarity

          // FIX 8: Set BOTH title and aria-label with the fetched,
          // specific title
          $this.prop('title', videoTitle);
          $this.attr('aria-label', videoTitle);

        }).catch(function(error) {
          console.error("Vimeo API Error fetching title:", error);
        });
      });
    });
  }

  // Function to dynamically load the Vimeo Player API script
  function loadVimeoAPI() {
    if (typeof Vimeo === 'undefined' || typeof Vimeo.Player !== 'function') {
      var tag = document.createElement('script');
      tag.src = "https://player.vimeo.com/api/player.js";
      var firstScriptTag = document.getElementsByTagName('script')[0] ||
        document.body.firstChild;
      firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);
    }
    // Start the initialization process (which includes a check/delay)
    initVimeoPlayers();
  }

  // Start the process only if there are Vimeo embeds present on the page
  if ($('iframe.vimeo-embed[src*="api=1"]').length) {
    loadVimeoAPI();
  }

})(jQuery);


// =========================================================
// FIGURE IMAGE ALT ATTRIBUTE FIX (REMAINS THE SAME)
// Ensures decorative images have alt="" for screen readers
// =========================================================
(function($) {
  // Loop through all images inside a <figure> element
  $("figure img").each(function() {
    var $this = $( this );
    var altText = $this.attr('alt');

    // Check if the alt attribute is missing (undefined) or empty/whitespace
    if (typeof altText === 'undefined' || altText.trim() === '') {
      // Setting alt="" tells screen readers to ignore the image (i.e.,
      // it's decorative)
      $this.attr('alt', '');
    }
  });
})(jQuery);