<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Strata_Three
 */

get_header();

# Check if the page content area needs to be adjusted
$content = s3_layout_content();
$content_format = s3_content_format($content);

// Check if the page needs to be adjusted for a sidebar
$sidebar = s3_layout_sidebar();
$sidebar_format = s3_sidebar_format($sidebar, 'second');

$breadcrumbs = s3_breadcrumbs();
#echo $breadcrumbs['first'];
?>


<?php
// check if the flexible content field has rows of data
if ( $content = have_rows('content_above') ) {
	echo acf_content_flexible($content, 'content_above');
}
?>


<div class="s3-<?php echo _SITE_CONTENT; ?>">
<?php #echo $breadcrumbs['second']; ?>


<?php
	echo $content_format;

	# Creates the properly columned div
	if ($sidebar['sidebar'] == 'yes') {
		echo $sidebar_format['content'];
	} else {
		echo $sidebar_format;
	}
?>


<!-- Index page: Begin -->
<main id="content">
		<?php if ( have_posts() ) : ?>

			<?php if ( is_home() && ! is_front_page() ) : ?>
				<header>
					<h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
				</header>
			<?php endif; ?>

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>

				<?php
					// Is this the first post of the front page?
					$first_post = $wp_query->current_post == 0 && !is_paged() && is_front_page();
					/*
					 * Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					if ( $first_post == true ) {
						get_template_part( 'template-parts/content', 'single' );
					} else {
						get_template_part( 'template-parts/content', get_post_format() );
					}

				?>

			<?php endwhile; ?>

			<div class="clearfix"></div>

			<?php s3_paging_nav(); ?>

		<?php else : ?>

			<?php get_template_part( 'template-parts/content', 'none' ); ?>

		<?php endif; ?>
</main>
<!-- Index page: End -->


		</div><!-- /sidebar or primary content div -->

<?php
if ($sidebar['sidebar'] == 'yes') {
	echo $sidebar_format['sidebar'];
	get_sidebar($sidebar['widget']);
	echo '</div>';
}
?>
		</div><!-- .row -->
	</div><!-- .content -->
</div><!-- s3-<?php echo _SITE_CONTENT; ?> -->


<?php
// check if the flexible content field has rows of data
if ( $content = have_rows('content_below') ) {
	echo acf_content_flexible($content, 'content_below');
}
?>


<?php
get_footer();



