<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Strata_Three
 */

# Advanced Custom Fields Dependencies
require get_template_directory() . '/inc/acf/acf.php';
require get_template_directory() . '/inc/acf/acf-fields.php';
acf_s3_fields();
require get_template_directory() . '/inc/acf/acf-content-format.php';
require get_template_directory() . '/inc/acf/acf-options.php';

# Display Var (A debug helper)
require get_template_directory() . '/inc/s3/s3-displayVar.php';

# Post Thumbnails
require get_template_directory() . '/inc/s3/s3-post-thumbnails.php';

# Shortcodes
require get_template_directory() . '/inc/s3/s3-shortcodes.php';

# Breadcrumbs
require get_template_directory() . '/inc/s3/s3-breadcrumbs.php';

# Columns
require get_template_directory() . '/inc/s3/s3-columns.php';

# Content Formatting
require get_template_directory() . '/inc/s3/s3-content-format.php';

# Custom
require get_template_directory() . '/inc/s3/s3-custom.php';

# Decoration (404, Search)
require get_template_directory() . '/inc/s3/s3-decoration.php';

# Entry Footer
require get_template_directory() . '/inc/s3/s3-entry-footer.php';

# Featured Image
require get_template_directory() . '/inc/s3/s3-featured-image.php';

# Featured Image in RSS2 Feeds
require get_template_directory() . '/inc/s3/s3-featured-image-rss2.php';

# Featured Image Thumb
require get_template_directory() . '/inc/s3/s3-featured-image-thumb.php';

# Footer
require get_template_directory() . '/inc/s3/s3-footer.php';

# Site Logo
require get_template_directory() . '/inc/s3/s3-globals.php';

# Posted On Format
require get_template_directory() . '/inc/s3/s3-index-posted-on.php';

# Layout: Content
require get_template_directory() . '/inc/s3/s3-layout-content.php';

# Layout: Sidebar
require get_template_directory() . '/inc/s3/s3-layout-sidebar.php';

# Navigation placement and walker
require get_template_directory() . '/inc/s3/s3-navigation.php';

# Paging Navigation
require get_template_directory() . '/inc/s3/s3-paging-nav.php';

# Posted On
require get_template_directory() . '/inc/s3/s3-posted-on.php';

# Sidebar Formatting
require get_template_directory() . '/inc/s3/s3-sidebar-format.php';

# Utility
require get_template_directory() . '/inc/s3/s3-utilities.php';

# Navigation placement and walker
require get_template_directory() . '/inc/s3/s3-wp-bootstrap-navwalker.php';





/**
 * Returns true if a blog has more than 1 category.
 *
 * @return bool
 */
function s3_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 's3_categories' ) ) ) {
		// Create an array of all the categories that are attached to posts.
		$all_the_cool_cats = get_categories( array(
			'fields'     => 'ids',
			'hide_empty' => 1,
			// We only need to know if there is more than one category.
			'number'     => 2,
		) );

		// Count the number of categories that are attached to the posts.
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 's3_categories', $all_the_cool_cats );
	}

	if ( $all_the_cool_cats > 1 ) {
		// This blog has more than 1 category so s3_categorized_blog should return true.
		return true;
	} else {
		// This blog has only 1 category so s3_categorized_blog should return false.
		return false;
	}
}

/**
 * Flush out the transients used in s3_categorized_blog.
 */
function s3_category_transient_flusher() {
	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}
	// Like, beat it. Dig?
	delete_transient( 's3_categories' );
}
add_action( 'edit_category', 's3_category_transient_flusher' );
add_action( 'save_post',     's3_category_transient_flusher' );


