<?php

# Not hookable
# Site Globals ties into ACF Pro to adjust the default background for the strata.
function site_utilities() {
#	if (is_plugin_active('advanced-custom-fields-pro/acf.php') && function_exists('get_field')) {
	if (function_exists('get_field')) {

		$count = 0;
		if ($utilities = get_field('utility', 'options')) {
			# Process the added utilities
			foreach ($utilities as $key => $value) {
				# Create a random token
				if ($value['type'] == 'drawer') {
					# Create the Icons
					$output[$count]['icon']  = '<li><a data-toggle="collapse" data-parent=".fsu-utilities" href="#fsu-utility-' . $count . '" aria-expanded="false" aria-controls="fsu-utility-' . $count . '" aria-label="' . $value['name'] . '"><span class="fa ' . $value['icon'] . '"></span><span class="hidden">' . $value['name'] . '</span></a></li>' . "\n";
					# Create the drawers
					$output[$count]['drawer']  = '<div id="fsu-utility-' . $count . '" class="s3 s3-' . _SITE_GLOBAL . ' collapse" aria-expanded="false">' . "\n";
					$output[$count]['drawer'] .= '	<div class="container">' . "\n";
					$output[$count]['drawer'] .= '		<div class="s3-m-8">' . "\n";
					$output[$count]['drawer'] .= '			<div class="row">' . "\n";
					$output[$count]['drawer'] .= $value['drawer'] . "\n";
					$output[$count]['drawer'] .= '			</div>' . "\n";
					$output[$count]['drawer'] .= '		</div>' . "\n";
					$output[$count]['drawer'] .= '	</div>' . "\n";
					$output[$count]['drawer'] .= '</div>' . "\n";
				} elseif ($value['type'] == 'link') {
					$output[$count]['icon']  .= '<li><a href="' . $value['link'] . '" target="' . $value['link_destination'] . '" aria-label="' . $value['name'] . '"><span class="fa ' . $value['icon'] . '"></span><span class="hidden">' . $value['name'] . '</span></a></li>' . "\n";
				}
				$count++;
			}
		}

		# Add the default utilities of webmail and the search, if selected
		if (!$default_utilities = get_field('utilities_default', 'options')) {
			$default_utilities = array('search', 'webmail');
		}
		if ($default_utilities) {
			# Check for the Search Utility
			if (in_array('search', $default_utilities)) {
				# Create the icons
				$output[$count]['icon'] = '<li><a data-toggle="collapse" data-parent=".fsu-utilities" href="#fsu-search" aria-expanded="false" aria-controls="fsu-search" aria-label="Search"><span class="fa fa-search"></span><span class="hidden">Search FSU</span></a></li>' . "\n";

				# Create the drawers
				$output[$count]['drawer']  = '<div aria-expanded="false" class="s3-' . _SITE_GLOBAL . ' collapse" id="fsu-search" >' . "\n";
				$output[$count]['drawer'] .= '	<div class="container">' . "\n";
				$output[$count]['drawer'] .= '    	<div class="s3-m-8">' . "\n";
				$output[$count]['drawer'] .= '        	<div class="row">' . "\n";
				$output[$count]['drawer'] .= '            	<div class="col-md-5 col-md-offset-7">' . "\n";
				$output[$count]['drawer'] .= '					<div class="row">' . "\n";
				$output[$count]['drawer'] .= '						<div class="col-sm-12 small text-right">' . "\n";

                $output[$count]['drawer'] .= '<h2 id="form-search" class="sr-only">Search FSU</h2>';
				$output[$count]['drawer'] .= '<form role="search" aria-labelledby="form-search" class="headerSearchForm" method="get" onsubmit="return FSU_search(type.value, FSU_URLEncode(keywords.value));" action="">' . "\n";
				$output[$count]['drawer'] .= '	<select name="type" title="Select Search Type" class="headerSearchSelect s3-m-3" style="height:27px">' . "\n";
				$output[$count]['drawer'] .= '    	<option selected="selected" value="SITE">This Site</option>' . "\n";
				$output[$count]['drawer'] .= '    	<option value="GOOGLE">FSU Sites</option>' . "\n";
				// $output[$count]['drawer'] .= '		<option value="PHFST">Student Directory</option>' . "\n";
				$output[$count]['drawer'] .= '		<option value="PHF">Faculty &amp; Staff Directory</option>' . "\n";
				$output[$count]['drawer'] .= '		<option value="DEPT">Departments &amp; Services</option>' . "\n";
				$output[$count]['drawer'] .= '	</select>' . "\n";
				$output[$count]['drawer'] .= '	<br class="visible-sm" />' . "\n";
				$output[$count]['drawer'] .= '    <input type="text" name="keywords" value="" title="Search Input Box" size="20" class="headerSearchBox" />' . "\n";
				$output[$count]['drawer'] .= '	<input type="submit" name="fsuSearch" value="Search" title="Submit Search" class="headerSearchBtn btn btn-sm btn-success s3-m-3" />' . "\n";
				$output[$count]['drawer'] .= '</form>' . "\n";
				$output[$count]['drawer'] .= '<a class="sr-only sr-only-focusable btn btn-tab btn-sm" aria-controls="fsu-search" aria-expanded="false" aria-label="Close Search" data-parent=".fsu-utilities" data-toggle="collapse" href="#fsu-search" title="Close Search">Close Search</a>' . "\n";
				
				
				$output[$count]['drawer'] .= '						</div>' . "\n";
				$output[$count]['drawer'] .= '					</div>' . "\n";
				$output[$count]['drawer'] .= '				</div>' . "\n";
				$output[$count]['drawer'] .= '			</div>' . "\n";
				$output[$count]['drawer'] .= '		</div>' . "\n";
				$output[$count]['drawer'] .= '	</div>' . "\n";
				$output[$count]['drawer'] .= '</div>' . "\n";
				$count++;
			}

			# Check for the Search Utility
			if (in_array('webmail', $default_utilities)) {
				$output[$count]['icon'] = '<li><a href="https://webmail.fsu.edu/" title="FSU Webmail" aria-label="FSU Webmail"><span class="fa fa-envelope"></span><span class="hidden">Webmail</span></a></li>' . "\n";
				$count++;
			}

		}

		if (isset($output)) {
			return $output;
		} else {
			return false;
		}

	} else {
		return false;
	}
}



# Display the utilities
function site_utilities_format($input, $mode) {
	if ($mode == 'icons') {
		foreach ($input as $key => $value) {
			echo $value['icon'];
		}
	}
	if ($mode == 'drawers') {
		foreach ($input as $key => $value) {
			if (isset($value['drawer'])) {
				echo $value['drawer'];
			}
		}
	}
}


















