<?php

if ( ! function_exists( 's3_sidebar_format' ) ) {

	# Formats the sidebar location
	function s3_sidebar_format($input, $flow='second') {
		if ($input['sidebar'] == 'no') {
			$output = '<div class="col-xs-12">';
		} else {
			$output = array();
			switch($input['columns']) {
				case '2':
					$sidebar = '2';
					$content = '10';
					break;
				case '4':
					$sidebar = '4';
					$content = '8';
					break;
				case '5':
					$sidebar = '5';
					$content = '7';
					break;
				case '6':
					$sidebar = '6';
					$content = '6';
					break;
				default: /* case '3' */
					$sidebar = '3';
					$content = '9';
					break;
			}

			if ( ($input['location'] == 'right') && ($flow == 'first') ) {
				$the_sidebar = 'col-sm-' . $sidebar . ' col-sm-push-' . $content;
				$the_content = 'col-sm-' . $content . ' col-sm-pull-' . $sidebar;
			}

			if ( ($input['location'] == 'right') && ($flow == 'second') ) {
				$the_sidebar = 'col-sm-' . $sidebar;
				$the_content = 'col-sm-' . $content;
			}

			if ( ($input['location'] == 'left') && ($flow == 'first') ) {
				$the_sidebar = 'col-sm-' . $sidebar;
				$the_content = 'col-sm-' . $content;
			}

			if ( ($input['location'] == 'left') && ($flow == 'second') ) {
				$the_sidebar = 'col-sm-' . $sidebar . ' col-sm-pull-' . $content;
				$the_content = 'col-sm-' . $content . ' col-sm-push-' . $sidebar;
			}

			$output['sidebar'] = '<div class="col-xs-12 ' . $the_sidebar . '">';
			$output['content'] = '<div class="col-xs-12 ' . $the_content . '">';
		}

		return $output;
	}

}



