<?php

if ( ! function_exists( 's3_posted_on' ) ) {
	/**
	 * Prints HTML with meta information for the current post-date/time and author.
	 */
	function s3_posted_on($overrides=array()) {
		$args = array (
			'author'   => true,
			'date'     => true,
			'time'     => true,
		);
		foreach ($overrides as $key => $value) {
			$args[$key] = $value;
		}

		# Byline
		if ($args['author']) {
			if (is_single() && (function_exists('get_field'))) {
				if ($authors_data = get_field('authors')) {
					foreach ($authors_data as $key => $value) {
						if ($value['email']) {
							$authors[] = '<a href="mailto:' . $value['email'] . '">' . $value['name'] . '</a>';
						} else {
							$authors[] = $value['name'];
						}
					}
					$published[] = 'By: ' . implode(', ', $authors);
				}
			}
		}

		# Date
		if ($args['date']) {
			$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
			$time_string = sprintf ( $time_string,
				esc_attr( get_the_date( 'c' ) ),
				esc_html( get_the_date() ),
				esc_attr( get_the_modified_date( 'c' ) ),
				esc_html( get_the_modified_date() )
			);
			$published[] = sprintf (
				esc_html_x( 'Published: %s', 'post date', 's3' ), '<strong>' . $time_string . '</strong>'
			);
		}

		# Time
		if ($args['time']) {
			$published[] = '<span class="fa fa-clock"></span> ' .  get_the_time();
		}

		# Categories
		if (is_search()) {
			$categories_list = get_the_category_list( esc_html__( ', ', 's3' ) );
			if ( $categories_list && s3_categorized_blog() ) {
				$published[] = sprintf( '<span class="cat-links">' . esc_html__( 'Posted in: %1$s', 's3' ) . '</span>', $categories_list ); // WPCS: XSS OK.
			}
		}

		# Display
		$output = '<p><span class="posted-on">' . implode(' | ', $published) . '</span></p>';
		echo $output;

	}

}



