<?php

/*
 * Register Post Thumbnails
 * http://codex.wordpress.org/Function_Reference/add_image_size
 * add_image_size( $name, $width, $height, $crop );
 */
if (function_exists('add_theme_support')) {
	add_theme_support('post-thumbnails');

	add_image_size('s3-sm-1x1',   768,   768, true);
	add_image_size('s3-sm-3x1',   900,   300, true);
	add_image_size('s3-sm-3x2',   900,   600, true);
	add_image_size('s3-sm-16x9',  800,   450, true);

	add_image_size('s3-md-1x1',  1200,  1200, true);
	add_image_size('s3-md-3x1',  1200,   400, true);
	add_image_size('s3-md-3x2',  1200,   800, true);
	add_image_size('s3-md-16x9', 1600,   900, true);

	add_image_size('s3-lg-1x1',  1800,  1800, true);
	add_image_size('s3-lg-3x1',  1800,   600, true);
	add_image_size('s3-lg-3x2',  1800,  1200, true);
	add_image_size('s3-lg-16x9', 2400,  1350, true);
}



/*
 * Add image sizes to media upload
 */
function display_image_sizes($sizes) {
	$sizes['s3-sm-1x1']  = __( 'Square 2x1' );
	$sizes['s3-sm-3x1']  = __( 'Small 3x1' );
	$sizes['s3-sm-3x2']  = __( 'Small 3x2' );
	$sizes['s3-sm-16x9'] = __( 'Small 16x9' );

	$sizes['s3-md-1x1']  = __( 'Square 1x1' );
	$sizes['s3-md-3x1']  = __( 'Medium 3x1' );
	$sizes['s3-md-3x2']  = __( 'Medium 3x2' );
	$sizes['s3-md-16x9'] = __( 'Medium 16x9' );

	$sizes['s3-lg-1x1']  = __( 'Large 1x1' );
	$sizes['s3-lg-3x1']  = __( 'Large 3x1' );
	$sizes['s3-lg-3x2']  = __( 'Large 3x2' );
	$sizes['s3-lg-16x9'] = __( 'Large 16x9' );
	return $sizes;
}
add_filter('image_size_names_choose', 'display_image_sizes');



/*
 * Remove the automatic width and height from emebedded images to help with responsiveness
 * See also: http://wordpress.stackexchange.com/questions/32931/removing-image-and-caption-dimension-attributes/37768#37768
 */
function remove_width_attribute( $html ) {
   $html = preg_replace( '/(width|height)="\d*"\s/', "", $html );
   return $html;
}
add_filter( 'post_thumbnail_html', 'remove_width_attribute', 10 );
add_filter( 'image_send_to_editor', 'remove_width_attribute', 10 );



