<?php

# Pagination for post pages
if ( ! function_exists( 's3_paging_nav' ) ) {
	/**
	 * Display navigation to next/previous set of posts when applicable.
	 *
	 * @since Twenty Fourteen 1.0
	 *
	 * @global WP_Query   $wp_query   WordPress Query object.
	 * @global WP_Rewrite $wp_rewrite WordPress Rewrite object.
	 */
	function s3_paging_nav() {
		global $wp_query, $wp_rewrite;

		// Don't print empty markup if there's only one page.
		if ( $wp_query->max_num_pages < 2 ) {
			return;
		}

		$paged        = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
		$pagenum_link = html_entity_decode( get_pagenum_link() );
		$query_args   = array();
		$url_parts    = explode( '?', $pagenum_link );

		if ( isset( $url_parts[1] ) ) {
			wp_parse_str( $url_parts[1], $query_args );
		}

		$pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
		$pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

		$format  = $wp_rewrite->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
		$format .= $wp_rewrite->using_permalinks() ? user_trailingslashit( $wp_rewrite->pagination_base . '/%#%', 'paged' ) : '?paged=%#%';

		// Set up paginated links.
		$links = paginate_links( array(
			'base'          => $pagenum_link,
			'format'        => $format,
			'total'         => $wp_query->max_num_pages,
			'current'       => $paged,
			'mid_size'      => 3,
			'add_args'      => array_map( 'urlencode', $query_args ),
			'prev_text'     => __( '<span class="fa fa-angle-left" title="Previous"></span>', 's3' ),
			'next_text'     => __( '<span class="fa fa-angle-right" title="Next"></span>', 's3' ),
			'type'		    => 'array',
		) );
		if( is_array( $links ) ) {
	        $list[] = '<ul class="pagination text-center">';
	        foreach ( $links as $link ) {
				$list[] = '<li';
				if (strpos($link, 'current')) {
					$list[] = ' class="active"';
				}
				$list[] = '>' . $link . '</li>';
	        }
	       $list[] = '</ul>';
	        }
		if ( $links ) {

		?>
	<hr class="s3-m-b0" />
	<nav class="text-center" aria-labelledby="pagination">
		<h2 class="screen-reader-text" id="pagination"><?php _e( 'Posts Navigation', 's3' ); ?></h2>
		<?php echo implode($list); ?>
	</nav>

		<?php
		}
	}

}



