<?php

if ( ! function_exists( 's3_layout_sidebar' ) ) {

	# Sidebar defaults and formatting
	function s3_layout_sidebar($item = 'all') {
		# Sidebar Defaults
		$sidebar = array (
			'sidebar'  => 'yes',
			'location' => 'left',
			'columns'  => '3',
			'widget'   => 'sidebar',
		);

		# Check for ACF sidebar options
		if (function_exists('get_field')) {
			if ($layout = get_field('main_content_sidebar')) {
				if (is_array($layout)) {
					$output = $layout[0];
					foreach ($output as $key => $value) {
						if (is_array($output[$key])) {
							$output[$key] = $output[$key][0];
						}
					}
					$output['widget'] = 'sidebar' . '-' . $output['widget'];
					# There is not sidebar-1, only sidebar.
					if ($output['widget'] == 'sidebar-1') {
						$output['widget'] = 'sidebar';
					}
				} else {
					$output = $sidebar;
				}
			} else {
				# Default in case ACF is not loaded
				$output = $sidebar;
			}
		} else {
			# Default in case ACF is not loaded
			$output = $sidebar;
		}

		# Pull a specific key value or return all
		if ( ($item != 'all') && (key_exists($item, $output)) ) {
			return $output[$item];
		} else {
			return $output;
		}
	}

}



