<?php

if ( ! function_exists( 's3_index_posted_on' ) ) {

	# Prints HTML with meta information for post-date/time and author on index pages.
	function s3_index_posted_on($overrides=array()) {
		$args = array (
			'author'   => true,
			'date'     => true,
			'time'     => true,
			'location' => 'prepend',
			'content'  => false,
		);

		if ($overrides) {
			foreach ($overrides as $key => $value) {
				$args[$key] = $value;
			}
		}
		# Date
		$time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';
		$time_string = sprintf ( $time_string,
			esc_attr( get_the_date( 'c' ) ),
			esc_html( get_the_date() ),
			esc_attr( get_the_modified_date( 'c' ) ),
			esc_html( get_the_modified_date() )
		);
		if ($args['date']) {
			$published[] = sprintf (
				esc_html_x( 'Published: %s', 'post date', 's3' ), '<strong>' . $time_string . '</strong>' );
		}

		# Time
		if ($args['time']) {
			$published[] = '<span class="far fa-clock"></span> ' .  get_the_time();
		}


		# Categories
		if (is_search() || is_archive()) {
			$categories_list = get_the_category_list( esc_html__( ', ', 's3' ) );
			if ( $categories_list && s3_categorized_blog() ) {
				$published[] = sprintf( '<span class="cat-links">' . esc_html__( 'Posted in: %1$s', 's3' ) . '</span>', $categories_list ); // WPCS: XSS OK.
			}
		}

		# $input
		if ($args['content']) {
			if ($args['location'] == 'prepend') {
				array_unshift($published, $args['content']);
			} else {
				$published[] = $args['content'];
			}
		}

		# Display
		echo '<span class="posted-on">' . implode(' | ', $published);
		# Comments
		if ( ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			comments_popup_link( esc_html__( ' | Leave a comment', 's3' ), esc_html__( ' | 1 Comment', 's3' ), esc_html__( ' | % Comments', 's3' ) );
		}
		echo '</span>';

	}

}



