<?php

# Not hookable
# Site Globals ties into ACF Pro to adjust the default background for the strata.
function site_globals() {
	$site = array (
		'seal'          => 'fsu-seal-3d-160x160.png',
		'body'          => 'gt',
		'global'        => 'gt',
		'utilities'     => 'gt',
		'masthead'      => 'c',
		'navigation'    => 'c',
		'breadcrumbs'   => 'w',
		'content_above' => 'w',
		'content'       => 'w',
		'content_below' => 'w',
		'posts'         => 'c',
		'buttons'       => 'n2w',
		'highlights'    => 'gd3c',
		'footer'        => 'gt',
		'gallery_type'  => 'fresco',
	);


#	if (is_plugin_active('advanced-custom-fields-pro/acf.php') && function_exists('get_field')) {
  add_action('acf/init', function() {
    if (function_exists('get_field')) {
      if ($site_seal = get_field('site_seal', 'option')) {
        $site['seal'] = $site_seal;
      }

      if ($site_body = get_field('site_body', 'option')) {
        $site['body'] = $site_body;
        $site['footer'] = $site_body; # Site Body and Footer must be the same to keep short pages a solid color instead of a stripe
      }

      if ($site_global = get_field('site_global', 'option')) {
        $site['global']    = $site_global;
        $site['utilities'] = $site_global;
      }

      if ($site_masthead = get_field('site_masthead', 'option')) {
        $site['masthead'] = $site_masthead;
      }

      if ($site_navigation = get_field('site_navigation', 'option')) {
        $site['navigation'] = $site_navigation;
      }

      if ($site_content = get_field('site_content', 'option')) {
        $site['content_above'] = $site_content;
        $site['breadcrumbs']   = $site_content;
        $site['content']       = $site_content;
        $site['content_below'] = $site_content;
      }

      if ($site_posts = get_field('site_posts', 'option')) {
        $site['posts'] = $site_posts;
      }

      if ($site_buttons = get_field('site_buttons', 'option')) {
        $site['buttons'] = $site_buttons;
      }

      if ($site_highlights = get_field('site_highlights', 'option')) {
        $site['highlights'] = $site_highlights;
      }

      if ($scored = get_field('strata_scored', 'option')) {
        foreach ($scored as $key => $value) {
          $site[$value] .= ' s3-scored';
        }
      }

      if ($site_gallery_type = get_field('site_gallery_type', 'option')) {
        $site['gallery_type'] = $site_gallery_type;
      }

    } # ACF Pro Check
  });
	# Set up the site constants
	define ('_SITE_SEAL',          $site['seal']);
	define ('_SITE_BODY',          $site['body']);
	define ('_SITE_GLOBAL',        $site['global']);
	define ('_SITE_UTILITIES',     $site['utilities']);
	define ('_SITE_MASTHEAD',      $site['masthead']);
	define ('_SITE_NAVIGATION',    $site['navigation']);
	define ('_SITE_CONTENT_ABOVE', $site['content_above']);
	define ('_SITE_BREADCRUMBS',   $site['content_above']);
	define ('_SITE_CONTENT',       $site['content']);
	define ('_SITE_CONTENT_BELOW', $site['content_below']);
	define ('_SITE_POSTS',         $site['posts']);
	define ('_SITE_BUTTONS',       $site['buttons']);
	define ('_SITE_HIGHLIGHTS',    $site['highlights']);
	define ('_SITE_FOOTER',        $site['footer']);
	define ('_SITE_GALLERY_TYPE',  $site['gallery_type']);


}
site_globals();



