<?php

# Not hookable
# Site Footer ties into ACF Pro to adjust the default background for the strata.
if ( ! function_exists( 'site_footer' ) ) {
  function site_footer() {
  #	if (is_plugin_active('advanced-custom-fields-pro/acf.php') && function_exists('get_field')) {
    if (function_exists('get_field')) {
      $output = '';
      if ($footer_columns = get_field('footer_columns', 'option')) {
        $columns = $footer_columns;
      } else {
        $columns = 1;
      }

      if ($footer = get_field('footer', 'option')) {
        # Process the footer
        $output .= '	<div class="s3-' . _SITE_FOOTER . '">' . "\n";
        $output .= '    	<div class="container">' . "\n";
        $output .= '    		<div class="row s3-mt-10 s3-mb-8 small">' . "\n";

        $count = 1;
        foreach ($footer as $key => $value) {
          $value['code']    = do_shortcode($value['code']);
          $value['wysiwyg'] = do_shortcode($value['wysiwyg']);
          $output .= site_columns(site_footer_format($value), $columns, $count, true);
          $count++;
        }

        $output .= '			</div>' . "\n";
        $output .= '		</div>' . "\n";
        $output .= '	</div>' . "\n";
      }

      return $output;
    } else {
      return false;
    }
  }


  # Display the site footer
  function site_footer_format ($input) {
    if ($input['content_type'] == 'code') {
      $output = $input['code'];
    } elseif ($input['content_type'] == 'wysiwyg') {
      $output = $input['wysiwyg'];
    }

    return $output;
  }

}