<?php

if ( ! function_exists( 's3_featured_image' ) ) {

	# Displays a featured image thumb
	function s3_featured_image ($post, $first_post) {
		$output         = '';
		$fi_ratio   = 's3-md-1x1';
		$fi_display = 'alignleft';
		$fi_display = 'none';

		if (function_exists('get_field')) {
			$fi_display = get_field('featured_image_display');
			$fi_ratio = 's3-md-' . get_field('featured_image_ratio');
		}
		if ($fi_display != 'none') {
			if ( has_post_thumbnail() ) {
				if ( $first_post == true ) {
					$output .= '<figure class="featured-image s3-' . _SITE_HIGHLIGHTS . ' s3-p-4 s3-bs s3-m-8">';
					$output .= '<a href="' . esc_url( get_permalink() ) . '" rel="bookmark">';
					$output .= get_the_post_thumbnail( $post->ID, $fi_ratio, array( 'class' => 'img-responsive ' . $fi_display ) );
					$output .= '</a>';
				} else {
					$output .= '<figure class="' . $fi_display . '">';
					$output .= get_the_post_thumbnail( $post->ID, $fi_ratio, array( 'class' => 'img-responsive' ) );
				}

				$thumbnail_id    = get_post_thumbnail_id($post->ID);
				$thumbnail_image = get_posts(array('p' => $thumbnail_id, 'post_type' => 'attachment'));
				if ($thumbnail_image && isset($thumbnail_image[0])) {
					$caption = $thumbnail_image[0]->post_excerpt;
				}

				if (isset($caption) && ($caption != '')) {
					$output .= '<figcaption class="wp-caption-text">' . $thumbnail_image[0]->post_excerpt . '</figcaption>';
				}
				$output .= '</figure>';
			}
		}
		return $output;

	}

}



