<?php

if ( ! function_exists( 's3_featured_image_rss2' ) ) {

	# Displays a featured image as an enclosure in RSS2 feeds
	function s3_add_featured_image_rss2() {
		$url       = get_template_directory_uri() . '/images/rss/enclosure.jpg';
		$file_path = get_template_directory() . '/images/rss/enclosure.jpg';
		$length    = '';
		$type      = '';
		$uploads   = wp_upload_dir();

		if ( function_exists('has_post_thumbnail') and has_post_thumbnail() ) {
#			if ($file = wp_get_attachment_image_src( get_post_thumbnail_id(), 'post-thumbnail' )) {
			if ($file = wp_get_attachment_image_src( get_post_thumbnail_id(), 's3-sm-3x2' )) {
				$url = $file[0];
			}
			$file_path = str_replace($uploads['baseurl'], $uploads['basedir'], $url);
		}

		if ($length = filesize($file_path)) {
			$length = ' length="' . $length . '"';
		}

		if ($size = getimagesize($url)) {
			$type = ' type="' . $size['mime'] . '"';
		}

		$https = "\t" . '<enclosure url="' . $url . '"' . $length . $type . '/>' . "\n\t";
		$http = str_replace('https://', 'http://', $https);
		echo $http;
	}
	add_action( 'rss2_item', 's3_add_featured_image_rss2' );

}



