<?php


if ( ! function_exists( 's3_entry_footer' ) ) {

	# Prints HTML with meta information for the categories, tags and comments.
	function s3_entry_footer() {
		// Hide category and tag text for pages.
		if ( 'post' === get_post_type() ) {
			/* translators: used between list items, there is a space after the comma */
			$categories_list = get_the_category_list( esc_html__( ', ', 's3' ) );
			if ( $categories_list && s3_categorized_blog() ) {
				printf( '<span class="cat-links">' . esc_html__( 'Posted in: %1$s', 's3' ) . '</span>', $categories_list ); // WPCS: XSS OK.
			}

			/* translators: used between list items, there is a space after the comma */
			$tags_list = get_the_tag_list( '', esc_html__( ', ', 's3' ) );
			if ( $tags_list ) {
				printf( ' | <span class="fa fa-tags"></span> <span class="tags-links">' . esc_html__( 'Tagged: %1$s', 's3' ) . '</span>', $tags_list ); // WPCS: XSS OK.
			}
		}

		edit_post_link (
			sprintf(
				/* translators: %s: Name of current post */
				esc_html__( 'Edit Entry %s', 's3' ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			),
			' | <span class="edit-link">',
			'</span>'
		);

		if ( ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ) {
			echo ' | <span class="comments-link">';
			comments_popup_link( esc_html__( 'Leave a comment', 's3' ), esc_html__( '1 Comment', 's3' ), esc_html__( '% Comments', 's3' ) );
			echo '</span><br />';
		}

	}
}



