<?php
// 1. customize ACF path
if ( ! function_exists( 'my_acf_settings_path' ) ) {
    add_filter('acf/settings/path', 'my_acf_settings_path');
    function my_acf_settings_path( $path ) {
        // update path
        $path = get_template_directory() . '/inc/acf/plugin/';

        // return
        return $path;
    }
}


// 2. customize ACF dir
if ( ! function_exists( 'my_acf_settings_dir' ) ) {
    add_filter('acf/settings/dir', 'my_acf_settings_dir');
    function my_acf_settings_dir( $dir ) {
        // update path
        $dir = get_template_directory_uri() . '/inc/acf/plugin/';

        // return
        return $dir;
    }
}


// 3. Hide ACF field group menu item
# Including the plugin check to make sure dependencies are loaded
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if (!is_plugin_active('advanced-custom-fields-pro/acf.php')) {
	add_filter('acf/settings/show_admin', '__return_false');
}


// 4. Include ACF
require_once( get_template_directory() . '/inc/acf/plugin/acf.php' );



