<?php

# Image Selector
if ( ! function_exists( 'acf_image_selector' ) ) {
	function acf_image_selector ($image, $size='lg', $ratio='3x2') {
	#	displayVar($image);
	#	displayVar($size);

		if (!$image) {
			return false;
		}

		# Immediately return the full image if it has been selected
		if ($ratio == 'full') {
			return $image['url'];
		}

		$sizes = array (
			's3-lg-' . $ratio,
			's3-md-' . $ratio,
			's3-sm-' . $ratio,
		);


		if ($size != 'lg') {
			unset($sizes[0]);
		}

		$selected = false;
		foreach ($sizes as $key => $value) {

			if (!$selected) {
				if (isset($image['sizes'][$value])) {
					if ( $image['sizes'][$value] == $image['url']) {
						continue;
					}
					if ( ($ratio == '1x1') && ($image['sizes'][$value . '-width'] != $image['sizes'][$value . '-height']) ) {
						continue;
					}
					if ( ($ratio == '2x1') && ($image['sizes'][$value . '-width'] != ($image['sizes'][$value . '-height']) * 2) ) {
						continue;
					}
					if ( ($ratio == '3x1') && ($image['sizes'][$value . '-width'] != ($image['sizes'][$value . '-height']) * 3) ) {
						continue;
					}
					if ( ($ratio == '3x2') && ( (($image['sizes'][$value . '-width']) * 2) != (($image['sizes'][$value . '-height']) * 3)) ) {
						continue;
					}
					if ( ($ratio == '4x1') && ($image['sizes'][$value . '-width'] != ($image['sizes'][$value . '-height']) * 4) ) {
						continue;
					}
					if ( ($ratio == '4x5') && ( (($image['sizes'][$value . '-width']) * 5) != (($image['sizes'][$value . '-height']) * 4)) ) {
						continue;
					}
					if ( ($ratio == '5x4') && ( (($image['sizes'][$value . '-width']) * 4) != (($image['sizes'][$value . '-height']) * 5)) ) {
						continue;
					}
					if ( ($ratio == '16x9') && ( (($image['sizes'][$value . '-width']) * 9) != (($image['sizes'][$value . '-height']) * 16)) ) {
						continue;
					}
					$selected = $image['sizes'][$value];
					continue;
				}
			}
		}

		if ($selected) {
			$output = $selected;
		} else {
			$output = $image['url'];
		}

		return $output;
	}
}



