<?php

if ( ! function_exists( 'acf_flexible_slider_6' ) ) {

	# Slider: Carousel
	function acf_flexible_slider_6 ($input) {
	#	displayVar($input);
		$output  = '';
		$output .= '<!-- acf_flexible_slider_6 -->';

		# Setting up Bootstrap columns based upon $value['column'] choices
		$columns = array (
			'3_9' => array (
				'slot_1_left'  => 'col-md-3',
				'slot_2_left'  => 'col-md-9',
				'slot_1_right' => 'col-md-3 col-md-push-9',
				'slot_2_right' => 'col-md-9 col-md-pull-3',
			),
			'4_8' => array (
				'slot_1_left'  => 'col-md-4',
				'slot_2_left'  => 'col-md-8',
				'slot_1_right' => 'col-md-4 col-md-push-8',
				'slot_2_right' => 'col-md-8 col-md-pull-4',
			),
		);

		if (isset($input['position'])) {
			if ($input['position'] == 'left') {
				$slot_1 = $columns[ $input['columns'] ]['slot_1_left'];
				$slot_2 = $columns[ $input['columns'] ]['slot_2_left'];
			} else {
				$slot_1 = $columns[ $input['columns'] ]['slot_1_right'];
				$slot_2 = $columns[ $input['columns'] ]['slot_2_right'];
			}
		} else {
			$slot_2 = 'col-xs-12';
		}


		$output .= '<div class="row">';
		if (isset($input['position'])) {
			$output .=     '<div class="col-xs-12 ' . $slot_1 . '">';
			$output .=         '<div class="s3-m-6">';
			$output .=             $input['message_content'];
			$output .=         '</div>';
			$output .=     '</div>';
		}
		$output .=     '<div class="col-xs-12 ' . $slot_2 . '">';
		$output .=         '<div class="row">';
		$output .=             '<div class="flexslider flexslider-carousel carousel-items-max-3 s3-flex-s ' . implode(' ', $input['arrows']) . '">';
		$output .=                 '<ul class="slides">';
		foreach ($input['slides'] as $key => $value) {
			$output .=                 '<li>';
			$output .=                     '<div class="col-sm-12">';
			if ($input['image']) {
				$output .=                         '<img src="' . $value['image'] . '" alt="' . $value['image_alt'] . '" class="img-responsive img-expand" />';
			}
			$output .=                         '<div class="s3-p-8 s3-' . $input['color'] . ' feature-fixed ' . $input['block_height'] . ' ">';
			$output .=                             $value['content'];
			$output .=                         '</div>';
			if ($input['embellishment'] != 'none') {
				$output .=                     '<img src="' . get_template_directory_uri() . '/s3.3/img/' . $input['embellishment'] . '/' . $input['embellishment'] . '-' . $input['color'] . '.png" class="img-responsive hidden-xs" alt="">';
			}
			$output .=                     '</div>';
			$output .=                  '</li>';
		}
		$output .=                 '</ul>';
		$output .=             '</div>';
		$output .=         '</div>';
		$output .=     '</div>';
		$output .= '</div>';

		$output .= '<!-- /acf_flexible_slider_6 -->';
		$output  = acf_flexible_container($input, $output);
		return $output;
	}

}



