<?php

if ( ! function_exists( 'acf_flexible_slider_5' ) ) {

	# Slider: Split With Static Message
	function acf_flexible_slider_5 ($input) {
	#	displayVar($input);
		$output  = '';
		$output .= '<!-- acf_flexible_slider_5 -->';

		# Ratios => Columns => Classes
		# The classes get applied to slot_2
		$ratios = array (
			'2x1' => array (
				'3_9' => 'fixed-2-1-col-3',
				'4_8' => 'fixed-2-1-col-4',
				'5_7' => 'fixed-2-1-col-5',
				'6_6' => 'fixed-2-1-col-6',
			),

			'3x2' => array (
				'3_9' => 'fixed-3-2-col-3',
				'4_8' => 'fixed-3-2-col-4',
				'6_6' => 'fixed-3-2-col-6',
			),

			'4x5' => array (
				'3_9' => 'fixed-4-5-col-3',
				'4_8' => 'fixed-4-5-col-4',
				'5_7' => 'fixed-4-5-col-5',
				'6_6' => 'fixed-4-5-col-6',
			),

			'5x4' => array (
				'3_9' => 'fixed-5-4-col-3',
				'4_8' => 'fixed-5-4-col-4',
				'5_7' => 'fixed-5-4-col-5',
				'6_6' => 'fixed-5-4-col-6',
			),
			'16x9' => array (
				'3_9' => 'fixed-16-9-col-3',
				'4_8' => 'fixed-16-9-col-4',
				'6_6' => 'fixed-16-9-col-6',
			),
		);

		# Setting up Bootstrap columns based upon $value['column'] choices
		$columns = array (
			'3_9' => array (
				'slot_1_left'  => 'col-md-9 col-md-push-3',
				'slot_2_left'  => 'col-md-3 col-md-pull-9',
				'slot_1_right' => 'col-md-9',
				'slot_2_right' => 'col-md-3',
			),
			'4_8' => array (
				'slot_1_left'  => 'col-md-8 col-md-push-4',
				'slot_2_left'  => 'col-md-4 col-md-pull-8',
				'slot_1_right' => 'col-md-8',
				'slot_2_right' => 'col-md-4',
			),
			'5_7' => array (
				'slot_1_left'  => 'col-md-7 col-md-push-5',
				'slot_2_left'  => 'col-md-5 col-md-pull-7',
				'slot_1_right' => 'col-md-7',
				'slot_2_right' => 'col-md-5',
			),
			'6_6' => array (
				'slot_1_left'  => 'col-md-6 col-md-push-6',
				'slot_2_left'  => 'col-md-6 col-md-pull-6',
				'slot_1_right' => 'col-md-6',
				'slot_2_right' => 'col-md-6',
			),
		);

		if ($input['position'] == 'left') {
			$slot_1 = $columns[ $input['columns'] ]['slot_1_left'];
			$slot_2 = $columns[ $input['columns'] ]['slot_2_left'];
		} else {
			$slot_1 = $columns[ $input['columns'] ]['slot_1_right'];
			$slot_2 = $columns[ $input['columns'] ]['slot_2_right'];
		}


		$output .= '<div class="col-xs-12">';
		$output .= '<div class="row s3-' . $input['color'] . '">';
		$output .=     '<div class="col-xs-12 ' . $slot_1 . ' s3-p-0">';
		$output .= 			'<div class="flexslider flexslider-centered slider-fade ' . implode(' ', $input['arrows']) . '">';
		$output .= 				'<ul class="slides">';

		# Loop through the slides and place them within <li>
		foreach ($input['images'] as $key => $value) {
			# First Colunn = Slot 1
			$output .=             '<li><img src="' . $value['graphic'] . '" alt="' . $value['alt'] . '" class="img-responsive img-expand" /></li>';
			# /First Colunn = Slot 1
		}
		$output .=             '</ul>';
		$output .=         '</div>';
		$output .=     '</div>';


		# Second Colunn = Slot 2
		# Slot 2 is the text input and gets a special class
		$output .=     '<div class="' . $slot_2 . ' ' . $ratios[  $input['image_ratio'] ][  $input['columns'] ] . ' s3-p-0 s3-' . $input['color'] . '">';
		$output .=         '<div class="wrap-table">';
		$output .=             '<div class="wrap-table-inner s3-p-10">';
		$output .=                 $input['content'];
		$output .=             '</div>';
		$output .=         '</div>';
		$output .=     '</div>';
		# /Second Colunn = Slot 2

		$output .= '</div>'; # .row
		$output .= '</div>'; # .row

		$output .= '<!-- /acf_flexible_slider_5 -->';
		$output  = acf_flexible_container($input, $output);
		return $output;
	}

}



