<?php

if ( ! function_exists( 'acf_flexible_slider_4' ) ) {

	# Slider: Split
	function acf_flexible_slider_4 ($input) {
		#displayVar($input);
		$output  = '';
		$output .= '<!-- acf_flexible_slider_4 -->';

		# Ratios => Columns => Classes
		# The classes get applied to slot_2
		$ratios = array (
			'2x1' => array (
				'3_9' => 'fixed-2-1-col-3',
				'4_8' => 'fixed-2-1-col-4',
				'5_7' => 'fixed-2-1-col-5',
				'6_6' => 'fixed-2-1-col-6',
			),

			'3x2' => array (
				'3_9' => 'fixed-3-2-col-3',
				'4_8' => 'fixed-3-2-col-4',
				'6_6' => 'fixed-3-2-col-6',
			),

			'4x5' => array (
				'3_9' => 'fixed-4-5-col-3',
				'4_8' => 'fixed-4-5-col-4',
				'5_7' => 'fixed-4-5-col-5',
				'6_6' => 'fixed-4-5-col-6',
			),

			'5x4' => array (
				'3_9' => 'fixed-5-4-col-3',
				'4_8' => 'fixed-5-4-col-4',
				'5_7' => 'fixed-5-4-col-5',
				'6_6' => 'fixed-5-4-col-6',
			),
			'16x9' => array (
				'3_9' => 'fixed-16-9-col-3',
				'4_8' => 'fixed-16-9-col-4',
				'6_6' => 'fixed-16-9-col-6',
			),
		);

		# Setting up Bootstrap columns based upon $value['column'] choices
		$columns = array (
			'3_9' => array (
				'slot_1_left'  => 'col-md-9 col-md-push-3',
				'slot_2_left'  => 'col-md-3 col-md-pull-9',
				'slot_1_right' => 'col-md-9',
				'slot_2_right' => 'col-md-3',
			),
			'4_8' => array (
				'slot_1_left'  => 'col-md-8 col-md-push-4',
				'slot_2_left'  => 'col-md-4 col-md-pull-8',
				'slot_1_right' => 'col-md-8',
				'slot_2_right' => 'col-md-4',
			),
			'5_7' => array (
				'slot_1_left'  => 'col-md-7 col-md-push-5',
				'slot_2_left'  => 'col-md-5 col-md-pull-7',
				'slot_1_right' => 'col-md-7',
				'slot_2_right' => 'col-md-5',
			),
			'6_6' => array (
				'slot_1_left'  => 'col-md-6 col-md-push-6',
				'slot_2_left'  => 'col-md-6 col-md-pull-6',
				'slot_1_right' => 'col-md-6',
				'slot_2_right' => 'col-md-6',
			),
		);

		$output .= '<div class="row">';
		$output .= 	'<div class="col-xs-12">';
		$output .= 			'<div class="flexslider slider-slide ' . implode(' ', $input['arrows']) . '">';
		$output .= 				'<ul class="slides">';

		# Loop through the slides and place them within <li>
		foreach ($input['content'] as $key => $value) {
			# Set the column widths. Right-positioned text gets a push/pull
			if ($value['position'] == 'left') {
				$slot_1 = $columns[ $input['columns'] ]['slot_1_left'];
				$slot_2 = $columns[ $input['columns'] ]['slot_2_left'];
			} else {
				$slot_1 = $columns[ $input['columns'] ]['slot_1_right'];
				$slot_2 = $columns[ $input['columns'] ]['slot_2_right'];
			}

			$output .= 				'<li class=" s3-' . $value['color'] . '">';
			$output .= 					'<div class="col-sm-12">';
			$output .= 						'<div class="row">';

			# First Colunn = Slot 1
			$output .= 							'<div class="' . $slot_1 . ' s3-p-0">';
			$output .=								'<img src="' . $value['image'] . '" alt="' . $value['image_alt'] . '" class="img-responsive img-expand" />';
			$output .= 							'</div>';
			# /First Colunn = Slot 1

			# Second Colunn = Slot 2
			# Slot 2 is the text input and gets a special class
			$output .= 							'<div class="' . $slot_2 . ' ' . $ratios[  $input['image_ratio'] ][  $input['columns'] ] . ' s3-p-0 s3-' . $value['color'] . '">';
			$output .= 								'<div class="wrap-table">';
			$output .= 									'<div class="wrap-table-inner s3-p-10">';
			if ($value['header']) {
					$output .=								'<h2>' . $value['header'] . '</h2>';
			}
			if ($value['paragraph']) {
				$output .=									'<p>' . $value['paragraph'] . '</p>';
			}
			if ($value['linked']) {
				$output .=									'<p><a href="' . $value['link'] . '" class="btn btn-link btn-go s3-' . $value['color'] . '">' . $value['link_text'] . '</a></p>';
			}
			$output .= 									'</div>';
			$output .= 								'</div>';
			$output .= 							'</div>';
			# /Second Colunn = Slot 2

			$output .= 						'</div>'; # .row
			$output .= 					'</div>';
			$output .= 				'</li>';
		}

		$output .= 				'</ul>';
		$output .= 			'</div>';
		$output .= 		'</div>'; # .col
		$output .= '</div>'; # .row

		$output .= '<!-- /acf_flexible_slider_4 -->';
		$output  = acf_flexible_container($input, $output);
		return $output;
	}

}



