<?php

if ( ! function_exists( 'acf_flexible_slider_1' ) ) {

	# Slider: Banner
	function acf_flexible_slider_1 ($input) {
#		displayVar($input);
		$output  = '';
		$output .= '<!-- acf_flexible_slider_1 -->';

		$output .=	'<div class="flexslider slider-fade ' . implode(' ', $input['arrows']) . '">';
		$output .=		'<ul class="slides">';

		# Loop through the slides and place them within <li>
		foreach ($input['content'] as $key => $value) {
			$output .=	'<li>';
	#		$output .=		'<div class="row">';
			if (in_array('image', $value['display'])) {
				$output .=			'<img src="' . $value['image'] . '" alt="" class="img-responsive img-expand" />';
			} else {
				$output .=			'<img src="' . get_template_directory_uri() . '/images/placeholders/t-' . $input['image_ratio'] . '.png" alt="" class="img-responsive img-expand" />';
			}
			if (in_array('banner', $value['display'])) {
				$output .=				'<div class="s3-absolute-full">';
				$output .=					'<div class="wrap-table">';
				$output .=						'<div class="wrap-table-inner">';
				# Checking the postion value for placement of the message. The default is 'left'.
				if ($value['position'] == 'right') {
					$output .=						'<div class="col-sm-4 col-sm-offset-7">';
				} else {
					$output .=						'<div class="col-sm-4 col-sm-offset-1">';
				}
				$output .=								'<div class="s3-' . $value['color'] . ' s3-p-8">';
				if ($value['header']) {
					$output .=								'<h2>' . $value['header'] . '</h2>';
				}
				if ($value['paragraph']) {
					$output .=								'<p>' . $value['paragraph'] . '</p>';
				}
				if ($value['linked']) {
					$output .=								'<p><a href="' . $value['link'] . '" class="btn btn-link btn-go s3-' . $value['color'] . '">' . $value['link_text'] . '</a></p>';
				}
				$output .=								'</div>';
				if ($value['embellishment'] != 'none') {
					$output .=								'<img src="' . get_template_directory_uri() . '/s3.3/img/' . $value['embellishment'] . '/' . $value['embellishment'] . '-' . $value['color'] . '.png" class="img-responsive hidden-xs" alt="">';
				}
				$output .=							'</div>';
				$output .=						'</div>';
				$output .=					'</div>';
				$output .=				'</div>';
			}
	#		$output .=			'</div>';
			$output .=		'</li>';
		}

		$output .=		'</ul>';
		$output .=	'</div>';

		$output .= '<!-- /acf_flexible_slider_1 -->';
		$output  = acf_flexible_container($input, $output);
		return $output;
	}

}



