<?php

if ( ! function_exists( 'acf_flexible_media_1' ) ) {

	# Figures
	function acf_flexible_media_1 ($input) {
	#	displayVar($input);
		$output   = '';
		$media    = '';
		$output  .= '<!-- acf_flexible_media_1 -->';

		# YouTube
		# --------------------------------------------------------------------------------------------------------------
		if ($input['media_type'] == 'youtube') {
			$media .= '<div class="s3-mb-8"><div class="video"><iframe class="youtube-video" src="https://www.youtube.com/embed/' . $input['youtube_id'] . '?rel=0&amp;showinfo=1&amp;enablejsapi=1" frameborder="0" allowfullscreen></iframe></div></div>';
		}



		# SoundCloud
    if ($input['media_type'] == 'soundcloud') {
      $media .= '<div class="s3-mb-6"><div class="audio"><iframe 
        class="soundcloud-embed" 
        width="100%" 
        height="166" 
        scrolling="no" 
        frameborder="no" 
        src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/' . $input['soundcloud_id'] . '&amp;color=ceb888&amp;auto_play=false&amp;hide_related=true&amp;show_comments=false&amp;show_user=true&amp;show_reposts=false">
        </iframe></div></div>';
    }



		# Gallery
		# --------------------------------------------------------------------------------------------------------------
		if ($input['media_type'] == 'gallery') {
#			displayVar($input['gallery_columns']);
#			displayVar($input['gallery_captions']);
#			displayVar($input['gallery']);

			$content_count = count($input['gallery']);
			if ( ($content_count < $input['gallery_columns']) && ($input['gallery_columns'] < 7) ) {
				if ( ($content_count < $input['gallery_columns']) && ($input['gallery_columns'] > 4) ) {
					$input['gallery_columns'] = 4;
				} else {
					$input['gallery_columns'] = $content_count;
				}
			}

			switch ($input['gallery_columns']) {
				case '6':
					$cols = 'col-sm-6 col-md-3 col-lg-2';
					break;
				case '4':
					$cols = 'col-sm-6 col-md-3';
					break;
				case '3':
					$cols = 'col-sm-6 col-md-4';
					break;
				case '2':
					$cols = 'col-sm-6';
					break;
				default:
					$cols = 'col-sm-12';
					$clearfix = '';
				}

			

      $current_post_id = get_the_ID();
      $gallery_group_key = 'gallery-' . substr(md5($current_post_id), 0, 8);
      $image_counter = 0;
      $unique_caption_id = 'img-caption-' . $current_post_id . '-' . $image_counter;

      foreach ($input['gallery'] as $key => $value) {
				$link = array (
					'href'  => '',
					'class' => array(),
					'data'  => array(),
				);

				if (_SITE_GALLERY_TYPE == 'fresco') {
					$link['href']    = $value['large'];
					$link['class'][] = 'fresco';
					if ($value['caption']) {
						$link['text'][]  = $value['caption'];
					}
					if ($value['description']) {
						$link['text'][]  = $value['description'];
					}
					if (isset($link['text'])) {
						if (is_array($link['text'])) {
							$link['data'][]  = 'data-fresco-caption="' . implode(' : ', $link['text']) . '"';
						}
					}
					$link['data'][]  = 'aria-labelledby="' . $unique_caption_id . '"';
					$link['data'][]  = 'data-fresco-group="' . $gallery_group_key . '"';
					$link['data'][]  = 'data-fresco-options="thumbnail: \'' . $value['thumb'] . '\'"';
				} else {
					$link['href']    = get_attachment_link($value['id']);
				}

				$alt = '';
				$figcaption = '';
				if ( (isset($value['caption'])) && ($value['caption'] != '') ) {
					if ($input['gallery_captions'] == 'left') {
						$figcaption = '<figcaption id="' . esc_attr($unique_caption_id) . '" class="wp-caption-text wp-caption-text-gallery text-left">' . $value['caption'] . '</figcaption>';
					} elseif ($input['gallery_captions'] == 'center') {
						$figcaption = '<figcaption id="' . esc_attr($unique_caption_id) . '" class="caption wp-caption-text-gallery text-center">' . $value['caption'] . '</figcaption>';
					} else {
						if ($value['alt'] != '') {
							$alt = $value['alt'];
						} else {
							$alt = $value['caption'];
						}
					}
				} else {
					if ($value['alt'] != '') {
						$alt = $value['alt'];
					}
				}

				$slot[$image_counter] = '<figure>';
				$slot[$image_counter] .= '<a href="' . $link['href'] . '" class="' . implode(' ', $link['class']) . '" ' . implode(' ', $link['data']) . '>';
				$slot[$image_counter] .= '<div class="media-img">';
				$slot[$image_counter] .= '<img src="' . $value['thumb'] . '" alt="' . $alt . '" class="img-responsive img-expand">';
				$slot[$image_counter] .= '<span class="fa fa-search-plus media-zoom"><span class="hidden"></span></span>';
				$slot[$image_counter] .= '</div>';
				$slot[$image_counter] .= '</a>';
				$slot[$image_counter] .= $figcaption;
				$slot[$image_counter] .= '</figure>';
				$image_counter++;
			}

			$image_counter = 1;
			$gallery  = '';
			$gallery .= '<div class="row">';
			foreach ($slot as $key => $value) {
				$gallery .=     '<div class="col-xs-12 ' . $cols . ' s3-mb-9">';
				$gallery .=         $value;
				$gallery .=     '</div>';

				if ( ($input['gallery_columns'] == 6) && ($image_counter % 2 == 0) ) {
					$gallery .= '<div class="clearfix visible-sm"></div>';
				}

				if ( ($input['gallery_columns'] == 6) && ($image_counter % 4 == 0) ) {
					$gallery .= '<div class="clearfix visible-md"></div>';
				}

				if ( ($input['gallery_columns'] == 6) && ($image_counter % 6 == 0) ) {
					$gallery .= '<div class="clearfix visible-lg"></div>';
				}

				if ( ($input['gallery_columns'] == 4) && ($image_counter % 2 == 0) ) {
					$gallery .= '<div class="clearfix visible-sm"></div>';
				}

				if ( ($input['gallery_columns'] == 4) && ($image_counter % 4 == 0) ) {
					$gallery .= '<div class="clearfix visible-md visible-lg"></div>';
				}

				if ( ($input['gallery_columns'] == 3) && ($image_counter % 2 == 0) ) {
					$gallery .= '<div class="clearfix visible-sm"></div>';
				}

				if ( ($input['gallery_columns'] == 3) && ($image_counter % 3 == 0) ) {
					$gallery .= '<div class="clearfix visible-md visible-lg"></div>';
				}

				if ( ($input['gallery_columns'] == 2) && ($image_counter % 2 == 0) ) {
					$gallery .= '<div class="clearfix"></div>';
				}

				$image_counter++;
			}
			$gallery .= '</div>';

			$media .= $gallery;
		}



		# Embed
		# --------------------------------------------------------------------------------------------------------------
		if ($input['media_type'] == 'embed') {
			$media .= $input['embed_code'];
		}



		# Add media description if available
		# --------------------------------------------------------------------------------------------------------------
		if (isset($input['media_description_before'])) {
			$output .= $input['media_description_before'];
		}
		$output .= $media;
		if (isset($input['media_description_after'])) {
			$output .= $input['media_description_after'];
		}


		# Output the data
		# --------------------------------------------------------------------------------------------------------------
		$output .= '<!-- /acf_flexible_media_1 -->';
		$output  = acf_flexible_container($input, $output);
		return $output;

	}
}



