<?php

if ( ! function_exists( 'acf_flexible_figures_1' ) ) {

	# Figures
	function acf_flexible_figures_1 ($input) {
		#displayVar($input);
		$output  = '';
		$output .= '<!-- acf_flexible_figures_1 -->';

		# Figures
		# --------------------------------------------------------------------------------------------------------------
		if ($input['figure_or_gallery'] == 'figure') {
			$figure_count = count($input['images']);
			$count = 0;
			foreach ($input['images'] as $key => $value) {
				$slot[$count] = '';
				if ($value['caption'] == 'below') {
					$slot[$count] .= '<div class="row">';
					$slot[$count] .=     '<div class="col-xs-12">';
					$slot[$count] .=         '<img src="' . $value['image'] . '" alt="" class="img-responsive img-expand">';
					$slot[$count] .=         '<p class="caption">' . $value['content'] . '</p>';
					$slot[$count] .=     '</div>';
					$slot[$count] .= '</div>';
				} elseif ($value['caption'] == 'right') {
					$slot[$count] .= '<div class="row s3-mb-8">';
					$slot[$count] .=     '<div class="col-xs-12 col-sm-8">';
					$slot[$count] .= '        <img src="' . $value['image'] . '" alt="" class="img-responsive img-expand">';
					$slot[$count] .=     '</div>';
					$slot[$count] .=     '<div class="col-xs-12 col-sm-4">';
					$slot[$count] .=         '<p class="caption caption-side">' . $value['content'] . '</p>';
					$slot[$count] .=     '</div>';
					$slot[$count] .= '</div>';
				} else {
					$slot[$count] .= '<div class="col-xs-12">';
					$slot[$count] .=     '<img src="' . $value['image'] . '" alt="' . $value['image_alt'] . '" class="img-responsive img-expand">';
					$slot[$count] .= '</div>';
				}
				$count++;
			}

			if ($figure_count == 1) {
				$figures  = '';
				$figures .= $slot[0];
			}

			if ($figure_count == 2) {
				$figures  = '';
				$figures .= '<div class="row">';
				$figures .=     '<div class="col-xs-12 col-sm-6">';
				$figures .=         $slot[0];
				$figures .=     '</div>';
				$figures .=     '<div class="col-xs-12 col-sm-6">';
				$figures .=         $slot[1];
				$figures .=     '</div>';
				$figures .= '</div>';
			}

			$output .= $figures;
		}


		# Gallery
		# --------------------------------------------------------------------------------------------------------------
		if ($input['figure_or_gallery'] == 'gallery') {
			$content_count = count($input['images']);

			if ( ($content_count < $input['columns']) && ($input['columns'] < 7) ) {
				if ( ($content_count < $input['columns']) && ($input['columns'] > 4) ) {
					$input['columns'] = 4;
				} else {
					$input['columns'] = $content_count;
				}
			}

			switch ($input['columns']) {
				case '6':
					$cols = 'col-sm-2';
					break;
				case '4':
					$cols = 'col-sm-3';
					break;
				case '3':
					$cols = 'col-sm-4';
					break;
				case '2':
					$cols = 'col-sm-6';
					break;
				default:
					$cols = 'col-sm-12';
			}


			$count = 0;
			foreach ($input['images'] as $key => $value) {
				$slot[$count] = '';
				if ($input['position'] == 'left') {
					$slot[$count] .= '<img src="' . $value['image'] . '" class="img-responsive img-expand">';
					if (isset($value['content'])) {
						$slot[$count] .= '<p class="caption text-left">' . $value['content'] . '</p>';
					}
				} elseif ($input['position'] == 'center') {
					$slot[$count] .= '<img src="' . $value['image'] . '" class="img-responsive img-expand">';
					if (isset($value['content'])) {
						$slot[$count] .= '<p class="caption text-center">' . $value['content'] . '</p>';
					}
				}
				$count++;
			}

			$count = 1;
			$gallery  = '';
			$gallery .= '<div class="row">';
			foreach ($slot as $key => $value) {
				$gallery .=     '<div class="col-xs-12 ' . $cols . ' s3-m-6">';
				$gallery .=         $value;
				$gallery .=     '</div>';
				$gallery .= acf_column_breaker($input['columns'], $count);
				$count++;
			}
			$gallery .= '</div>';

			$output .= $gallery;
		}

		$output .= '<!-- /acf_flexible_figures_1 -->';
		$output  = acf_flexible_container($input, $output);
		return $output;
	}

}



