<?php

if ( ! function_exists( 'acf_flexible_feature_3' ) ) {

	# Feature: Banners
	function acf_flexible_feature_3 ($input) {
	#	displayVar($input);
		$output  = '';
		$output .= '<!-- acf_flexible_feature_3 -->';

		$columns = count($input['content']);
		switch ($columns) {
			case '4':
				$banner_cols = 'col-sm-3';
				break;
			case '3':
				$banner_cols = 'col-sm-4';
				break;
			default:
				$banner_cols = 'col-sm-6';
		}

		$output .=	'<div class="s3-p-10 s3-bg-' . $input['banner_background'] . '">';
		$output .=		'<div class="row">';
		foreach ($input['content'] as $key => $value) {
			$output .=			'<div class="' . $banner_cols . ' s3-mb-8 ">';
			$output .=				'<div class="s3-p-10 s3-' . $input['color'] . ' feature-fixed ' . $input['block-height'] . ' wrap-table">';
			$output .=					$value['content'];
			$output .=				'</div>';
			if ($input['embellishment'] != 'none') {
				$output .=			'<img src="' . get_template_directory_uri() . '/s3.3/img/' . $input['embellishment'] . '/' . $input['embellishment'] . '-' . $input['color'] . '.png" class="img-responsive hidden-xs" alt="">';
			}
			$output .=			'</div>';
		}
		$output .=		'</div>';
		$output .=	'</div>';

		$output .= '<!-- /acf_flexible_feature_3 -->';
		$output  = acf_flexible_container($input, $output);
		return $output;
	}

}



