<?php

if ( ! function_exists( 'acf_flexible_content_3' ) ) {

	# Image List
	function acf_flexible_content_3 ($input) {
#		displayVar($input);
		$output  = '';
		$output .= '<!-- acf_flexible_content_3 -->';


		$columns = $input['columns'];

		# Setting up Bootstrap columns based upon $input['column'] choices
		$columns_break = array (
			'2_10' => array (
				'first'  => 'col-xs-12 col-sm-2 col-sm-offset-0',
				'second' => 'col-xs-12 col-sm-10',
			),
			'3_9' => array (
				'first'  => 'col-xs-12 col-sm-4 col-sm-offset-0 col-md-3 ',
				'second' => 'col-xs-12 col-sm-8 col-md-9',
			),
			'4_8' => array (
				'first'  => 'col-xs-12 col-sm-4 col-sm-offset-0',
				'second' => 'col-xs-12 col-sm-8',
			),
		);


		# Loop through the ACF content repeater
		foreach ($input['content'] as $key => $value) {
			$image = '';
			$first_column_mod = '';
			# If an image and a caption exist display them
			if ( ($value['image']) && ($value['caption']) ) {
				$image .= '<img src="' . $value['image'] . '" alt="" class="img-responsive img-expand" />';
				$image .= '<p class="text-center caption">' . $value['caption'] . '</p>';

			# If a caption does not exist for an image, modify the margin on the image
			} elseif ( ($value['image']) && (!$value['caption']) ) {
				$image .= '<img src="' . $value['image'] . '" alt="' . $value['image_alt'] . '" class="img-responsive img-expand s3-mb-8" />';

			# If an image does not exist then remove the first column on XS screens
			} else {
				$image = '&nbsp;';
				$first_column_mod = ' hidden-xs';
			}


			$output .= '<div class="row s3-mb-8">';
			$output .=     '<div class="' . $columns_break[$columns]['first'] . $first_column_mod . '">';
			$output .=         $image;
			$output .=     '</div>';

			$output .=     '<div class="' . $columns_break[$columns]['second'] . '">';
			$output .=         $value['content'];
			$output .=     '</div>';

			$output .= '</div>'; # /row
		}

		$output .= '<!-- /acf_flexible_content_3 -->';
		$output  = acf_flexible_container($input, $output);

		return $output;
	}

}



