<?php

if ( ! function_exists( 'acf_flexible_content_2' ) ) {

	# Block Content
	# Column content with finer controls
	function acf_flexible_content_2 ($input) {
		#displayVar($input);
		#displayVar($input['content']);
		$output  = '';
		$output .= '<!-- acf_flexible_content_2 -->';

		# Wrap the columns in a row to reset the section padding
		$output .= '<div class="row">';

		# Breakpoint keywords
		$breakpoints = array('xs', 'sm', 'md', 'lg');

		# Loop through the ACF content repeater
		foreach ($input['content'] as $key => $value) {
			if ($value['type'] == 'break') {
				$output .= '<div class="clearfix visible-' . implode(' visible-', $value['break']) . '"></div>';
			} else {
				# Assign the type of content
				if ($value['type'] == 'column') {
					$column_content = $value['column'];
				} else {
					$column_content = $value['code'];
				}

				# If the content was empty put in an non-breacking space
				if ($column_content == '') {
					$column_content = '&nbsp;';
				}

				# Wrap the content in a custom css class if it is assigned
				if ($value['css'] != '') {
					$column_content = '<div class="' . $value['css'] . '">' . $column_content . '</div>';
				}

				# Process the breakpoint values
				$columns = array();
				foreach ($breakpoints as $breakpoint_key => $breakpoint_value) {
					if ($value[$breakpoint_value] == 'hide') {
						$columns[] = 'hidden-' . $breakpoint_value;
					} else {
						$columns[] = 'col-' . $breakpoint_value . '-' . $value[$breakpoint_value];
					}
				}

				# Form the column
				$output .= '<div class="' . implode(' ', $columns) . '">';
				$output .= $column_content;
				$output .= '</div>';
			}
		}
		$output .= '</div>'; # /row

		$output .= '<!-- /acf_flexible_content_2 -->';
		$output  = acf_flexible_container($input, $output);
		return $output;
	}

}



