<?php

if ( ! function_exists( 'acf_flexible_content_1' ) ) {

    # Normal Content
    # Single or double column layout
    function acf_flexible_content_1 ($input) {
        $output  = '';
        $output .= '';

        # Loop through the ACF content repeater
        foreach ($input['content'] as $key => $value) {

            // --- CRITICAL STEP: Filter the content variables BEFORE using them ---
            $content_1 = apply_filters( 'the_content', $value['content_1'] );
            
            // Only filter content_2 if it exists in a two-column layout
            $content_2 = (isset($value['content_2'])) ? apply_filters( 'the_content', $value['content_2'] ) : '';


            # Process single column layout
            if ($value['columns'] == '1') {
                $output .= '<div class="row">';
                $output .= '<div class="col-xs-12">';
                // Use the FILTERED content
                $output .= $content_1; 
                $output .= '</div>';
                $output .= '</div>';
            # Process two column layout
            } else {
                # breack the 'split' value on the underscore to form the Bootstrop columns
                $split = explode('_', $value['split']);
                $output .= '<div class="row">';
                
                $output .=      '<div class="col-xs-12 col-sm-' . $split[0] . '">';
                // Use the FILTERED content
                $output .=          $content_1; 
                $output .=      '</div>';
                
                $output .=      '<div class="col-xs-12 col-sm-' . $split[1] . '">';
                // Use the FILTERED content
                $output .=          $content_2; 
                $output .=      '</div>';
                
                $output .= '</div>';
            }
        }

        $output .= '';
        $output  = acf_flexible_container($input, $output);
        return $output;
    }

}