<?php

# Container Types
if ( ! function_exists( 'acf_flexible_container' ) ) {
	function acf_flexible_container ($input, $output) {
	#	displayVar($input);
	#	displayVar($output);

		$prepend = '';
		$append  = '';


		# Adds a div with custom CSS classes
		if ($input['custom_css_classes']) {
			$append   .=	'</div>';
		}

		# Adds a row for slightly wider display
		if ($input['wider_feature']) {
			$append   .=	'</div>';
		}

		# Removeds the wrapper if the contnet comes from within the main content area
		if ($input['passthrough'] == true) {
			$input['display_type'] = 'default';
		}

	#	$prepend .= '<code>Location: ' . $input['location'] . ' | Display Type: ' . $input['display_type'] . '</code>';

		if ($input['display_type'] == 'inset') {
			$prepend .=	'<div class="content s3-' . $input['background_color'] . '">';
			$prepend .=		'<div class="container">';
			$prepend .=			'<div class="row s3-mt-' . $input['margin_top'] . ' s3-mb-' . $input['margin_bottom'] . '">';
			$prepend .=				'<div class="col-xs-12">';

			$append  .=				'</div>'; # Column
			$append  .=			'</div>'; # Row
			$append  .=		'</div>'; # Container
			$append  .=	'</div>'; # Content
		} elseif ($input['display_type'] == 'fluid') {
			$prepend .=	'<div class="content s3-' . $input['background_color'] . '">';
			$prepend .=		'<div class="container-fluid">';
			$prepend .=			'<div class="row s3-mt-' . $input['margin_top'] . ' s3-mb-' . $input['margin_bottom'] . '">';
			$prepend .=				'<div class="col-xs-12">';

			$append  .=				'</div>'; # Column
			$append  .=			'</div>'; # Row
			$append  .=		'</div>'; # Container
			$append  .=     '<div class="clearfix"></div>';
			$append  .=	'</div>'; # Content

		} elseif ($input['display_type'] == 'default') {
			$prepend .=	'<!-- default -->';
			$prepend .=			'<div class="row s3-mt-' . $input['margin_top'] . ' s3-mb-' . $input['margin_bottom'] . '">';
			$prepend .=	            '<div class="col-xs-12">';

			$append  .=             '</div>';
			$append  .=         '<div class="clearfix"></div>';
			$append  .=     '</div>';
		} elseif ($input['display_type'] == 'empty') {
			$prepend .=	'<div class="content s3-' . $input['background_color'] . '">';

			$append  .=	'</div>'; # Background
		}

		if ($input['wider_feature']) {
			$prepend .=	'<div class="row">';
		}

		# Adds a div with custom CSS classes
		if ($input['custom_css_classes']) {
			$prepend .=	'<div class="' . $input['custom_css_classes'] . '">';
		}

		$output = $prepend . $output . $append;
		return $output;
	}
}



