<?php

if ( ! function_exists( 'acf_flexible_blocks_1' ) ) {

	# Blocks
	function acf_flexible_blocks_1 ($input) {
		#displayVar($input);
		$output  = '';
		$output .= '<!-- acf_flexible_blocks_1 -->';

		# Images that get treated differently if the content is left-aligned
		$left_images = array ('1x1', '4x5');

		# Column adjustments
		# If less content is created than we have columns then match the column count
		if (isset($input['content_rails'])) {
			$content_count = count($input['content_rails']);
		}
		if (isset($input['content_wysiwyg'])) {
			$content_count = count($input['content_wysiwyg']);
		}
		if (isset($input['content_code'])) {
			$content_count = count($input['content_code']);
		}
		if ( ($content_count < $input['columns']) && ($input['columns'] < 7) ) {
			if ( ($content_count < $input['columns']) && ($input['columns'] > 4) ) {
				$input['columns'] = 4;
			} else {
				$input['columns'] = $content_count;
			}
		}

		# There should be no more than three columns for content with left-aligned images
		if ($input['content_type'] == 'rails') {
			if ( ($input['rails_alignment'] == 'left') && ( in_array($input['rails_image_ratio'], $left_images) ) && ($input['columns'] > 3) ) {
				$input['columns'] = 3;
			}
		}

		# Add some bottom margin to "rows" when there are more than 1 (more content than columns)
		if ($content_count > $input['columns']) {
			$row_margin = 's3-m-8 ';
		} else {
			$row_margin = '';
		}

		# Column div outputs
		switch ($input['columns']) {
			case '2':
				$columns = 'col-xs-12 col-sm-6';
				break;
			case '2_2':
				$columns = 'col-xs-6';
				break;
			case '3':
				$columns = 'col-xs-12 col-sm-4';
				break;
			case '4':
				$columns = 'col-xs-12 col-sm-3';
				break;
			case '4_2':
				$columns = 'col-xs-6 col-sm-3';
				break;
			case '6':
				$columns = 'col-xs-12 col-sm-2';
				break;
			case '6_2':
				$columns = 'col-xs-6 col-sm-4 col-md-2';
				break;
			default;
				$columns = 'col-xs-12';
		}

		# Form the Blocks
		$count = 0; # For breacking on columns/rows
		if ($input['content_type'] == 'rails') {

			switch ($input['rails_alignment']) {
				case 'center':
					$alignment = 'text-center';
					break;
				default:
					$alignment = 'text-left';
			}

			$output .= '<div class="row ' . $alignment . '">';
				foreach ($input['content_rails'] as $key => $value) {
	#				$prepend       = '';
					$image_content = '';
					$text_content  = '';
					$append        = '';

					$output .= '<div class="' . $columns . ' s3-m-5 ' . $row_margin . 's3-m-t0">';
					if (isset($value['custom_block_css_class'])) {
						$output .= '<div class="' . $value['custom_block_css_class'] . '">';
					}

					if ($input['rails_image_available']) {
						if ( ($input['rails_alignment'] == 'center') && ( $input['rails_image_ratio'] == '1x1') ) {
							$image_content .= '<div class="row"><div class="col-xs-8 col-xs-offset-2 col-sm-6 col-sm-offset-3">';
							$image_content .= '<img src="' . $value['rails_image'] . '" class="img-responsive img-expand img-' . $input['rails_image_effect'] . '" alt="' . $value['rails_image_alt'] . '">';
							$image_content .= '</div></div>';
						} elseif ( ($input['rails_alignment'] == 'left') && ( in_array($input['rails_image_ratio'], $left_images) ) ) {
							$image_content .= '<div class="row">';
							$image_content .=     '<div class="col-xs-12 col-sm-4">';

							$image_content .=         '<div class="s3-m-t0">';
							$image_content .=             '<img src="' . $value['rails_image'] . '" class="img-responsive img-expand img-' . $input['rails_image_effect'] . '" alt="' . $value['rails_image_alt'] . '">';
							$image_content .=         '</div>';
							$image_content .=     '</div>';
							$image_content .= '<div class="col-xs-12 col-sm-8">';

							$append .=            '</div>';
							$append .=        '</div>';
						} else {
							$image_content .= '<img src="' . $value['rails_image'] . '" class="img-responsive img-expand img-' . $input['rails_image_effect'] . '" alt="' . $value['rails_image_alt'] . '">';
						}
					}

					if ($value['linked']) {
						if ($value['destination'] == 'external') {
							$link_format = '<a href="%s" target="_blank">' . $image_content . '</a>';
						} else {
							$link_format = '<a href="%s">' . $image_content . '</a>';
						}
						$image_content = sprintf($link_format, $value['link']);
					}

					# Collect the text into a variable for processing
					$rails_class = $input['rails_header_type'];
					if ( ($input['rails_alignment'] == 'left') && ( in_array($input['rails_image_ratio'], $left_images) ) ) {
						$rails_class .= ' s3-m-t0';
					}
					if ($value['rails_header']) {
						$rails_format = '<p class="%s">' . $value['rails_header'] . '</p>';
						$text_content .= sprintf($rails_format, $rails_class);
						if ($value['linked']) {
							$link_format = '<a href="%s">' . $text_content . '</a>';
							$text_content = sprintf($link_format, $value['link']);
						}
					}
					if ($value['rails_paragraph']) {
						$text_content .= '<p>' . $value['rails_paragraph'] . '</p>';
					}

					$output .= $image_content;
					$output .= $text_content;
					$output .= $append;

					if (isset($value['custom_block_css_class'])) {
						$output .= '</div>';
					}
					$output .= '</div>'; #/columns

					$count++;
					$output .= acf_column_breaker($input['columns'], $count);
				}
			$output .= '</div>';
		} elseif ($input['content_type'] == 'free') {
			$output .= '<div class="row">';
			foreach ($input['content_wysiwyg'] as $key => $value) {
				$output .= '<div class="' . $columns . '">';
				if (isset($value['custom_block_css_class'])) {
					$output .= '<div class="' . $value['custom_block_css_class'] . '">';
				}
				$output .= $value['wysiwyg_content'];
				$output .= acf_column_breaker($input['columns'], $count);
				if (isset($value['custom_block_css_class'])) {
					$output .= '</div>';
				}
				$output .= '</div>';
				$count++;
				$output .= acf_column_breaker($input['columns'], $count);
			}
			$output .= '</div>';
		} elseif ($input['content_type'] == 'code') {
			$output .= '<div class="row">';
			foreach ($input['content_code'] as $key => $value) {
				$output .= '<div class="' . $columns . '">';
				if (isset($value['custom_block_css_class'])) {
					$output .= '<div class="' . $value['custom_block_css_class'] . '">';
				}
				$output .= $value['code_content'];
				$output .= acf_column_breaker($input['columns'], $count);
				if (isset($value['custom_block_css_class'])) {
					$output .= '</div>';
				}
				$output .= '</div>';
				$count++;
				$output .= acf_column_breaker($input['columns'], $count);
			}
			$output .= '</div>';
		}

		$output .= '<!-- /acf_flexible_blocks_1 -->';
		$output  = acf_flexible_container($input, $output);
		return $output;
	}

}



