<?php
if( function_exists('acf_add_local_field_group') ):


acf_add_local_field_group(array(
	'key' => 'group_575823d7b6927',
	'title' => 'Flexible Content (Within)',
	'fields' => array(
		array(
			'key' => 'field_57586c154d85a',
			'label' => 'Content Within Editor',
			'name' => 'content_within',
			'type' => 'flexible_content',
			'instructions' => 'This area appears within the main content of your site but below the input.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layouts' => array(
				'573b27f70af6c' => array(
					'key' => '573b27f70af6c',
					'name' => 'pattern_slider_1',
					'label' => 'Slider: Banner',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c174d85b',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d85c',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x1' => '3:1',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x1',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d85e',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c154d85a',
										'operator' => '!=empty',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d860',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_577d456fedd4d',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_577d456fedd4d',
									'label' => 'Display',
									'name' => 'display',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => '',
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'image' => 'Image',
										'banner' => 'Banner',
									),
									'default_value' => array(
										0 => 'image',
										1 => 'banner',
									),
									'layout' => 'horizontal',
									'toggle' => 0,
									'allow_custom' => 0,
									'save_custom' => 0,
									'return_format' => 'value',
								),
								array(
									'key' => 'field_57586c174d861',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d456fedd4d',
												'operator' => '==',
												'value' => 'image',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_57586c174d862',
									'label' => 'Color',
									'name' => 'block_color',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d456fedd4d',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'c' => 'Canvas',
										'w' => 'White',
										'gt' => 'Garnet',
										'gd' => 'Gold',
										'gd1c' => 'Gold + 1 Canvas',
										'gd2c' => 'Gold + 2 Canvas',
										'gd3c' => 'Gold + 3 Canvas',
										'n2w' => 'Neutral + 2 White',
										'n1w' => 'Neutral + 1 White',
										'n' => 'Neutral',
										'n2s' => 'Neutral + 2 Slate',
										's' => 'Slate',
										'k' => 'Black',
									),
									'default_value' => array(
										0 => 'c',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_57586c174d863',
									'label' => 'Position',
									'name' => 'block_position',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d456fedd4d',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'left' => 'Left',
										'right' => 'Right',
									),
									'default_value' => array(
										0 => 'left',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_57586c174d864',
									'label' => 'Design',
									'name' => 'embellishment',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d456fedd4d',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'none' => 'None',
										'arrow' => 'Arrow',
										'point' => 'Point',
									),
									'default_value' => array(
										0 => 'none',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_57586c174d865',
									'label' => 'Content Header',
									'name' => 'block_content_header',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d456fedd4d',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_57586c174d866',
									'label' => 'Content Paragraph',
									'name' => 'block_content_paragraph',
									'type' => 'textarea',
									'instructions' => '* Does not show on smallest display.',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d456fedd4d',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_57586c174d867',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d456fedd4d',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '10',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'ui' => 0,
									'ui_on_text' => '',
									'ui_off_text' => '',
								),
								array(
									'key' => 'field_57586c174d868',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c174d867',
												'operator' => '==',
												'value' => '1',
											),
											array(
												'field' => 'field_577d456fedd4d',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_57586c174d869',
									'label' => 'Link Text',
									'name' => 'link_text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c174d867',
												'operator' => '==',
												'value' => '1',
											),
											array(
												'field' => 'field_577d456fedd4d',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'default_value' => 'Read More',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_57586c174d86a',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d86d',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be472af6b8',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d86e',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e533d4f8908',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'573ca7b7dc751' => array(
					'key' => '573ca7b7dc751',
					'name' => 'pattern_slider_3',
					'label' => 'Slider: Description Below Image',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c174d881',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d882',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x1' => '3:1',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x1',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d885',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c154d85a',
										'operator' => '!=empty',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => '',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_57586c174d883',
							'label' => 'Block Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d887',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 2,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_57586c174d888',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_57586c174d889',
									'label' => 'Content Header',
									'name' => 'block_content_header',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_57586c174d88a',
									'label' => 'Content Paragraph',
									'name' => 'block_content_paragraph',
									'type' => 'textarea',
									'instructions' => '* Does not show on smallest display.',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_57586c174d88b',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '10',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'ui' => 0,
									'ui_on_text' => '',
									'ui_off_text' => '',
								),
								array(
									'key' => 'field_57586c174d88c',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c174d88b',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_57586c174d88d',
									'label' => 'Link Text',
									'name' => 'link_text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c174d88b',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'default_value' => 'Read More',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_57586c174d88e',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d891',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be4a5af6ba',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d892',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e533def890a',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'573cc254d9c29' => array(
					'key' => '573cc254d9c29',
					'name' => 'pattern_slider_4',
					'label' => 'Slider: Split',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c174d893',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d895',
							'label' => 'Columns',
							'name' => 'columns_3x2',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c154d85a',
										'operator' => '!=empty',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'4_8' => '(4 and 8) or (8 and 4)',
								'6_6' => '(6 and 6)',
							),
							'default_value' => array(
								0 => '4_8',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d898',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c154d85a',
										'operator' => '!=empty',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d899',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_57586c174d89a',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_57586c174d89b',
									'label' => 'Color',
									'name' => 'block_color',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'c' => 'Canvas',
										'w' => 'White',
										'gt' => 'Garnet',
										'gd' => 'Gold',
										'gd1c' => 'Gold + 1 Canvas',
										'gd2c' => 'Gold + 2 Canvas',
										'gd3c' => 'Gold + 3 Canvas',
										'n2w' => 'Neutral + 2 White',
										'n1w' => 'Neutral + 1 White',
										'n' => 'Neutral',
										'n2s' => 'Neutral + 2 Slate',
										's' => 'Slate',
										'k' => 'Black',
									),
									'default_value' => array(
										0 => 'c',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_57586c174d89c',
									'label' => 'Position',
									'name' => 'block_position',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'left' => 'Left',
										'right' => 'Right',
									),
									'default_value' => array(
										0 => 'left',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_57586c174d89d',
									'label' => 'Content Header',
									'name' => 'block_content_header',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_57586c174d89e',
									'label' => 'Content Paragraph',
									'name' => 'block_content_paragraph',
									'type' => 'textarea',
									'instructions' => '* Does not show on smallest display.',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_57586c174d89f',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '10',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'ui' => 0,
									'ui_on_text' => '',
									'ui_off_text' => '',
								),
								array(
									'key' => 'field_57586c174d8a0',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c174d89f',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_57586c174d8a1',
									'label' => 'Link Text',
									'name' => 'link_text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c174d89f',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'default_value' => 'Read More',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_57586c174d8a2',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d8a5',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be4b8af6bb',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8a6',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e533e3f890b',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'574dbee3293d8' => array(
					'key' => '574dbee3293d8',
					'name' => 'pattern_slider_5',
					'label' => 'Slider: Split With Static Message',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c174d8a7',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d8a9',
							'label' => 'Columns',
							'name' => 'columns_3x2',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'4_8' => '(4 and 8) or (8 and 4)',
								'6_6' => '(6 and 6)',
							),
							'default_value' => array(
								0 => '4_8',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8ac',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8ad',
							'label' => 'Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8ae',
							'label' => 'Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8af',
							'label' => 'Content',
							'name' => 'block_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<p class="h3 s3-fs-xs-4 text-center">Lorem Ipsum Dolor Sit Amet Consectetur Adipiscing Elit</p><hr class=" text-center" ><p class="text-center"><a class="btn btn-link btn-go" href="#">Read more</a></p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_57586c174d8b0',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_57586c174d8b1',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
							),
						),
						array(
							'key' => 'field_57586c174d8b2',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d8b5',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be4cfaf6bc',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8b6',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e533e8f890c',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'574de4a4690f9' => array(
					'key' => '574de4a4690f9',
					'name' => 'pattern_slider_6',
					'label' => 'Slider: Carousel',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c174d8b7',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d8b8',
							'label' => 'Display Message?',
							'name' => 'message',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57586c174d8ba',
							'label' => 'Message Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c174d8b8',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8b9',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c174d8b8',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3_9' => '(3 and 9) or (9 and 3)',
								'4_8' => '(4 and 8) or (8 and 4)',
							),
							'default_value' => array(
								0 => '4_8',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8bb',
							'label' => 'Message Content',
							'name' => 'message_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c174d8b8',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 0,
							'delay' => 1,
						),
						array(
							'key' => 'field_57586c174d8bc',
							'label' => 'Show Images',
							'name' => 'image',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57586c174d8bf',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c154d85a',
										'operator' => '!=empty',
									),
								),
							),
							'wrapper' => array(
								'width' => '66',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 's',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8c0',
							'label' => 'Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8c1',
							'label' => 'Banner Height',
							'name' => 'block_height',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'feature-fixed-1' => 'Large',
								'feature-fixed-2' => 'Medium',
								'feature-fixed-3' => 'Small',
							),
							'default_value' => array(
								0 => 'feature-fixed-2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8c2',
							'label' => 'Design',
							'name' => 'embellishment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'arrow' => 'Arrow',
								'point' => 'Point',
							),
							'default_value' => array(
								0 => 'arrow',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8c3',
							'label' => 'Slides',
							'name' => 'slides',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'table',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_57586c174d8c4',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_57586c174d8c5',
									'label' => 'Content',
									'name' => 'content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '66',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 0,
									'delay' => 1,
								),
							),
						),
						array(
							'key' => 'field_57586c174d8c6',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d8c9',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'disabled' => 0,
							'readonly' => 0,
							'return_format' => 'value',
						),
						array(
							'key' => 'field_576be4e2af6bd',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'disabled' => 0,
							'readonly' => 0,
							'return_format' => 'value',
						),
						array(
							'key' => 'field_57586c174d8ca',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e533edf890d',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'573f663817335' => array(
					'key' => '573f663817335',
					'name' => 'pattern_feature_1',
					'label' => 'Feature: Background Cover with Banner',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c174d8cb',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d8cd',
							'label' => 'Image',
							'name' => 'image',
							'type' => 'image',
							'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 's3-md-16x9',
							'library' => 'all',
							'min_width' => 600,
							'min_height' => 300,
							'min_size' => '',
							'max_width' => 2400,
							'max_height' => 2400,
							'max_size' => '.4',
							'mime_types' => 'jpg, png, gif',
						),
						array(
							'key' => 'field_57586c174d8cc',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '16x9',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8d3',
							'label' => 'Design',
							'name' => 'embellishment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'arrow' => 'Arrow',
								'point' => 'Point',
							),
							'default_value' => array(
								0 => 'none',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8ce',
							'label' => 'Banner Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8cf',
							'label' => 'Banner Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8d0',
							'label' => 'Banner Width',
							'name' => 'block_width',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c174d8cf',
										'operator' => '!=',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								4 => 'Four/Five Columns',
								5 => 'Five Columns',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8d1',
							'label' => 'Banner Width',
							'name' => 'block_width_center',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c174d8cf',
										'operator' => '==',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								4 => 'Four Columns',
								6 => 'Six Columns',
								8 => 'Eight Columns',
								10 => 'Ten Columns',
								12 => 'Twelve Columns',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8d2',
							'label' => 'Banner Content',
							'name' => 'block_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<h3 class="s3-fs-sm-3">Patria feugait quis valetudo.</h3><p class="s3-fs-sm-1">Dolore regula pagus exerci minim bis quidne. Illum premo quidem dignissim melior exerci sed letatio in tum.</p><p class="h4 s3-fs-sm-2"><a href="#">Read More <span class="fa fa-chevron-right"></span></a></p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_57586c174d8d4',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d8d7',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'disabled' => 0,
							'readonly' => 0,
							'return_format' => 'value',
						),
						array(
							'key' => 'field_576be4fcaf6be',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'disabled' => 0,
							'readonly' => 0,
							'return_format' => 'value',
						),
						array(
							'key' => 'field_57586c174d8d8',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e533f3f890e',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57431f40dcbed' => array(
					'key' => '57431f40dcbed',
					'name' => 'pattern_feature_2',
					'label' => 'Feature: Background Cover',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c174d8d9',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d8db',
							'label' => 'Image',
							'name' => 'image',
							'type' => 'image',
							'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 's3-md-16x9',
							'library' => 'all',
							'min_width' => 600,
							'min_height' => 300,
							'min_size' => '',
							'max_width' => 2400,
							'max_height' => 2400,
							'max_size' => '.4',
							'mime_types' => 'jpg, png, gif',
						),
						array(
							'key' => 'field_57586c174d8da',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '16x9',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8dc',
							'label' => 'Banner Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8dd',
							'label' => 'Banner Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8de',
							'label' => 'Banner Width',
							'name' => 'block_width',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c174d8dd',
										'operator' => '!=',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								3 => 'Three Columns',
								4 => 'Four Columns',
								5 => 'Five Columns',
								6 => 'Six Columns',
							),
							'default_value' => array(
								0 => 3,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8df',
							'label' => 'Banner Width',
							'name' => 'block_width_center',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c174d8dd',
										'operator' => '==',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								4 => 'Four Columns',
								6 => 'Six Columns',
								8 => 'Eight Columns',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8e0',
							'label' => 'Banner Content',
							'name' => 'block_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<h3 class="s3-fs-sm-3">Patria feugait quis valetudo.</h3><p class="s3-fs-sm-1">Dolore regula pagus exerci minim bis quidne. Illum premo quidem dignissim melior exerci sed letatio in tum.</p><p class="h4 s3-fs-sm-2"><a href="#">Read More <span class="fa fa-chevron-right"></span></a></p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_57586c174d8e1',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d8e4',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be510af6bf',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8e5',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e533f7f890f',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57435b0bf31f8' => array(
					'key' => '57435b0bf31f8',
					'name' => 'pattern_feature_3',
					'label' => 'Feature: Banners',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c174d8e6',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c174d8e7',
							'label' => 'Banner Color Background',
							'name' => 'banner_color_background',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8e8',
							'label' => 'Banner Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8e9',
							'label' => 'Banner Height',
							'name' => 'block_height',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'feature-fixed-1' => 'Large',
								'feature-fixed-2' => 'Medium',
								'feature-fixed-3' => 'Small',
							),
							'default_value' => array(
								0 => 'feature-fixed-2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8ea',
							'label' => 'Design',
							'name' => 'embellishment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'arrow' => 'Arrow',
								'point' => 'Point',
							),
							'default_value' => array(
								0 => 'arrow',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c174d8eb',
							'label' => 'Block',
							'name' => 'block',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 2,
							'max' => 4,
							'layout' => 'block',
							'button_label' => 'Add Block Content',
							'sub_fields' => array(
								array(
									'key' => 'field_57586c174d8ec',
									'label' => 'Block Content',
									'name' => 'block_content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '<h2>Patria feugait quis valetudo.</h2>Dolore regula pagus exerci minim bis quidne. Illum premo quidem dignissim melior exerci sed letatio in tum.<a class="btn btn-link btn-go s3-gd" href="#">Read More</a>',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 0,
									'delay' => 0,
								),
							),
						),
						array(
							'key' => 'field_57586c174d8ed',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c184d8f0',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be527af6c0',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d8f1',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e533fcf8910',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57444c75f9c06' => array(
					'key' => '57444c75f9c06',
					'name' => 'pattern_hero_1',
					'label' => 'Hero',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c184d8f2',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c184d8f3',
							'label' => 'Content Type',
							'name' => 'content_type',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'rails' => 'On Rails (Predefined Types)',
								'free' => 'Custom (WYSIWYG)',
							),
							'default_value' => array(
								0 => 'rails',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d8f4',
							'label' => 'Alignment',
							'name' => 'rails_alignment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d8f3',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Centered',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'center',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d8f5',
							'label' => 'Content',
							'name' => 'content_rails',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d8f3',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '100',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_57586c184d8f6',
									'label' => 'Content',
									'name' => 'rails_type',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c184d8f3',
												'operator' => '==',
												'value' => 'rails',
											),
										),
									),
									'wrapper' => array(
										'width' => 20,
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'h1' => 'Heading 1 Style',
										'h2' => 'Heading 2 Style',
										'h3' => 'Heading 3 Style',
										'h4' => 'Heading 4 Style',
										'h5' => 'Heading 5 Style',
										'h6' => 'Heading 6 Style',
										'lead' => 'Lead Paragraph',
										'p' => 'Paragraph',
									),
									'default_value' => array(
										0 => 'h2',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'placeholder' => '',
									'disabled' => 0,
									'readonly' => 0,
									'return_format' => 'value',
								),
								array(
									'key' => 'field_57586c184d8f7',
									'label' => 'Content',
									'name' => 'rails_content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '80',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 3,
									'new_lines' => 'br',
								),
							),
						),
						array(
							'key' => 'field_57586c184d8f8',
							'label' => 'Content',
							'name' => 'content_wysiwyg',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d8f3',
										'operator' => '==',
										'value' => 'free',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<h2>Commoveo te a neque amet paratus.</h2><p class="h5 text-uppercase">Commoveo te a neque amet paratus.</p><p class="lead">Feugait magna singularis iustum causa neo turpis plaga genitus. Ratis a sed a. Nutus melior in duis esse probo amet importunus eros macto wisi. Eum tation ad duis aliquam verto vel. Lucidus roto praesent plaga importunus dolor vulpes importunus lucidus.</p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_57586c184d8f9',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c184d8fc',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be53caf6c1',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d8fd',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e53400f8911',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'575721126957b' => array(
					'key' => '575721126957b',
					'name' => 'background_divider_saw',
					'label' => 'Background Divider: Saw',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c184d8fe',
							'label' => 'Top DIV Color',
							'name' => 'saw_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'gd',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 1,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d8ff',
							'label' => 'Bottom DIV Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 1,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d900',
							'label' => 'Saw Size',
							'name' => 'size',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'xs' => 'X-Small',
								'sm' => 'Small',
								'md' => 'Medium',
								'lg' => 'Large',
							),
							'default_value' => array(
								0 => 'md',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'5746e81f0017b' => array(
					'key' => '5746e81f0017b',
					'name' => 'pattern_blocks_1',
					'label' => 'Block Content',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c184d901',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c184d902',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => 'Note: Left-aligned square images will be set at two columns.',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								'2_2' => 'Two (Two on XS)',
								3 => 'Three',
								4 => 'Four',
								'4_2' => 'Four (Two on XS)',
								6 => 'Six',
								'6_2' => 'Six (Two on XS)',
							),
							'default_value' => array(
								0 => 1,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d903',
							'label' => 'Content Type',
							'name' => 'content_type',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'rails' => 'On Rails (Predefined Types)',
								'free' => 'Custom (WYSIWYG)',
								'code' => 'Custom (Code)',
							),
							'default_value' => array(
								0 => 'rails',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d904',
							'label' => 'Alignment',
							'name' => 'rails_alignment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d903',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Centered',
							),
							'default_value' => array(
								0 => 'center',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d905',
							'label' => 'Image',
							'name' => 'rails_image_available',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d903',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57586c184d906',
							'label' => 'Image Ratio',
							'name' => 'rails_image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d905',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'1x1' => 'Square',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d907',
							'label' => 'Image Effect',
							'name' => 'rails_image_effect',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d905',
										'operator' => '==',
										'value' => '1',
									),
									array(
										'field' => 'field_57586c184d906',
										'operator' => '==',
										'value' => '1x1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'circle' => 'Circle',
								'thumbnail' => 'Thumbnail',
							),
							'default_value' => array(
								0 => 'none',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d908',
							'label' => 'Header Style',
							'name' => 'rails_header_type',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d903',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'h3' => 'Heading 3 Style',
								'h4' => 'Heading 4 Style',
								'h5' => 'Heading 5 Style',
								'h6' => 'Heading 6 Style',
							),
							'default_value' => array(
								0 => 'h2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'disabled' => 0,
							'readonly' => 0,
							'return_format' => 'value',
						),
						array(
							'key' => 'field_57586c184d909',
							'label' => 'Content',
							'name' => 'content_rails',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d903',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_57586c184d90d',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_57586c184d90c',
									'label' => 'Image',
									'name' => 'rails_image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c184d905',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_57586c184d90a',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'select',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										1 => 'Internal',
										2 => 'External',
										3 => 'No',
									),
									'default_value' => array(
										0 => 3,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_57586c184d90b',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c184d90a',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '80',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => array(
									),
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_59930dde2c6f4',
									'label' => 'URL',
									'name' => 'url',
									'type' => 'url',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c184d90a',
												'operator' => '==',
												'value' => '2',
											),
										),
									),
									'wrapper' => array(
										'width' => '80',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
								),
								array(
									'key' => 'field_57586c184d90d',
									'label' => 'Header',
									'name' => 'rails_header',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 2,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_57586c184d90e',
									'label' => 'Paragraph',
									'name' => 'rails_paragraph',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_57e58c456da0a',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_57586c184d90f',
							'label' => 'Content',
							'name' => 'content_wysiwyg',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d903',
										'operator' => '==',
										'value' => 'free',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_57586c184d910',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_57586c184d910',
									'label' => 'WYSIWYG Content',
									'name' => 'wysiwyg_content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '<h3>Sed Dignissim Lacinia</h3><p>Morbi in dui quis est pulvinar ullamcorper. Nulla facilisi integer lacinia sollicitudin massa.</p>',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 0,
									'delay' => 1,
								),
								array(
									'key' => 'field_57e58c5a6da0b',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class_wysiwyg',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_57ea93125742d',
							'label' => 'Content',
							'name' => 'content_code',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d903',
										'operator' => '==',
										'value' => 'code',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_57ea93125742e',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_57ea93125742e',
									'label' => 'Code Content',
									'name' => 'code_content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c184d903',
												'operator' => '==',
												'value' => 'code',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
								),
								array(
									'key' => 'field_57ea93125742f',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class_code',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_57586c184d911',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c184d914',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be56faf6c2',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e53405f8912',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'582093ace61ee' => array(
					'key' => '582093ace61ee',
					'name' => 'pattern_content_2',
					'label' => 'Block Content: Custom',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_582093ace61ef',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_582093ace61f0',
							'label' => 'Content',
							'name' => 'content',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_58209509e61fc',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Block',
							'sub_fields' => array(
								array(
									'key' => 'field_58209509e61fc',
									'label' => 'Type',
									'name' => 'type',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'column' => 'Column',
										'code' => 'Code',
										'break' => 'Break',
									),
									'default_value' => array(
										0 => 'column',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_58209568e61fd',
									'label' => 'Break',
									'name' => 'break',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_58209509e61fc',
												'operator' => '==',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '80',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'xs' => 'X-Small',
										'sm' => 'Small',
										'md' => 'Medium',
										'lg' => 'Large',
									),
									'default_value' => array(
										0 => 'xs',
										1 => 'sm',
										2 => 'md',
										3 => 'lg',
									),
									'layout' => 'horizontal',
									'toggle' => 0,
									'return_format' => 'value',
									'allow_custom' => 0,
									'save_custom' => 0,
								),
								array(
									'key' => 'field_582093ace61f2',
									'label' => 'X-Small',
									'name' => 'xs',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_58209509e61fc',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_582094d4e61f9',
									'label' => 'Small',
									'name' => 'sm',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_58209509e61fc',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_582094dce61fa',
									'label' => 'Medium',
									'name' => 'md',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_58209509e61fc',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_582095bde61fe',
									'label' => 'Large',
									'name' => 'lg',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_58209509e61fc',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_582093ace61f3',
									'label' => 'Column',
									'name' => 'column',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_58209509e61fc',
												'operator' => '==',
												'value' => 'column',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 1,
									'delay' => 0,
								),
								array(
									'key' => 'field_5820e20a933e3',
									'label' => 'Code',
									'name' => 'code',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_58209509e61fc',
												'operator' => '==',
												'value' => 'code',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
								),
								array(
									'key' => 'field_5820e39e6c4d0',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_58209509e61fc',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_582093ace61f5',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_582093ace61f6',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_582093ace61f7',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_582093ace61f8',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57570408c009f' => array(
					'key' => '57570408c009f',
					'name' => 'pattern_figures_2',
					'label' => 'Block Content: Image Blocks',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c184d926',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c184d927',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								3 => 'Three',
								4 => 'Four',
								6 => 'Six',
							),
							'default_value' => array(
								0 => 1,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d928',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'1x1' => 'Square',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3:2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d929',
							'label' => 'Blocks',
							'name' => 'blocks',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Block',
							'sub_fields' => array(
								array(
									'key' => 'field_57586c184d92a',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_57586c184d92b',
									'label' => 'Text',
									'name' => 'text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
								array(
									'key' => 'field_580904ae7229b',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'post_type' => '',
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
							),
						),
						array(
							'key' => 'field_57586c184d92c',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c184d92f',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be59caf6c4',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e5340ff8914',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'58c98a87d375e' => array(
					'key' => '58c98a87d375e',
					'name' => 'pattern_content_3',
					'label' => 'Block Content: Image List',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_58c98a88d375f',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_58c995e5d3771',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'2_10' => '2 and 10',
								'3_9' => '3 and 9',
								'4_8' => '4 and 8',
							),
							'default_value' => array(
								0 => '2_10',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
						array(
							'key' => 'field_58c98a88d3760',
							'label' => 'Content',
							'name' => 'content',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_58ca8fb42a1ce',
							'min' => 0,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content Block',
							'sub_fields' => array(
								array(
									'key' => 'field_58ca8f482a1cc',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_58ca8f842a1cd',
									'label' => 'Image Caption',
									'name' => 'image_caption',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
								array(
									'key' => 'field_58ca8fb42a1ce',
									'label' => 'Content',
									'name' => 'content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'full',
									'media_upload' => 0,
									'delay' => 0,
								),
							),
						),
						array(
							'key' => 'field_58c98a88d376a',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_58c98a88d376b',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_58c98a88d376c',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_58c98a88d376d',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'5750829d77e7d' => array(
					'key' => '5750829d77e7d',
					'name' => 'pattern_figures_1',
					'label' => 'Figures',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c184d915',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c184d916',
							'label' => 'Figure or Gallery',
							'name' => 'figure_or_gallery',
							'type' => 'select',
							'instructions' => 'Galleries should be for three or more images.',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'figure' => 'Figure',
								'gallery' => 'Gallery',
							),
							'default_value' => array(
								0 => 'figure',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d917',
							'label' => 'Figures',
							'name' => 'figures',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d916',
										'operator' => '==',
										'value' => 'figure',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 2,
							'layout' => 'block',
							'button_label' => 'Add Figure',
							'sub_fields' => array(
								array(
									'key' => 'field_57586c184d919',
									'label' => 'Ratio',
									'name' => 'ratio',
									'type' => 'select',
									'instructions' => 1,
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1x1' => 'Square',
										'3x2' => '3:2',
										'16x9' => '16:9',
									),
									'default_value' => array(
										0 => '3:2',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_57586c184d91a',
									'label' => 'Caption?',
									'name' => 'caption',
									'type' => 'select',
									'instructions' => 'Caption',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'none' => 'None',
										'below' => 'Below',
										'right' => 'Right',
									),
									'default_value' => array(
										0 => 'none',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_57586c184d918',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_57586c184d91b',
									'label' => 'Caption Content',
									'name' => 'content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c184d91a',
												'operator' => '!=',
												'value' => 'none',
											),
										),
									),
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 3,
									'new_lines' => 'br',
								),
							),
						),
						array(
							'key' => 'field_57586c184d91c',
							'label' => 'Columns',
							'name' => 'columns_gallery',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d916',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								3 => 'Three',
								4 => 'Four',
								6 => 'Six',
							),
							'default_value' => array(
								0 => 1,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d91d',
							'label' => 'Caption Position',
							'name' => 'caption_gallery',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d916',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Center',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57586c184d91e',
							'label' => 'Gallery',
							'name' => 'gallery',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57586c184d916',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Gallery Image',
							'sub_fields' => array(
								array(
									'key' => 'field_57586c184d91f',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '35',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_57586c184d920',
									'label' => 'Ratio',
									'name' => 'ratio',
									'type' => 'select',
									'instructions' => 1,
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '15',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1x1' => 'Square',
										'3x2' => '3:2',
										'16x9' => '16:9',
									),
									'default_value' => array(
										0 => '3:2',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_57586c184d921',
									'label' => 'Caption Content',
									'name' => 'content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => 35,
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 3,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
							),
						),
						array(
							'key' => 'field_57586c184d922',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c184d925',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be585af6c3',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e53409f8913',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'5790bf7751ced' => array(
					'key' => '5790bf7751ced',
					'name' => 'pattern_media_1',
					'label' => 'Media',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5790bf7751cee',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57921abdd80da',
							'label' => 'Show Media Descriptions?',
							'name' => 'media',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57921a12fd465',
							'label' => 'Media Description Before',
							'name' => 'media_description_before',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57921abdd80da',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 0,
							'delay' => 1,
						),
						array(
							'key' => 'field_5792226910901',
							'label' => 'Media Description After',
							'name' => 'media_description_after',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57921abdd80da',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 0,
							'delay' => 1,
						),
						array(
							'key' => 'field_5790c5c20fedf',
							'label' => 'Media Type',
							'name' => 'media_type',
							'type' => 'radio',
							'instructions' => 'Select a type of content you wish to add. Media will fill the width of the container.',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'youtube' => 'YouTube ID',
								'soundcloud' => 'SoundCloud ID',
								'gallery' => 'Gallery',
								'embed' => 'Embed Code',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'save_other_choice' => 0,
							'default_value' => '',
							'layout' => 'horizontal',
							'return_format' => 'value',
						),
						array(
							'key' => 'field_5790cfb8e0ff0',
							'label' => 'YouTube ID',
							'name' => 'youtube_id',
							'type' => 'text',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5790c5c20fedf',
										'operator' => '==',
										'value' => 'youtube',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
							'readonly' => 0,
							'disabled' => 0,
						),
						array(
							'key' => 'field_5790cfcfe0ff1',
							'label' => 'SoundCloud ID',
							'name' => 'soundcloud_id',
							'type' => 'text',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5790c5c20fedf',
										'operator' => '==',
										'value' => 'soundcloud',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
							'readonly' => 0,
							'disabled' => 0,
						),
						array(
							'key' => 'field_5790d0c2e0ff2',
							'label' => 'Gallery Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5790c5c20fedf',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'1x1' => 'Square',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5790bf7751cf5',
							'label' => 'Gallery Columns',
							'name' => 'gallery_columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5790c5c20fedf',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								3 => 'Three',
								4 => 'Four',
								6 => 'Six',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5790bf7751cf6',
							'label' => 'Gallery Captions',
							'name' => 'gallery_captions',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5790c5c20fedf',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'No Captions',
								'left' => 'Left',
								'center' => 'Center',
							),
							'default_value' => array(
								0 => 'none',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5790d108e0ff3',
							'label' => 'Gallery Images',
							'name' => 'gallery_images',
							'type' => 'gallery',
							'instructions' => 'Note: Gallery thumbnails will be linked to the original uploaded file. Please be mindful of your file sizes.',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5790c5c20fedf',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 'thumbnail',
							'insert' => 'append',
							'library' => 'all',
							'min' => '',
							'max' => '',
							'min_width' => 600,
							'min_height' => 600,
							'min_size' => '',
							'max_width' => 2400,
							'max_height' => 2400,
							'max_size' => '',
							'mime_types' => '',
						),
						array(
							'key' => 'field_5790d125e0ff4',
							'label' => 'Embed Code',
							'name' => 'embed_code',
							'type' => 'textarea',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5790c5c20fedf',
										'operator' => '==',
										'value' => 'embed',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'maxlength' => '',
							'rows' => '',
							'new_lines' => '',
							'readonly' => 0,
							'disabled' => 0,
						),
						array(
							'key' => 'field_5790bf7751cfb',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5790bf7751cfc',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5790bf7751cfd',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e53414f8915',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'574da56c3e3ac' => array(
					'key' => '574da56c3e3ac',
					'name' => 'pattern_content_1',
					'label' => 'Normal Content',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57586c184d930',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c184d931',
							'label' => 'Content',
							'name' => 'content',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content Block',
							'sub_fields' => array(
								array(
									'key' => 'field_57586c184d932',
									'label' => 'Columns',
									'name' => 'columns',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										1 => 'One',
										2 => 'Two',
									),
									'default_value' => array(
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_57586c184d933',
									'label' => 'Split',
									'name' => 'split',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c184d932',
												'operator' => '==',
												'value' => '2',
											),
										),
									),
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1_11' => '1 and 11',
										'2_10' => '2 and 10',
										'3_9' => '3 and 9',
										'4_8' => '4 and 8',
										'5_7' => '5 and 7',
										'6_6' => '6 and 6',
										'7_5' => '7 and 5',
										'8_4' => '8 and 4',
										'9_3' => '9 and 3',
										'10_2' => '10 and 2',
										'11_1' => '11 and 1',
									),
									'default_value' => array(
										0 => '6_6',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_57586c184d934',
									'label' => 'Content',
									'name' => 'content_1',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'full',
									'media_upload' => 1,
									'delay' => 0,
								),
								array(
									'key' => 'field_57586c184d935',
									'label' => 'Content',
									'name' => 'content_2',
									'type' => 'wysiwyg',
									'instructions' => 'Less content than the first.',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57586c184d932',
												'operator' => '==',
												'value' => '2',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 1,
									'delay' => 0,
								),
							),
						),
						array(
							'key' => 'field_57586c184d936',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57586c184d939',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be5b8af6c5',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e5341ef8916',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57619ddccff80' => array(
					'key' => '57619ddccff80',
					'name' => 'reusable_content',
					'label' => 'Reusable Content',
					'display' => 'table',
					'sub_fields' => array(
						array(
							'key' => 'field_57619de4cff81',
							'label' => 'Reusable Content ID',
							'name' => 'reusable_content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
							'readonly' => 0,
							'disabled' => 0,
						),
					),
					'min' => '',
					'max' => '',
				),
			),
			'button_label' => 'Add Content Container Block',
			'min' => '',
			'max' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-1.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-2.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-3.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-4.php',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
	),
	'menu_order' => 80,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));


endif;



