<?php

if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_57616851d4ad7',
	'title' => 'Flexible Content (Options)',
	'fields' => array(
		array(
			'key' => 'field_57616851f1678',
			'label' => 'Content Options',
			'name' => 'content_options',
			'type' => 'flexible_content',
			'instructions' => 'These areas may be reused on your site via ID.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layouts' => array(
				'573b27f70af6c' => array(
					'key' => '573b27f70af6c',
					'name' => 'pattern_slider_1',
					'label' => 'Slider: Banner',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57616887b2294',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57616899b2295',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_5761964f63ec3',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5761685204189',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576168520434e',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x1' => '3:1',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x1',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57616852044f7',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685204694',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_577cfd212e97f',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_577cfd212e97f',
									'label' => 'Display',
									'name' => 'display',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'image' => 'Image',
										'banner' => 'Banner',
									),
									'default_value' => array(
										0 => 'image',
										1 => 'banner',
									),
									'layout' => 'horizontal',
									'toggle' => 0,
									'allow_custom' => 0,
									'save_custom' => 0,
									'return_format' => 'value',
								),
								array(
									'key' => 'field_5761685216dbb',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577cfd212e97f',
												'operator' => '==',
												'value' => 'image',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_5761685216eb1',
									'label' => 'Color',
									'name' => 'block_color',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577cfd212e97f',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'c' => 'Canvas',
										'w' => 'White',
										'gt' => 'Garnet',
										'gd' => 'Gold',
										'gd1c' => 'Gold + 1 Canvas',
										'gd2c' => 'Gold + 2 Canvas',
										'gd3c' => 'Gold + 3 Canvas',
										'n2w' => 'Neutral + 2 White',
										'n1w' => 'Neutral + 1 White',
										'n' => 'Neutral',
										'n2s' => 'Neutral + 2 Slate',
										's' => 'Slate',
										'k' => 'Black',
									),
									'default_value' => array(
										0 => 'c',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5761685216f77',
									'label' => 'Position',
									'name' => 'block_position',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577cfd212e97f',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'left' => 'Left',
										'right' => 'Right',
									),
									'default_value' => array(
										0 => 'left',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_576168521702b',
									'label' => 'Design',
									'name' => 'embellishment',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577cfd212e97f',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'none' => 'None',
										'arrow' => 'Arrow',
										'point' => 'Point',
									),
									'default_value' => array(
										0 => 'none',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_57616852170d5',
									'label' => 'Content Header',
									'name' => 'block_content_header',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577cfd212e97f',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_576168521718c',
									'label' => 'Content Paragraph',
									'name' => 'block_content_paragraph',
									'type' => 'textarea',
									'instructions' => '* Does not show on smallest display.',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577cfd212e97f',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_5761685217254',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577cfd212e97f',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '10',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'ui' => 0,
									'ui_on_text' => '',
									'ui_off_text' => '',
								),
								array(
									'key' => 'field_5761685217314',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5761685217254',
												'operator' => '==',
												'value' => '1',
											),
											array(
												'field' => 'field_577cfd212e97f',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_57616852173bf',
									'label' => 'Link Text',
									'name' => 'link_text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5761685217254',
												'operator' => '==',
												'value' => '1',
											),
											array(
												'field' => 'field_577cfd212e97f',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'default_value' => 'Read More',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_576168520476c',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576168520482a',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_57616852048b9',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520495c',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bdd7a92133',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685204a1b',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e53044a5823',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'573ca7b7dc751' => array(
					'key' => '573ca7b7dc751',
					'name' => 'pattern_slider_3',
					'label' => 'Slider: Description Below Image',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57616aa3fb1eb',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576168dcb2297',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_576197fdc2ffe',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_57616852052ff',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57616852053cb',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x1' => '3:1',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x1',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685205636',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685205492',
							'label' => 'Block Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57616852057c0',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 2,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_5761685264433',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_57616852644f3',
									'label' => 'Content Header',
									'name' => 'block_content_header',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_57616852645c0',
									'label' => 'Content Paragraph',
									'name' => 'block_content_paragraph',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
								),
								array(
									'key' => 'field_5761685264685',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '10',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'ui' => 0,
									'ui_on_text' => '',
									'ui_off_text' => '',
								),
								array(
									'key' => 'field_5761685264736',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5761685264685',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_57616852647de',
									'label' => 'Link Text',
									'name' => 'link_text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5761685264685',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'default_value' => 'Read More',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_5761685205890',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761685205956',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5761685205a2f',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685205add',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bddb592135',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685205bab',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e53079a5825',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'573cc254d9c29' => array(
					'key' => '573cc254d9c29',
					'name' => 'pattern_slider_4',
					'label' => 'Slider: Split',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57616ab2fb1ec',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761691ab2298',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_5761980cc2fff',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5761685205c59',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761685205dfe',
							'label' => 'Columns',
							'name' => 'columns_3x2',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57616851f1678',
										'operator' => '!=empty',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'4_8' => '(4 and 8) or (8 and 4)',
								'6_6' => '(6 and 6)',
							),
							'default_value' => array(
								0 => '4_8',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520602d',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57616851f1678',
										'operator' => '!=empty',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685206107',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_5761685287905',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_57616852879d4',
									'label' => 'Color',
									'name' => 'block_color',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'c' => 'Canvas',
										'w' => 'White',
										'gt' => 'Garnet',
										'gd' => 'Gold',
										'gd1c' => 'Gold + 1 Canvas',
										'gd2c' => 'Gold + 2 Canvas',
										'gd3c' => 'Gold + 3 Canvas',
										'n2w' => 'Neutral + 2 White',
										'n1w' => 'Neutral + 1 White',
										'n' => 'Neutral',
										'n2s' => 'Neutral + 2 Slate',
										's' => 'Slate',
										'k' => 'Black',
									),
									'default_value' => array(
										0 => 'c',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5761685287a97',
									'label' => 'Position',
									'name' => 'block_position',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'left' => 'Left',
										'right' => 'Right',
									),
									'default_value' => array(
										0 => 'left',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5761685287b42',
									'label' => 'Content Header',
									'name' => 'block_content_header',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_5761685287c19',
									'label' => 'Content Paragraph',
									'name' => 'block_content_paragraph',
									'type' => 'textarea',
									'instructions' => '* Does not show on smallest display.',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_5761685287cce',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '10',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'ui' => 0,
									'ui_on_text' => '',
									'ui_off_text' => '',
								),
								array(
									'key' => 'field_5761685287da0',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5761685287cce',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_5761685287e66',
									'label' => 'Link Text',
									'name' => 'link_text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5761685287cce',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'default_value' => 'Read More',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_57616852061c5',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761685206287',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5761685206332',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57616852063ef',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bddd492136',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57616852064a8',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e53080a5826',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'574dbee3293d8' => array(
					'key' => '574dbee3293d8',
					'name' => 'pattern_slider_5',
					'label' => 'Slider: Split With Static Message',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57616ac3fb1ed',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57616932b2299',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_57619819c3000',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5761685206565',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57616852066e1',
							'label' => 'Columns',
							'name' => 'columns_3x2',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'4_8' => '(4 and 8) or (8 and 4)',
								'6_6' => '(6 and 6)',
							),
							'default_value' => array(
								0 => '4_8',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520692e',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57616852069ec',
							'label' => 'Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685206ab6',
							'label' => 'Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685206b6d',
							'label' => 'Content',
							'name' => 'block_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<p class="h3 s3-fs-xs-4 text-center">Lorem Ipsum Dolor Sit Amet Consectetur Adipiscing Elit</p><hr><p class="text-center"><a class="btn btn-link btn-go" href="#">Read more</a></p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_5761685206c50',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_57616852b4949',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
							),
						),
						array(
							'key' => 'field_5761685206cfc',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761685206db4',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5761685206e8d',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685206f52',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bddf092137',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520701d',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e53087a5827',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'574de4a4690f9' => array(
					'key' => '574de4a4690f9',
					'name' => 'pattern_slider_6',
					'label' => 'Slider: Carousel',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57616adbfb1ee',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57616958b229a',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_57619825c3001',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_57616852070e3',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57616852071c2',
							'label' => 'Display Message?',
							'name' => 'message',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_576168520733c',
							'label' => 'Message Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57616852071c2',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685207272',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57616852071c2',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3_9' => '(3 and 9) or (9 and 3)',
								'4_8' => '(4 and 8) or (8 and 4)',
							),
							'default_value' => array(
								0 => '4_8',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57616852073eb',
							'label' => 'Message Content',
							'name' => 'message_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57616852071c2',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'basic',
							'media_upload' => 0,
							'delay' => 1,
						),
						array(
							'key' => 'field_57616852074c0',
							'label' => 'Show Images',
							'name' => 'image',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57616852076cc',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57616851f1678',
										'operator' => '!=empty',
									),
								),
							),
							'wrapper' => array(
								'width' => '66',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 's',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685207785',
							'label' => 'Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57616852078cf',
							'label' => 'Banner Height',
							'name' => 'block_height',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'feature-fixed-1' => 'Large',
								'feature-fixed-2' => 'Medium',
								'feature-fixed-3' => 'Small',
							),
							'default_value' => array(
								0 => 'feature-fixed-2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685207993',
							'label' => 'Design',
							'name' => 'embellishment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'arrow' => 'Arrow',
								'point' => 'Point',
							),
							'default_value' => array(
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685207a48',
							'label' => 'Slides',
							'name' => 'slides',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'table',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_57616852e0ad6',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_57616852e0b9e',
									'label' => 'Content',
									'name' => 'content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '66',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 0,
									'delay' => 0,
								),
							),
						),
						array(
							'key' => 'field_5761685207b13',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761685207bb9',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5761685207c66',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685207d19',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bde1192138',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685207ddd',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5308ea5828',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'573f663817335' => array(
					'key' => '573f663817335',
					'name' => 'pattern_feature_1',
					'label' => 'Feature: Background Cover with Banner',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57616b16fb1ef',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57616978b229b',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_57619831c3002',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5761685207e91',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761685208034',
							'label' => 'Image',
							'name' => 'image',
							'type' => 'image',
							'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 's3-md-16x9',
							'library' => 'all',
							'min_width' => 600,
							'min_height' => 300,
							'min_size' => '',
							'max_width' => 2400,
							'max_height' => 2400,
							'max_size' => '.4',
							'mime_types' => 'jpg, png, gif',
						),
						array(
							'key' => 'field_5761685207f64',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '16x9',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520849f',
							'label' => 'Design',
							'name' => 'embellishment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'arrow' => 'Arrow',
								'point' => 'Point',
							),
							'default_value' => array(
								0 => 'none',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685208104',
							'label' => 'Banner Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57616852081c4',
							'label' => 'Banner Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685208277',
							'label' => 'Banner Width',
							'name' => 'block_width',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57616852081c4',
										'operator' => '!=',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								4 => 'Four/Five Columns',
								5 => 'Five Columns',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685208343',
							'label' => 'Banner Width',
							'name' => 'block_width_center',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57616852081c4',
										'operator' => '==',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								4 => 'Four Columns',
								6 => 'Six Columns',
								8 => 'Eight Columns',
								10 => 'Ten Columns',
								12 => 'Twelve Columns',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57616852083ed',
							'label' => 'Banner Content',
							'name' => 'block_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<h3 class="s3-fs-sm-3">Patria feugait quis valetudo.</h3><p class="s3-fs-sm-1">Dolore regula pagus exerci minim bis quidne. Illum premo quidem dignissim melior exerci sed letatio in tum.</p><p class="h4 s3-fs-sm-2"><a href="#">Read More <span class="fa fa-chevron-right"></span></a></p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_5761685208562',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761685208615',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_57616852086e0',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57616852087ae',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bde2992139',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685208855',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e53098a5829',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57431f40dcbed' => array(
					'key' => '57431f40dcbed',
					'name' => 'pattern_feature_2',
					'label' => 'Feature: Background Cover',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57616b28fb1f0',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761698db229c',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_57619842c3003',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_576168520890b',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761685208a8b',
							'label' => 'Image',
							'name' => 'image',
							'type' => 'image',
							'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 's3-md-16x9',
							'library' => 'all',
							'min_width' => 600,
							'min_height' => 300,
							'min_size' => '',
							'max_width' => 2400,
							'max_height' => 2400,
							'max_size' => '.4',
							'mime_types' => 'jpg, png, gif',
						),
						array(
							'key' => 'field_57616852089c9',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '16x9',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685208b45',
							'label' => 'Banner Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685208c1a',
							'label' => 'Banner Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685208cd0',
							'label' => 'Banner Width',
							'name' => 'block_width',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5761685208c1a',
										'operator' => '!=',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								3 => 'Three Columns',
								4 => 'Four Columns',
								5 => 'Five Columns',
								6 => 'Six Columns',
							),
							'default_value' => array(
								0 => 3,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685208d9b',
							'label' => 'Banner Width',
							'name' => 'block_width_center',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5761685208c1a',
										'operator' => '==',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								4 => 'Four Columns',
								6 => 'Six Columns',
								8 => 'Eight Columns',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685208e5b',
							'label' => 'Banner Content',
							'name' => 'block_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<h3 class="s3-fs-sm-3">Patria feugait quis valetudo.</h3><p class="s3-fs-sm-1">Dolore regula pagus exerci minim bis quidne. Illum premo quidem dignissim melior exerci sed letatio in tum.</p><p class="h4 s3-fs-sm-2"><a href="#">Read More <span class="fa fa-chevron-right"></span></a></p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_5761685208f0c',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761685208fd3',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5761685209081',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685209144',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bde3d9213a',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57616852091f6',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5309ea582a',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57435b0bf31f8' => array(
					'key' => '57435b0bf31f8',
					'name' => 'pattern_feature_3',
					'label' => 'Feature: Banners',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57616b36fb1f1',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576169b2b229d',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_5761985fc3004',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_57616852092c1',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761685209384',
							'label' => 'Banner Color Background',
							'name' => 'banner_color_background',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685209424',
							'label' => 'Banner Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57616852094e6',
							'label' => 'Banner Height',
							'name' => 'block_height',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'feature-fixed-1' => 'Large',
								'feature-fixed-2' => 'Medium',
								'feature-fixed-3' => 'Small',
							),
							'default_value' => array(
								0 => 'feature-fixed-2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520959a',
							'label' => 'Design',
							'name' => 'embellishment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'arrow' => 'Arrow',
								'point' => 'Point',
							),
							'default_value' => array(
								0 => 'arrow',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685209660',
							'label' => 'Block',
							'name' => 'block',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 2,
							'max' => 4,
							'layout' => 'block',
							'button_label' => 'Add Block Content',
							'sub_fields' => array(
								array(
									'key' => 'field_5761685338620',
									'label' => 'Block Content',
									'name' => 'block_content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '<h2>Patria feugait quis valetudo.</h2>Dolore regula pagus exerci minim bis quidne. Illum premo quidem dignissim melior exerci sed letatio in tum.<a class="btn btn-link btn-go s3-gd" href="#">Read More</a>',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 0,
									'delay' => 1,
								),
							),
						),
						array(
							'key' => 'field_5761685209726',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57616852097c7',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5761685209886',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685209946',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bde549213b',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57616852099f8',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e530a7a582b',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57444c75f9c06' => array(
					'key' => '57444c75f9c06',
					'name' => 'pattern_hero_1',
					'label' => 'Hero',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57616b43fb1f2',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576169c5b229e',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_5761986bc3005',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5761685209ac3',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761685209b7d',
							'label' => 'Content Type',
							'name' => 'content_type',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'rails' => 'On Rails (Predefined Types)',
								'free' => 'Custom (WYSIWYG)',
							),
							'default_value' => array(
								0 => 'rails',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685209c50',
							'label' => 'Alignment',
							'name' => 'rails_alignment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5761685209b7d',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Centered',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'center',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5761685209d19',
							'label' => 'Content',
							'name' => 'content_rails',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5761685209b7d',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '100',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_576168534c9c7',
									'label' => 'Content',
									'name' => 'rails_type',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5761685209b7d',
												'operator' => '==',
												'value' => 'rails',
											),
										),
									),
									'wrapper' => array(
										'width' => 20,
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'h1' => 'Heading 1 Style',
										'h2' => 'Heading 2 Style',
										'h3' => 'Heading 3 Style',
										'h4' => 'Heading 4 Style',
										'h5' => 'Heading 5 Style',
										'h6' => 'Heading 6 Style',
										'lead' => 'Lead Paragraph',
										'p' => 'Paragraph',
									),
									'default_value' => array(
										0 => 'h2',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'placeholder' => '',
									'disabled' => 0,
									'readonly' => 0,
									'return_format' => 'value',
								),
								array(
									'key' => 'field_576168534ca72',
									'label' => 'Content',
									'name' => 'rails_content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => 80,
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 3,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
							),
						),
						array(
							'key' => 'field_5761685209de5',
							'label' => 'Content',
							'name' => 'content_wysiwyg',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5761685209b7d',
										'operator' => '==',
										'value' => 'free',
									),
								),
							),
							'wrapper' => array(
								'width' => '100',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<h2>Commoveo te a neque amet paratus.</h2><p class="h5 text-uppercase">Commoveo te a neque amet paratus.</p><p class="lead">Feugait magna singularis iustum causa neo turpis plaga genitus. Ratis a sed a. Nutus melior in duis esse probo amet importunus eros macto wisi. Eum tation ad duis aliquam verto vel. Lucidus roto praesent plaga importunus dolor vulpes importunus lucidus.</p>',
							'tabs' => 'all',
							'toolbar' => 'basic',
							'media_upload' => 0,
							'delay' => 1,
						),
						array(
							'key' => 'field_5761685209eab',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5761685209f54',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_576168520a017',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 1,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520a0de',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bde6b9213c',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520a184',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e530afa582c',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'5746e81f0017b' => array(
					'key' => '5746e81f0017b',
					'name' => 'pattern_blocks_1',
					'label' => 'Block Content',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57616b4efb1f3',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576169d9b229f',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_57619877c3006',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_576168520a46f',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576168520a518',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => 'Note: Left-aligned square images will be set at two columns.',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								'2_2' => 'Two (Two on XS)',
								3 => 'Three',
								4 => 'Four',
								'4_2' => 'Four (Two on XS)',
								6 => 'Six',
								'6_2' => 'Six (Two on XS)',
							),
							'default_value' => array(
								0 => 1,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520a5d6',
							'label' => 'Content Type',
							'name' => 'content_type',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'rails' => 'On Rails (Predefined Types)',
								'free' => 'Custom (WYSIWYG)',
								'code' => 'Custom (Code)',
							),
							'default_value' => array(
								0 => 'rails',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520a685',
							'label' => 'Alignment',
							'name' => 'rails_alignment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_576168520a5d6',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Centered',
							),
							'default_value' => array(
								0 => 'center',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520a6e0',
							'label' => 'Image',
							'name' => 'rails_image_available',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_576168520a5d6',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_576168520a76c',
							'label' => 'Image Ratio',
							'name' => 'rails_image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_576168520a6e0',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'1x1' => 'Square',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520a828',
							'label' => 'Image Effect',
							'name' => 'rails_image_effect',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_576168520a6e0',
										'operator' => '==',
										'value' => '1',
									),
									array(
										'field' => 'field_576168520a76c',
										'operator' => '==',
										'value' => '1x1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'circle' => 'Circle',
								'thumbnail' => 'Thumbnail',
							),
							'default_value' => array(
								0 => 'none',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520a8d0',
							'label' => 'Header Style',
							'name' => 'rails_header_type',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_576168520a5d6',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'h3' => 'Heading 3 Style',
								'h4' => 'Heading 4 Style',
								'h5' => 'Heading 5 Style',
								'h6' => 'Heading 6 Style',
							),
							'default_value' => array(
								0 => 'h2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'disabled' => 0,
							'readonly' => 0,
							'return_format' => 'value',
						),
						array(
							'key' => 'field_576168520a97d',
							'label' => 'Content',
							'name' => 'content_rails',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_576168520a5d6',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_57616853737b4',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_57616853736d6',
									'label' => 'Image',
									'name' => 'rails_image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_576168520a6e0',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_57616853734c3',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'select',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										1 => 'Internal',
										2 => 'External',
										3 => 'No',
									),
									'default_value' => array(
										0 => 3,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_57616853735bf',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57616853734c3',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '80',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => array(
									),
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_599304cd175a7',
									'label' => 'URL',
									'name' => 'url',
									'type' => 'url',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57616853734c3',
												'operator' => '==',
												'value' => '2',
											),
										),
									),
									'wrapper' => array(
										'width' => '80',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
								),
								array(
									'key' => 'field_57616853737b4',
									'label' => 'Header',
									'name' => 'rails_header',
									'type' => 'textarea',
									'instructions' => '',
									'required' => '',
									'conditional_logic' => '',
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 2,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_5761685373879',
									'label' => 'Paragraph',
									'name' => 'rails_paragraph',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_57e584c8cd177',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_576168520aa39',
							'label' => 'Content',
							'name' => 'content_wysiwyg',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_576168520a5d6',
										'operator' => '==',
										'value' => 'free',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_5761685380a9a',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_5761685380a9a',
									'label' => 'WYSIWYG Content',
									'name' => 'wysiwyg_content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '<h3>Sed Dignissim Lacinia</h3><p>Morbi in dui quis est pulvinar ullamcorper. Nulla facilisi integer lacinia sollicitudin massa.</p>',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 0,
									'delay' => 1,
								),
								array(
									'key' => 'field_57e5850ccd178',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class_wysiwyg',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_57ea93d97a1a8',
							'label' => 'Content',
							'name' => 'content_code',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_576168520a5d6',
										'operator' => '==',
										'value' => 'code',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_57ea93d97a1a9',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_57ea93d97a1a9',
									'label' => 'Code Content',
									'name' => 'code_content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_576168520a5d6',
												'operator' => '==',
												'value' => 'code',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
								),
								array(
									'key' => 'field_57ea93d97a1aa',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class_code',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_576168520aad7',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576168520ab78',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_576168520ac17',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520acbf',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bde809213d',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e530b6a582d',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'5820f5c440f7b' => array(
					'key' => '5820f5c440f7b',
					'name' => 'pattern_content_2',
					'label' => 'Block Content: Custom',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5820f5c440f7c',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5820f5c440f7d',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_5820f5c440f7e',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5820f5c440f7f',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5820f5c440f80',
							'label' => 'Content',
							'name' => 'content',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_5820f5fb40f8b',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Block',
							'sub_fields' => array(
								array(
									'key' => 'field_5820f5fb40f8b',
									'label' => 'Type',
									'name' => 'type',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'column' => 'Column',
										'code' => 'Code',
										'break' => 'Break',
									),
									'default_value' => array(
										0 => 'column',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820f63d40f8c',
									'label' => 'Break',
									'name' => 'break',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f5fb40f8b',
												'operator' => '==',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '80',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'xs' => 'X-Small',
										'sm' => 'Small',
										'md' => 'Medium',
										'lg' => 'Large',
									),
									'default_value' => array(
										0 => 'xs',
										1 => 'sm',
										2 => 'md',
										3 => 'lg',
									),
									'layout' => 'horizontal',
									'toggle' => 0,
									'return_format' => 'value',
									'allow_custom' => 0,
									'save_custom' => 0,
								),
								array(
									'key' => 'field_5820f67640f8d',
									'label' => 'X-Small',
									'name' => 'xs',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f5fb40f8b',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820f6aa40f8e',
									'label' => 'Small',
									'name' => 'sm',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f5fb40f8b',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820f6b740f8f',
									'label' => 'Medium',
									'name' => 'md',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f5fb40f8b',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820f6be40f90',
									'label' => 'Large',
									'name' => 'lg',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f5fb40f8b',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820f6cd40f91',
									'label' => 'Column',
									'name' => 'column',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f5fb40f8b',
												'operator' => '==',
												'value' => 'column',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 1,
									'delay' => 0,
								),
								array(
									'key' => 'field_5820f6fc40f92',
									'label' => 'Code',
									'name' => 'code',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f5fb40f8b',
												'operator' => '==',
												'value' => 'code',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
								),
								array(
									'key' => 'field_5820f72e40f93',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f5fb40f8b',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_5820f5c440f85',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5820f5c440f86',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5820f5c440f87',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5820f5c440f88',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5820f5c440f89',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5820f5c440f8a',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57570408c009f' => array(
					'key' => '57570408c009f',
					'name' => 'pattern_figures_2',
					'label' => 'Block Content: Image Blocks',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57616b6afb1f5',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57616a2eb22a1',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_57619892c3008',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_576168520b48d',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576168520b55c',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								3 => 'Three',
								4 => 'Four',
								6 => 'Six',
							),
							'default_value' => array(
								0 => 1,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520b621',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'1x1' => 'Square',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3:2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520b6c6',
							'label' => 'Blocks',
							'name' => 'blocks',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Block',
							'sub_fields' => array(
								array(
									'key' => 'field_57616853bbe70',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_57616853bbf31',
									'label' => 'Text',
									'name' => 'text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
								array(
									'key' => 'field_580917ee8fa09',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'post_type' => '',
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
							),
						),
						array(
							'key' => 'field_576168520b754',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576168520b7f8',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_576168520b8c2',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520b985',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bdeb79213f',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e530d8a5830',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'58d29b1963103' => array(
					'key' => '58d29b1963103',
					'name' => 'pattern_content_3',
					'label' => 'Block Content: Image List',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_58d29b1a63104',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_58d29b1a63105',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_58d29b1a63106',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_58d29b1a63107',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_58d29bd563122',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'2_10' => '2 and 10',
								'3_9' => '3 and 9',
								'4_8' => '4 and 8',
							),
							'default_value' => array(
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
						array(
							'key' => 'field_58d29c1c63123',
							'label' => 'Content',
							'name' => 'content',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_58d29c5a63126',
							'min' => 0,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content Block',
							'sub_fields' => array(
								array(
									'key' => 'field_58d29c3663124',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 'medium',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_58d29c4e63125',
									'label' => 'Image Caption',
									'name' => 'image_caption',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
								array(
									'key' => 'field_58d29c5a63126',
									'label' => 'Content',
									'name' => 'content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'full',
									'media_upload' => 0,
									'delay' => 0,
								),
							),
						),
						array(
							'key' => 'field_58d29b1a63112',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_58d29b1a63113',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_58d29b1a63114',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_58d29b1a63115',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_58d29b1a63116',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_58d29b1a63117',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'5750829d77e7d' => array(
					'key' => '5750829d77e7d',
					'name' => 'pattern_figures_1',
					'label' => 'Figures',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57616b5bfb1f4',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57616a12b22a0',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_57619886c3007',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_576168520ad5f',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576168520adfd',
							'label' => 'Figure or Gallery',
							'name' => 'figure_or_gallery',
							'type' => 'select',
							'instructions' => 'Galleries should be for three or more images.',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'figure' => 'Figure',
								'gallery' => 'Gallery',
							),
							'default_value' => array(
								0 => 'figure',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520aeb5',
							'label' => 'Figures',
							'name' => 'figures',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_576168520adfd',
										'operator' => '==',
										'value' => 'figure',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 2,
							'layout' => 'block',
							'button_label' => 'Add Figure',
							'sub_fields' => array(
								array(
									'key' => 'field_5761685391cb9',
									'label' => 'Ratio',
									'name' => 'ratio',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1x1' => 'Square',
										'3x2' => '3:2',
										'16x9' => '16:9',
									),
									'default_value' => array(
										0 => '3:2',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5761685391d5a',
									'label' => 'Caption?',
									'name' => 'caption',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'none' => 'None',
										'below' => 'Below',
										'right' => 'Right',
									),
									'default_value' => array(
										0 => 'none',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5761685391be5',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_5761685391e27',
									'label' => 'Caption Content',
									'name' => 'content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5761685391d5a',
												'operator' => '!=',
												'value' => 'none',
											),
										),
									),
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 3,
									'new_lines' => 'br',
								),
							),
						),
						array(
							'key' => 'field_576168520af6a',
							'label' => 'Columns',
							'name' => 'columns_gallery',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_576168520adfd',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								3 => 'Three',
								4 => 'Four',
								6 => 'Six',
							),
							'default_value' => array(
								0 => 1,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520b029',
							'label' => 'Caption Position',
							'name' => 'caption_gallery',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_576168520adfd',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Center',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520b0f5',
							'label' => 'Gallery',
							'name' => 'gallery',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_576168520adfd',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Gallery Image',
							'sub_fields' => array(
								array(
									'key' => 'field_57616853a28e7',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '35',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_57616853a29a5',
									'label' => 'Ratio',
									'name' => 'ratio',
									'type' => 'select',
									'instructions' => 1,
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '15',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1x1' => 'Square',
										'3x2' => '3:2',
										'16x9' => '16:9',
									),
									'default_value' => array(
										0 => '3:2',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_57616853a2a60',
									'label' => 'Caption Content',
									'name' => 'content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => 35,
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 3,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
							),
						),
						array(
							'key' => 'field_576168520b1ba',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576168520b269',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_576168520b2ff',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520b3c9',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bde9c9213e',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e530bca582e',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'579259835385f' => array(
					'key' => '579259835385f',
					'name' => 'pattern_media_1',
					'label' => 'Media',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5792598353860',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5792598353861',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_5792598353862',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_5792598353863',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_579259835386c',
							'label' => 'Show Media Descriptions?',
							'name' => 'media',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57925a2453875',
							'label' => 'Media Description Before',
							'name' => 'media_description_before',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_579259835386c',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 0,
							'delay' => 1,
						),
						array(
							'key' => 'field_57925a4b53876',
							'label' => 'Media Description After',
							'name' => 'media_description_after',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_579259835386c',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 0,
							'delay' => 1,
						),
						array(
							'key' => 'field_57925a6653877',
							'label' => 'Media Type',
							'name' => 'media_type',
							'type' => 'radio',
							'instructions' => 'Select a type of content you wish to add. Media will fill the width of the container.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'youtube' => 'YouTube ID',
								'soundcloud' => 'SoundCloud ID',
								'gallery' => 'Gallery',
								'embed' => 'Embed Code',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'save_other_choice' => 0,
							'default_value' => '',
							'layout' => 'horizontal',
							'return_format' => 'value',
						),
						array(
							'key' => 'field_57925a9053878',
							'label' => 'YouTube ID',
							'name' => 'youtube_id',
							'type' => 'text',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57925a6653877',
										'operator' => '==',
										'value' => 'youtube',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
							'readonly' => 0,
							'disabled' => 0,
						),
						array(
							'key' => 'field_57925ab653879',
							'label' => 'SoundCloud ID',
							'name' => 'soundcloud_id',
							'type' => 'text',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57925a6653877',
										'operator' => '==',
										'value' => 'soundcloud',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
							'readonly' => 0,
							'disabled' => 0,
						),
						array(
							'key' => 'field_57925ac85387a',
							'label' => 'Gallery Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57925a6653877',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'1x1' => 'Square',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57925af05387b',
							'label' => 'Gallery Columns',
							'name' => 'gallery_columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57925a6653877',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								3 => 'Three',
								4 => 'Four',
								6 => 'Six',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57925b135387c',
							'label' => 'Gallery Captions',
							'name' => 'gallery_captions',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57925a6653877',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'No Captions',
								'left' => 'Left',
								'center' => 'Center',
							),
							'default_value' => array(
								0 => 'none',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57925b325387d',
							'label' => 'Gallery Images',
							'name' => 'gallery_images',
							'type' => 'gallery',
							'instructions' => 'Note: Gallery thumbnails will be linked to the original uploaded file. Please be mindful of your file sizes.',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57925a6653877',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 's3-md-16x9',
							'insert' => 'append',
							'library' => 'all',
							'min' => '',
							'max' => '',
							'min_width' => 600,
							'min_height' => 600,
							'min_size' => '',
							'max_width' => 2400,
							'max_height' => 2400,
							'max_size' => '',
							'mime_types' => '',
						),
						array(
							'key' => 'field_57925b515387e',
							'label' => 'Embed Code',
							'name' => 'embed_code',
							'type' => 'textarea',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57925a6653877',
										'operator' => '==',
										'value' => 'embed',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'maxlength' => '',
							'rows' => '',
							'new_lines' => '',
							'readonly' => 0,
							'disabled' => 0,
						),
						array(
							'key' => 'field_5792598353870',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5792598353871',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5792598353872',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5792598353873',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5792598353874',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e530d0a582f',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'574da56c3e3ac' => array(
					'key' => '574da56c3e3ac',
					'name' => 'pattern_content_1',
					'label' => 'Normal Content',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57616b75fb1f6',
							'label' => 'ID',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57616a47b22a2',
							'label' => 'Content ID',
							'name' => 'content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
						),
						array(
							'key' => 'field_576198a4c3009',
							'label' => 'Description',
							'name' => 'description',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_576168520ba38',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576168520bace',
							'label' => 'Content',
							'name' => 'content',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content Block',
							'sub_fields' => array(
								array(
									'key' => 'field_57616853d1d9f',
									'label' => 'Columns',
									'name' => 'columns',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										1 => 'One',
										2 => 'Two',
									),
									'default_value' => array(
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_57616853d1e7b',
									'label' => 'Split',
									'name' => 'split',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57616853d1d9f',
												'operator' => '==',
												'value' => '2',
											),
										),
									),
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1_11' => '1 and 11',
										'2_10' => '2 and 10',
										'3_9' => '3 and 9',
										'4_8' => '4 and 8',
										'5_7' => '5 and 7',
										'6_6' => '6 and 6',
										'7_5' => '7 and 5',
										'8_4' => '8 and 4',
										'9_3' => '9 and 3',
										'10_2' => '10 and 2',
										'11_1' => '11 and 1',
									),
									'default_value' => array(
										0 => '6_6',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_57616853d1f3a',
									'label' => 'Content',
									'name' => 'content_1',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'full',
									'media_upload' => 1,
									'delay' => 0,
								),
								array(
									'key' => 'field_57616853d200b',
									'label' => 'Content',
									'name' => 'content_2',
									'type' => 'wysiwyg',
									'instructions' => 'Less content than the first.',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57616853d1d9f',
												'operator' => '==',
												'value' => '2',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 1,
									'delay' => 0,
								),
							),
						),
						array(
							'key' => 'field_576168520bb75',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_576168520bc1c',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_576168520bcd7',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576168520be20',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bdecc92140',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e530e4a5831',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
			),
			'button_label' => 'Add Content Container Block',
			'min' => '',
			'max' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-reusable-content',
			),
		),
	),
	'menu_order' => 60,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));


endif;



