<?php

if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_56536f6672fc8',
	'title' => 'Site Globals',
	'fields' => array(
		array(
			'key' => 'field_56536f839a5c9',
			'label' => 'Seal',
			'name' => 'site_seal',
			'type' => 'select',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'fsu-seal-3d-160x160.png' => '3D Gold',
				'fsu-seal-full-160x160.png' => 'Full Color',
				'fsu-seal-garnet-160x160.png' => 'Garnet',
				'fsu-seal-gold-160x160.png' => 'Gold',
				'fsu-seal-black-160x160.png' => 'Black',
			),
			'default_value' => array(
				'fsu-seal-3d-160x160.png' => 'fsu-seal-3d-160x160.png',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'disabled' => 0,
			'readonly' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_56537f1a2705f',
			'label' => 'Background: Body / Footer',
			'name' => 'site_body',
			'type' => 'select',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'gt' => 'Garnet',
				'gd' => 'Gold',
				'gd1c' => 'Gold+1C (Light Gold)',
				'gd2c' => 'Gold+2C (Lighter Gold)',
				'gd3c' => 'Gold+3C (Lightest Gold)',
				'c' => 'Canvas',
				'w' => 'White',
				'n2w' => 'Neutral+2W (Lighter Neutral)',
				'n1w' => 'Neutral+1W (Light Neutral)',
				'n' => 'Neutral',
				'n2s' => 'Neutral+1S (Darker Neutral)',
				's' => 'Slate',
				'k' => 'Black',
			),
			'default_value' => array(
				0 => 'gt',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_56537d8fa3c64',
			'label' => 'Background: Global / Utility Bar',
			'name' => 'site_global',
			'type' => 'select',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'gt' => 'Garnet',
				'gd' => 'Gold',
				'gd1c' => 'Gold+1C (Light Gold)',
				'gd2c' => 'Gold+2C (Lighter Gold)',
				'gd3c' => 'Gold+3C (Lightest Gold)',
				'c' => 'Canvas',
				'w' => 'White',
				'n2w' => 'Neutral+2W (Lighter Neutral)',
				'n1w' => 'Neutral+1W (Light Neutral)',
				'n' => 'Neutral',
				'n2s' => 'Neutral+1S (Darker Neutral)',
				's' => 'Slate',
				'k' => 'Black',
			),
			'default_value' => array(
				0 => 'gt',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_565381e5b3f7c',
			'label' => 'Background: Masthead',
			'name' => 'site_masthead',
			'type' => 'select',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'gt' => 'Garnet',
				'gd' => 'Gold',
				'gd1c' => 'Gold+1C (Light Gold)',
				'gd2c' => 'Gold+2C (Lighter Gold)',
				'gd3c' => 'Gold+3C (Lightest Gold)',
				'c' => 'Canvas',
				'w' => 'White',
				'n2w' => 'Neutral+2W (Lighter Neutral)',
				'n1w' => 'Neutral+1W (Light Neutral)',
				'n' => 'Neutral',
				'n2s' => 'Neutral+1S (Darker Neutral)',
				's' => 'Slate',
				'k' => 'Black',
			),
			'default_value' => array(
				0 => 'c',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_565381efb3f7d',
			'label' => 'Background: Navigation',
			'name' => 'site_navigation',
			'type' => 'select',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'gt' => 'Garnet',
				'gd' => 'Gold',
				'gd1c' => 'Gold+1C (Light Gold)',
				'gd2c' => 'Gold+2C (Lighter Gold)',
				'gd3c' => 'Gold+3C (Lightest Gold)',
				'c' => 'Canvas',
				'w' => 'White',
				'n2w' => 'Neutral+2W (Lighter Neutral)',
				'n1w' => 'Neutral+1W (Light Neutral)',
				'n' => 'Neutral',
				'n2s' => 'Neutral+1S (Darker Neutral)',
				's' => 'Slate',
				'k' => 'Black',
			),
			'default_value' => array(
				0 => 'c',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_565381f9b3f7e',
			'label' => 'Background: Content',
			'name' => 'site_content',
			'type' => 'select',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'gt' => 'Garnet',
				'gd' => 'Gold',
				'gd1c' => 'Gold+1C (Light Gold)',
				'gd2c' => 'Gold+2C (Lighter Gold)',
				'gd3c' => 'Gold+3C (Lightest Gold)',
				'c' => 'Canvas',
				'w' => 'White',
				'n2w' => 'Neutral+2W (Lighter Neutral)',
				'n1w' => 'Neutral+1W (Light Neutral)',
				'n' => 'Neutral',
				'n2s' => 'Neutral+1S (Darker Neutral)',
				's' => 'Slate',
				'k' => 'Black',
			),
			'default_value' => array(
				0 => 'w',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_577517977e938',
			'label' => 'Background: Posts',
			'name' => 'site_posts',
			'type' => 'select',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'gt' => 'Garnet',
				'gd' => 'Gold',
				'gd1c' => 'Gold+1C (Light Gold)',
				'gd2c' => 'Gold+2C (Lighter Gold)',
				'gd3c' => 'Gold+3C (Lightest Gold)',
				'c' => 'Canvas',
				'w' => 'White',
				'n2w' => 'Neutral+2W (Lighter Neutral)',
				'n1w' => 'Neutral+1W (Light Neutral)',
				'n' => 'Neutral',
				'n2s' => 'Neutral+1S (Darker Neutral)',
				's' => 'Slate',
				'k' => 'Black',
			),
			'default_value' => array(
				0 => 'c',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_577519e7c3d63',
			'label' => 'Background: Buttons',
			'name' => 'site_buttons',
			'type' => 'select',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'gt' => 'Garnet',
				'gd' => 'Gold',
				'gd1c' => 'Gold+1C (Light Gold)',
				'gd2c' => 'Gold+2C (Lighter Gold)',
				'gd3c' => 'Gold+3C (Lightest Gold)',
				'c' => 'Canvas',
				'w' => 'White',
				'n2w' => 'Neutral+2W (Lighter Neutral)',
				'n1w' => 'Neutral+1W (Light Neutral)',
				'n' => 'Neutral',
				'n2s' => 'Neutral+1S (Darker Neutral)',
				's' => 'Slate',
				'k' => 'Black',
			),
			'default_value' => array(
				0 => 'n2w',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5775233ed2bc8',
			'label' => 'Background: Highlights',
			'name' => 'site_highlights',
			'type' => 'select',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'gt' => 'Garnet',
				'gd' => 'Gold',
				'gd1c' => 'Gold+1C (Light Gold)',
				'gd2c' => 'Gold+2C (Lighter Gold)',
				'gd3c' => 'Gold+3C (Lightest Gold)',
				'c' => 'Canvas',
				'w' => 'White',
				'n2w' => 'Neutral+2W (Lighter Neutral)',
				'n1w' => 'Neutral+1W (Light Neutral)',
				'n' => 'Neutral',
				'n2s' => 'Neutral+1S (Darker Neutral)',
				's' => 'Slate',
				'k' => 'Black',
			),
			'default_value' => array(
				0 => 'gd3c',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5653894e1bf69',
			'label' => 'Scored Strata',
			'name' => 'strata_scored',
			'type' => 'checkbox',
			'instructions' => 'Add an edge effect to the layers.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'global' => 'Global / Utility',
				'masthead' => 'Masthead',
				'navigation' => 'Navigation',
				'content_above' => 'Content Above',
				'content' => 'Content',
				'content_below' => 'Content Below',
				'footer' => 'Footer',
			),
			'allow_custom' => 0,
			'default_value' => array(
				0 => 'global',
				1 => 'masthead',
				2 => 'navigation',
			),
			'layout' => 'horizontal',
			'toggle' => 0,
			'return_format' => 'value',
			'save_custom' => 0,
		),
		array(
			'key' => 'field_575f12b58322d',
			'label' => 'Breadcrumbs',
			'name' => 'breadcrumbs',
			'type' => 'true_false',
			'instructions' => 'Enabling breadcrumbs requires the Yoast SEO plugin.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5790c91bd4eb7',
			'label' => 'Gallery Type',
			'name' => 'site_gallery_type',
			'type' => 'radio',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'none' => 'None',
				'fresco' => 'Fresco',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'default_value' => 'none',
			'layout' => 'horizontal',
			'return_format' => 'value',
			'save_other_choice' => 0,
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-global',
			),
		),
	),
	'menu_order' => 10,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_56547d5a7744c',
	'title' => 'Utilities',
	'fields' => array(
		array(
			'key' => 'field_565610cafd2f2',
			'label' => 'Default Utilities',
			'name' => 'utilities_default',
			'type' => 'checkbox',
			'instructions' => 'Uncheck boxes to turn off utilities.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'search' => 'Default Search',
				'webmail' => 'Webmail',
			),
			'allow_custom' => 0,
			'default_value' => array(
				0 => 'search',
				1 => 'webmail',
			),
			'layout' => 'horizontal',
			'toggle' => 1,
			'return_format' => 'value',
			'save_custom' => 0,
		),
		array(
			'key' => 'field_56547e5e93c10',
			'label' => 'Add Utilities',
			'name' => 'utility',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => '',
			'min' => 0,
			'max' => 4,
			'layout' => 'row',
			'button_label' => 'Add Utility',
			'sub_fields' => array(
				array(
					'key' => 'field_56547faf93c11',
					'label' => 'Icon',
					'name' => 'icon',
					'type' => 'radio',
					'instructions' => 'Choose or add a Font Awesome Icon Example: fa-cog',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'fa-at' => '@',
						'fa-calendar' => 'Calendar',
						'fa-cog' => 'Gear',
						'fa-comment' => 'Message',
						'fa-envelope' => 'Envelope (Solid)',
						'fa-info-circle' => 'Information',
						'fa-map-marker' => 'Map Marker',
						'fa-rss' => 'RSS',
						'fa-sign-in' => 'Sign In',
						'fa-user' => 'User',
					),
					'other_choice' => 1,
					'save_other_choice' => 0,
					'default_value' => 'fa-cog',
					'layout' => 'horizontal',
					'allow_null' => 0,
					'return_format' => 'value',
				),
				array(
					'key' => 'field_5654af0cc9ace',
					'label' => 'Name',
					'name' => 'name',
					'type' => 'text',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
					'readonly' => 0,
					'disabled' => 0,
				),
				array(
					'key' => 'field_565484a193c12',
					'label' => 'Type',
					'name' => 'type',
					'type' => 'radio',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'drawer' => 'Dropdown Drawer',
						'link' => 'Link',
					),
					'other_choice' => 0,
					'save_other_choice' => 0,
					'default_value' => '',
					'layout' => 'horizontal',
					'allow_null' => 0,
					'return_format' => 'value',
				),
				array(
					'key' => 'field_5654856593c13',
					'label' => 'Drawer',
					'name' => 'drawer',
					'type' => 'textarea',
					'instructions' => 'Enter your HTML.',
					'required' => 1,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_565484a193c12',
								'operator' => '==',
								'value' => 'drawer',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '<div class="col-sm-12">
	<p class="text-center">This is where your drawer code goes.</p></div>',
					'placeholder' => '',
					'maxlength' => '',
					'rows' => '',
					'new_lines' => '',
					'readonly' => 0,
					'disabled' => 0,
				),
				array(
					'key' => 'field_56548cb693c14',
					'label' => 'Link',
					'name' => 'link',
					'type' => 'url',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_565484a193c12',
								'operator' => '==',
								'value' => 'link',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
				),
				array(
					'key' => 'field_56548ceb93c15',
					'label' => 'Link Destination',
					'name' => 'link_destination',
					'type' => 'radio',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_565484a193c12',
								'operator' => '==',
								'value' => 'link',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'_self' => 'Internal (Self)',
						'_blank' => 'External (Blank)',
					),
					'other_choice' => 0,
					'save_other_choice' => 0,
					'default_value' => '',
					'layout' => 'horizontal',
					'allow_null' => 0,
					'return_format' => 'value',
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-utilities',
			),
		),
	),
	'menu_order' => 20,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_57586ded459d9',
	'title' => 'Content Layout',
	'fields' => array(
		array(
			'key' => 'field_575876238b052',
			'label' => 'Layout: Content',
			'name' => 'main_content_content',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => '',
			'min' => 1,
			'max' => 1,
			'layout' => 'block',
			'button_label' => 'Add Row',
			'sub_fields' => array(
				array(
					'key' => 'field_57586e6d867a4',
					'label' => 'Content',
					'name' => 'content',
					'type' => 'select',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '20',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'fixed' => 'Fixed',
						'fluid' => 'Fluid',
					),
					'default_value' => array(
						0 => 'fixed',
					),
					'allow_null' => 1,
					'multiple' => 0,
					'ui' => 0,
					'ajax' => 0,
					'return_format' => 'value',
					'placeholder' => '',
				),
				array(
					'key' => 'field_576545abefdfb',
					'label' => 'Margin Top',
					'name' => 'margin_top',
					'type' => 'select',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '20',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						0 => 'Level 0 (0)',
						1 => 'Level 1 (0.178em)',
						2 => 'Level 2 (0.238em)',
						3 => 'Level 3 (0.317em)',
						4 => 'Level 4 (0.422em)',
						5 => 'Level 5 (0.563em)',
						6 => 'Level 6 (0.75em)',
						7 => 'Level 7 (1em)',
						8 => 'Level 8 (1.333em)',
						9 => 'Level 9 (1.777em)',
						10 => 'Level 10 (2.369em)',
						11 => 'Level 11 (3.157em)',
						12 => 'Level 12 (4.209em)',
						13 => 'Level 13 (5.61em)',
						14 => 'Level 14 (7.478em)',
						15 => 'Level 15 (9.969em)',
					),
					'default_value' => array(
						0 => 10,
					),
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'ajax' => 0,
					'return_format' => 'value',
					'placeholder' => '',
				),
				array(
					'key' => 'field_576c014b99902',
					'label' => 'Margin Bottom',
					'name' => 'margin_bottom',
					'type' => 'select',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '20',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						0 => 'Level 0 (0)',
						1 => 'Level 1 (0.178em)',
						2 => 'Level 2 (0.238em)',
						3 => 'Level 3 (0.317em)',
						4 => 'Level 4 (0.422em)',
						5 => 'Level 5 (0.563em)',
						6 => 'Level 6 (0.75em)',
						7 => 'Level 7 (1em)',
						8 => 'Level 8 (1.333em)',
						9 => 'Level 9 (1.777em)',
						10 => 'Level 10 (2.369em)',
						11 => 'Level 11 (3.157em)',
						12 => 'Level 12 (4.209em)',
						13 => 'Level 13 (5.61em)',
						14 => 'Level 14 (7.478em)',
						15 => 'Level 15 (9.969em)',
					),
					'default_value' => array(
						0 => 10,
					),
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'ajax' => 0,
					'return_format' => 'value',
					'placeholder' => '',
				),
				array(
					'key' => 'field_576ad4d1d76aa',
					'label' => 'Breadcrumbs',
					'name' => 'breadcrumbs',
					'type' => 'select',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '20',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'first' => 'With Navigation',
						'second' => 'With Content',
					),
					'default_value' => array(
						0 => 'second',
					),
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'ajax' => 0,
					'return_format' => 'value',
					'placeholder' => '',
				),
				array(
					'key' => 'field_59035a5aecc52',
					'label' => 'Hide Title',
					'name' => 'hide_title',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '20',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
			),
		),
		array(
			'key' => 'field_5765455defdf6',
			'label' => 'Layout: Sidebar',
			'name' => 'main_content_sidebar',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => '',
			'min' => 1,
			'max' => 1,
			'layout' => 'block',
			'button_label' => 'Add Row',
			'sub_fields' => array(
				array(
					'key' => 'field_5765455defdf7',
					'label' => 'Sidebar',
					'name' => 'sidebar',
					'type' => 'select',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '20',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'yes' => 'Yes',
						'no' => 'No (Wide)',
					),
					'default_value' => array(
						0 => 'yes',
					),
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'ajax' => 0,
					'return_format' => 'value',
					'placeholder' => '',
				),
				array(
					'key' => 'field_5765455defdf8',
					'label' => 'Location',
					'name' => 'location',
					'type' => 'select',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5765455defdf7',
								'operator' => '==',
								'value' => 'yes',
							),
						),
					),
					'wrapper' => array(
						'width' => 20,
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'left' => 'Left',
						'right' => 'Right',
					),
					'default_value' => array(
						0 => 'left',
					),
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'disabled' => 0,
					'readonly' => 0,
					'return_format' => 'value',
				),
				array(
					'key' => 'field_5765455defdf9',
					'label' => 'Columns',
					'name' => 'columns',
					'type' => 'select',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5765455defdf7',
								'operator' => '==',
								'value' => 'yes',
							),
						),
					),
					'wrapper' => array(
						'width' => '20',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						2 => '2',
						3 => '3',
						4 => '4',
						5 => '5',
						6 => '6',
					),
					'default_value' => array(
						0 => 3,
					),
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'ajax' => 0,
					'return_format' => 'value',
					'placeholder' => '',
				),
				array(
					'key' => 'field_5765455defdfa',
					'label' => 'Widget (Appearance > Widgets)',
					'name' => 'widget',
					'type' => 'select',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5765455defdf7',
								'operator' => '==',
								'value' => 'yes',
							),
						),
					),
					'wrapper' => array(
						'width' => '40',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'd' => 'Default',
						1 => 'One',
						2 => 'Two',
						3 => 'Three',
						4 => 'Four',
						5 => 'Five',
						6 => 'Six',
						7 => 'Seven',
						8 => 'Eight',
					),
					'default_value' => array(
						0 => 'd',
					),
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-1.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-2.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-3.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-4.php',
			),
		),
	),
	'menu_order' => 40,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_57717cea2e259',
	'title' => 'Post Meta',
	'fields' => array(
		array(
			'key' => 'field_57717cfb89f28',
			'label' => 'Featured Image Display',
			'name' => 'featured_image_display',
			'type' => 'radio',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'alignleft' => 'Left',
				'aligncenter' => 'Centered',
				'alignright' => 'Right',
				'none' => 'Do not display',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 'left',
			'layout' => 'horizontal',
			'return_format' => 'value',
		),
		array(
			'key' => 'field_57718be0d7c94',
			'label' => 'Featured Image Ratio',
			'name' => 'featured_image_ratio',
			'type' => 'radio',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57717cfb89f28',
						'operator' => '!=',
						'value' => 'none',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'1x1' => '1:1',
				'3x2' => '3:2',
				'16x9' => '16:9',
				'full' => 'Full Size',
			),
			'allow_null' => 0,
			'other_choice' => 0,
			'default_value' => '',
			'layout' => 'horizontal',
			'return_format' => 'value',
			'save_other_choice' => 0,
		),
		array(
			'key' => 'field_5772780c992e4',
			'label' => 'Authors',
			'name' => 'authors',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => '',
			'min' => 0,
			'max' => 0,
			'layout' => 'table',
			'button_label' => 'Add Author',
			'sub_fields' => array(
				array(
					'key' => 'field_577278b2ae152',
					'label' => 'Name',
					'name' => 'name',
					'type' => 'text',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
					'readonly' => 0,
					'disabled' => 0,
				),
				array(
					'key' => 'field_577278c3ae153',
					'label' => 'Email',
					'name' => 'email',
					'type' => 'email',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
	),
	'menu_order' => 45,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'left',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5672fd170aa51',
	'title' => 'Footer',
	'fields' => array(
		array(
			'key' => 'field_5673056506db1',
			'label' => 'Footer Columns',
			'name' => 'footer_columns',
			'type' => 'radio',
			'instructions' => '(Even divisions of 12.)',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				1 => 1,
				2 => 2,
				3 => 3,
				4 => 4,
				6 => 6,
			),
			'other_choice' => 0,
			'save_other_choice' => 0,
			'default_value' => 1,
			'layout' => 'horizontal',
			'allow_null' => 0,
			'return_format' => 'value',
		),
		array(
			'key' => 'field_5672fd27caf1d',
			'label' => 'Footer Sections',
			'name' => 'footer',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => '',
			'min' => 0,
			'max' => 0,
			'layout' => 'block',
			'button_label' => 'Add Footer Section',
			'sub_fields' => array(
				array(
					'key' => 'field_5673090bd6aac',
					'label' => 'Content Type',
					'name' => 'content_type',
					'type' => 'radio',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'code' => 'Code',
						'wysiwyg' => 'WYSIWYG',
					),
					'other_choice' => 0,
					'save_other_choice' => 0,
					'default_value' => '',
					'layout' => 'horizontal',
					'allow_null' => 0,
					'return_format' => 'value',
				),
				array(
					'key' => 'field_56730956d6aad',
					'label' => 'Code',
					'name' => 'code',
					'type' => 'textarea',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5673090bd6aac',
								'operator' => '==',
								'value' => 'code',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'maxlength' => '',
					'rows' => '',
					'new_lines' => '',
					'readonly' => 0,
					'disabled' => 0,
				),
				array(
					'key' => 'field_56730979d6aae',
					'label' => 'WYSIWYG',
					'name' => 'wysiwyg',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_5673090bd6aac',
								'operator' => '==',
								'value' => 'wysiwyg',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'tabs' => 'all',
					'toolbar' => 'full',
					'media_upload' => 1,
					'delay' => 0,
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-footer',
			),
		),
	),
	'menu_order' => 50,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

endif;



