<?php

if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_5767e26ce686b',
	'title' => 'Flexible Content (Below)',
	'fields' => array(
		array(
			'key' => 'field_5767e26d27404',
			'label' => 'Content Below Editor',
			'name' => 'content_below',
			'type' => 'flexible_content',
			'instructions' => 'This area appears after the main content of your site.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layouts' => array(
				'573b27f70af6c' => array(
					'key' => '573b27f70af6c',
					'name' => 'pattern_slider_1',
					'label' => 'Slider: Banner',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f02bba',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f02c95',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x1' => '3:1',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x1',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f02dde',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26d27404',
										'operator' => '!=empty',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f02f5e',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_577d455546495',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_577d455546495',
									'label' => 'Display',
									'name' => 'display',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => '',
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'image' => 'Image',
										'banner' => 'Banner',
									),
									'default_value' => array(
										0 => 'image',
										1 => 'banner',
									),
									'layout' => 'horizontal',
									'toggle' => 0,
									'allow_custom' => 0,
									'save_custom' => 0,
									'return_format' => 'value',
								),
								array(
									'key' => 'field_5767e26f18359',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d455546495',
												'operator' => '==',
												'value' => 'image',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_5767e26f1840c',
									'label' => 'Color',
									'name' => 'block_color',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d455546495',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'c' => 'Canvas',
										'w' => 'White',
										'gt' => 'Garnet',
										'gd' => 'Gold',
										'gd1c' => 'Gold + 1 Canvas',
										'gd2c' => 'Gold + 2 Canvas',
										'gd3c' => 'Gold + 3 Canvas',
										'n2w' => 'Neutral + 2 White',
										'n1w' => 'Neutral + 1 White',
										'n' => 'Neutral',
										'n2s' => 'Neutral + 2 Slate',
										's' => 'Slate',
										'k' => 'Black',
									),
									'default_value' => array(
										0 => 'c',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5767e26f184b8',
									'label' => 'Position',
									'name' => 'block_position',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d455546495',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'left' => 'Left',
										'right' => 'Right',
									),
									'default_value' => array(
										0 => 'left',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5767e26f18560',
									'label' => 'Design',
									'name' => 'embellishment',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d455546495',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'none' => 'None',
										'arrow' => 'Arrow',
										'point' => 'Point',
									),
									'default_value' => array(
										0 => 'none',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5767e26f185f3',
									'label' => 'Content Header',
									'name' => 'block_content_header',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d455546495',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_5767e26f1867e',
									'label' => 'Content Paragraph',
									'name' => 'block_content_paragraph',
									'type' => 'textarea',
									'instructions' => '* Does not show on smallest display.',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d455546495',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_5767e26f18709',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d455546495',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '10',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'ui' => 0,
									'ui_on_text' => '',
									'ui_off_text' => '',
								),
								array(
									'key' => 'field_5767e26f18793',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5767e26f18709',
												'operator' => '==',
												'value' => '1',
											),
											array(
												'field' => 'field_577d455546495',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_5767e26f1881d',
									'label' => 'Link Text',
									'name' => 'link_text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5767e26f18709',
												'operator' => '==',
												'value' => '1',
											),
											array(
												'field' => 'field_577d455546495',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'default_value' => 'Read More',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_5767e26f02ffd',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f03088',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5767e26f03151',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f03207',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bf92807826',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f032bd',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5343a16b3a',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'573ca7b7dc751' => array(
					'key' => '573ca7b7dc751',
					'name' => 'pattern_slider_3',
					'label' => 'Slider: Description Below Image',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f03940',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f039e4',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x1' => '3:1',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x1',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f03b83',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26d27404',
										'operator' => '!=empty',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f03a70',
							'label' => 'Block Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f03c98',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 2,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_5767e26f7111a',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_5767e26f711aa',
									'label' => 'Content Header',
									'name' => 'block_content_header',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_5767e26f71232',
									'label' => 'Content Paragraph',
									'name' => 'block_content_paragraph',
									'type' => 'textarea',
									'instructions' => '* Does not show on smallest display.',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_5767e26f71297',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '10',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'ui' => 0,
									'ui_on_text' => '',
									'ui_off_text' => '',
								),
								array(
									'key' => 'field_5767e26f7131f',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5767e26f71297',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_5767e26f713b7',
									'label' => 'Link Text',
									'name' => 'link_text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5767e26f71297',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'default_value' => 'Read More',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_5767e26f03d21',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f03dab',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5767e26f03e35',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f03ec9',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bf95307827',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f03f58',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5344416b3c',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'573cc254d9c29' => array(
					'key' => '573cc254d9c29',
					'name' => 'pattern_slider_4',
					'label' => 'Slider: Split',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f03fe8',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f04122',
							'label' => 'Columns',
							'name' => 'columns_3x2',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'4_8' => '(4 and 8) or (8 and 4)',
								'6_6' => '(6 and 6)',
							),
							'default_value' => array(
								0 => '4_8',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f04349',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26d27404',
										'operator' => '!=empty',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f043fd',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_5767e26f9b775',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_5767e26f9b80e',
									'label' => 'Color',
									'name' => 'block_color',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'c' => 'Canvas',
										'w' => 'White',
										'gt' => 'Garnet',
										'gd' => 'Gold',
										'gd1c' => 'Gold + 1 Canvas',
										'gd2c' => 'Gold + 2 Canvas',
										'gd3c' => 'Gold + 3 Canvas',
										'n2w' => 'Neutral + 2 White',
										'n1w' => 'Neutral + 1 White',
										'n' => 'Neutral',
										'n2s' => 'Neutral + 2 Slate',
										's' => 'Slate',
										'k' => 'Black',
									),
									'default_value' => array(
										0 => 'c',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5767e26f9b89a',
									'label' => 'Position',
									'name' => 'block_position',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'left' => 'Left',
										'right' => 'Right',
									),
									'default_value' => array(
										0 => 'left',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5767e26f9b926',
									'label' => 'Content Header',
									'name' => 'block_content_header',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_5767e26f9b9c4',
									'label' => 'Content Paragraph',
									'name' => 'block_content_paragraph',
									'type' => 'textarea',
									'instructions' => '* Does not show on smallest display.',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_5767e26f9ba66',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '10',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'ui' => 0,
									'ui_on_text' => '',
									'ui_off_text' => '',
								),
								array(
									'key' => 'field_5767e26f9bb20',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5767e26f9ba66',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_5767e26f9bbae',
									'label' => 'Link Text',
									'name' => 'link_text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5767e26f9ba66',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'default_value' => 'Read More',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_5767e26f044c6',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f0456e',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5767e26f04600',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f0469d',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bf96807828',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f0475a',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5344816b3d',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'574dbee3293d8' => array(
					'key' => '574dbee3293d8',
					'name' => 'pattern_slider_5',
					'label' => 'Slider: Split With Static Message',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f047e7',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f04974',
							'label' => 'Columns',
							'name' => 'columns_3x2',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'4_8' => '(4 and 8) or (8 and 4)',
								'6_6' => '(6 and 6)',
							),
							'default_value' => array(
								0 => '4_8',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f04b61',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f04bea',
							'label' => 'Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f04c78',
							'label' => 'Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f04d1a',
							'label' => 'Content',
							'name' => 'block_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<p class="h3 s3-fs-xs-4 text-center">Lorem Ipsum Dolor Sit Amet Consectetur Adipiscing Elit</p><hr class=" text-center" ><p class="h5 text-center"><a href="#">Read more <span class="fa fa-chevron-right"></span></a></p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_5767e26f04dd2',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_5767e26fcdda0',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
							),
						),
						array(
							'key' => 'field_5767e26f04e5c',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f04ee7',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5767e26f04f8c',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f05037',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bf97b07829',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f050c3',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5344c16b3e',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'574de4a4690f9' => array(
					'key' => '574de4a4690f9',
					'name' => 'pattern_slider_6',
					'label' => 'Slider: Carousel',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f0517a',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f0521d',
							'label' => 'Display Message?',
							'name' => 'message',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_5767e26f053ab',
							'label' => 'Message Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f0521d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f052e0',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f0521d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3_9' => '(3 and 9) or (9 and 3)',
								'4_8' => '(4 and 8) or (8 and 4)',
							),
							'default_value' => array(
								0 => '4_8',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f05457',
							'label' => 'Message Content',
							'name' => 'message_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f0521d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'basic',
							'media_upload' => 0,
							'delay' => 1,
						),
						array(
							'key' => 'field_5767e26f054e4',
							'label' => 'Show Images',
							'name' => 'image',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_5767e26f056c8',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26d27404',
										'operator' => '!=empty',
									),
								),
							),
							'wrapper' => array(
								'width' => '66',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 's',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f05767',
							'label' => 'Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f0581a',
							'label' => 'Banner Height',
							'name' => 'block_height',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'feature-fixed-1' => 'Large',
								'feature-fixed-2' => 'Medium',
								'feature-fixed-3' => 'Small',
							),
							'default_value' => array(
								0 => 'feature-fixed-2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f058df',
							'label' => 'Design',
							'name' => 'embellishment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'arrow' => 'Arrow',
								'point' => 'Point',
							),
							'default_value' => array(
								0 => 'arrow',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f0599e',
							'label' => 'Slides',
							'name' => 'slides',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'table',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_5767e27002e4c',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_5767e27002edc',
									'label' => 'Content',
									'name' => 'content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '66',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 0,
									'delay' => 0,
								),
							),
						),
						array(
							'key' => 'field_5767e26f05a4b',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f05af5',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5767e26f05bba',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f05c67',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bf9900782a',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f05cf3',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5345116b3f',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'573f663817335' => array(
					'key' => '573f663817335',
					'name' => 'pattern_feature_1',
					'label' => 'Feature: Background Cover with Banner',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f05da2',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f05eba',
							'label' => 'Image',
							'name' => 'image',
							'type' => 'image',
							'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 's3-md-16x9',
							'library' => 'all',
							'min_width' => 600,
							'min_height' => 300,
							'min_size' => '',
							'max_width' => 2400,
							'max_height' => 2400,
							'max_size' => '.4',
							'mime_types' => 'jpg, png, gif',
						),
						array(
							'key' => 'field_5767e26f05e2e',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '16x9',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f06332',
							'label' => 'Design',
							'name' => 'embellishment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'arrow' => 'Arrow',
								'point' => 'Point',
							),
							'default_value' => array(
								0 => 'none',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f05f5d',
							'label' => 'Banner Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f0600d',
							'label' => 'Banner Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f060ac',
							'label' => 'Banner Width',
							'name' => 'block_width',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f0600d',
										'operator' => '!=',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								4 => 'Four/Five Columns',
								5 => 'Five Columns',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f06173',
							'label' => 'Banner Width',
							'name' => 'block_width_center',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f0600d',
										'operator' => '==',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								4 => 'Four Columns',
								6 => 'Six Columns',
								8 => 'Eight Columns',
								10 => 'Ten Columns',
								12 => 'Twelve Columns',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f0624c',
							'label' => 'Banner Content',
							'name' => 'block_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<h3 class="s3-fs-sm-3">Patria feugait quis valetudo.</h3><p class="s3-fs-sm-1">Dolore regula pagus exerci minim bis quidne. Illum premo quidem dignissim melior exerci sed letatio in tum.</p><p class="h4 s3-fs-sm-2"><a href="#">Read More <span class="fa fa-chevron-right"></span></a></p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_5767e26f0640d',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f064c9',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5767e26f06561',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f06620',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bf9a30782b',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f066fb',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5345616b40',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57431f40dcbed' => array(
					'key' => '57431f40dcbed',
					'name' => 'pattern_feature_2',
					'label' => 'Feature: Background Cover',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f067c9',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f06953',
							'label' => 'Image',
							'name' => 'image',
							'type' => 'image',
							'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 's3-md-16x9',
							'library' => 'all',
							'min_width' => 600,
							'min_height' => 300,
							'min_size' => '',
							'max_width' => 2400,
							'max_height' => 2400,
							'max_size' => '.4',
							'mime_types' => 'jpg, png, gif',
						),
						array(
							'key' => 'field_5767e26f06889',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '16x9',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f06a23',
							'label' => 'Banner Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f06aca',
							'label' => 'Banner Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f06b59',
							'label' => 'Banner Width',
							'name' => 'block_width',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f06aca',
										'operator' => '!=',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								3 => 'Three Columns',
								4 => 'Four Columns',
								5 => 'Five Columns',
								6 => 'Six Columns',
							),
							'default_value' => array(
								0 => 3,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f06bfd',
							'label' => 'Banner Width',
							'name' => 'block_width_center',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f06aca',
										'operator' => '==',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								4 => 'Four Columns',
								6 => 'Six Columns',
								8 => 'Eight Columns',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f06cba',
							'label' => 'Banner Content',
							'name' => 'block_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<h3 class="s3-fs-sm-3">Patria feugait quis valetudo.</h3><p class="s3-fs-sm-1">Dolore regula pagus exerci minim bis quidne. Illum premo quidem dignissim melior exerci sed letatio in tum.</p><p class="h4 s3-fs-sm-2"><a href="#">Read More <span class="fa fa-chevron-right"></span></a></p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_5767e26f06d77',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f06e3b',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5767e26f06f34',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f06fcc',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bf9b80782c',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f0705e',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5345a16b41',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57435b0bf31f8' => array(
					'key' => '57435b0bf31f8',
					'name' => 'pattern_feature_3',
					'label' => 'Feature: Banners',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f07145',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f071d2',
							'label' => 'Banner Color Background',
							'name' => 'banner_color_background',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f0725c',
							'label' => 'Banner Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f072e6',
							'label' => 'Banner Height',
							'name' => 'block_height',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'feature-fixed-1' => 'Large',
								'feature-fixed-2' => 'Medium',
								'feature-fixed-3' => 'Small',
							),
							'default_value' => array(
								0 => 'feature-fixed-2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f07371',
							'label' => 'Design',
							'name' => 'embellishment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'arrow' => 'Arrow',
								'point' => 'Point',
							),
							'default_value' => array(
								0 => 'arrow',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f073fc',
							'label' => 'Block',
							'name' => 'block',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_57435bd2f3203',
							'min' => 2,
							'max' => 4,
							'layout' => 'block',
							'button_label' => 'Add Block Content',
							'sub_fields' => array(
								array(
									'key' => 'field_5767e27057bca',
									'label' => 'Block Content',
									'name' => 'block_content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '<h2>Patria feugait quis valetudo.</h2>Dolore regula pagus exerci minim bis quidne. Illum premo quidem dignissim melior exerci sed letatio in tum.<a class="btn btn-link btn-go s3-gd" href="#">Read More</a>',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 0,
									'delay' => 1,
								),
							),
						),
						array(
							'key' => 'field_5767e26f07487',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f07511',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5767e26f0759c',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f07626',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bf9cb0782d',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f076b0',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5345e16b42',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57444c75f9c06' => array(
					'key' => '57444c75f9c06',
					'name' => 'pattern_hero_1',
					'label' => 'Hero',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f0773b',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f077cd',
							'label' => 'Content Type',
							'name' => 'content_type',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'rails' => 'On Rails (Predefined Types)',
								'free' => 'Custom (WYSIWYG)',
							),
							'default_value' => array(
								0 => 'rails',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f0787c',
							'label' => 'Alignment',
							'name' => 'rails_alignment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f077cd',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Centered',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'center',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f07944',
							'label' => 'Content',
							'name' => 'content_rails',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f077cd',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '100',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_574456c12d406',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_5767e2706e3c8',
									'label' => 'Content',
									'name' => 'rails_type',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5767e26f077cd',
												'operator' => '==',
												'value' => 'rails',
											),
										),
									),
									'wrapper' => array(
										'width' => 20,
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'h1' => 'Heading 1 Style',
										'h2' => 'Heading 2 Style',
										'h3' => 'Heading 3 Style',
										'h4' => 'Heading 4 Style',
										'h5' => 'Heading 5 Style',
										'h6' => 'Heading 6 Style',
										'lead' => 'Lead Paragraph',
										'p' => 'Paragraph',
									),
									'default_value' => array(
										0 => 'h2',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'placeholder' => '',
									'disabled' => 0,
									'readonly' => 0,
									'return_format' => 'value',
								),
								array(
									'key' => 'field_5767e2706e46b',
									'label' => 'Content',
									'name' => 'rails_content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => 80,
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 3,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
							),
						),
						array(
							'key' => 'field_5767e26f079fd',
							'label' => 'Content',
							'name' => 'content_wysiwyg',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f077cd',
										'operator' => '==',
										'value' => 'free',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<h2>Commoveo te a neque amet paratus.</h2><p class="h5 text-uppercase">Commoveo te a neque amet paratus.</p><p class="lead">Feugait magna singularis iustum causa neo turpis plaga genitus. Ratis a sed a. Nutus melior in duis esse probo amet importunus eros macto wisi. Eum tation ad duis aliquam verto vel. Lucidus roto praesent plaga importunus dolor vulpes importunus lucidus.</p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_5767e26f07ab5',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f07b7d',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5767e26f07c1d',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f07cbb',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bf9e40782e',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f07d83',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5346316b43',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'575721126957b' => array(
					'key' => '575721126957b',
					'name' => 'background_divider_saw',
					'label' => 'Background Divider: Saw',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f07e45',
							'label' => 'Top DIV Color',
							'name' => 'saw_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'gd',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 1,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f07ecf',
							'label' => 'Bottom DIV Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 1,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f07f6b',
							'label' => 'Saw Size',
							'name' => 'size',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'xs' => 'X-Small',
								'sm' => 'Small',
								'md' => 'Medium',
								'lg' => 'Large',
							),
							'default_value' => array(
								0 => 'md',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'5746e81f0017b' => array(
					'key' => '5746e81f0017b',
					'name' => 'pattern_blocks_1',
					'label' => 'Block Content',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f08017',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f080d1',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => 'Note: Left-aligned square images will be set at two columns.',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								'2_2' => 'Two (Two on XS)',
								3 => 'Three',
								4 => 'Four',
								'4_2' => 'Four (Two on XS)',
								6 => 'Six',
								'6_2' => 'Six (Two on XS)',
							),
							'default_value' => array(
								0 => 1,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f0819b',
							'label' => 'Content Type',
							'name' => 'content_type',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'rails' => 'On Rails (Predefined Types)',
								'free' => 'Custom (WYSIWYG)',
								'code' => 'Custom (Code)',
							),
							'default_value' => array(
								0 => 'rails',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f08251',
							'label' => 'Alignment',
							'name' => 'rails_alignment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f0819b',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Centered',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f08308',
							'label' => 'Image',
							'name' => 'rails_image_available',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f0819b',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_5767e26f083c0',
							'label' => 'Image Ratio',
							'name' => 'rails_image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f08308',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'1x1' => 'Square',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f0846d',
							'label' => 'Image Effect',
							'name' => 'rails_image_effect',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f08308',
										'operator' => '==',
										'value' => '1',
									),
									array(
										'field' => 'field_5767e26f083c0',
										'operator' => '==',
										'value' => '1x1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'circle' => 'Circle',
								'thumbnail' => 'Thumbnail',
							),
							'default_value' => array(
								0 => 'none',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f08512',
							'label' => 'Header Style',
							'name' => 'rails_header_type',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f0819b',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'h3' => 'Heading 3 Style',
								'h4' => 'Heading 4 Style',
								'h5' => 'Heading 5 Style',
								'h6' => 'Heading 6 Style',
							),
							'default_value' => array(
								0 => 'h2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'disabled' => 0,
							'readonly' => 0,
							'return_format' => 'value',
						),
						array(
							'key' => 'field_5767e26f085ca',
							'label' => 'Content',
							'name' => 'content_rails',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f0819b',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_5767e27098edd',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_5767e27098e53',
									'label' => 'Image',
									'name' => 'rails_image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5767e26f08308',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_5767e27098d36',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'select',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										1 => 'Internal',
										2 => 'External',
										3 => 'No',
									),
									'default_value' => array(
										0 => 3,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5767e27098dc8',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5767e27098d36',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '80',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => array(
									),
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_59930eeb240fd',
									'label' => 'URL',
									'name' => 'url',
									'type' => 'url',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5767e27098d36',
												'operator' => '==',
												'value' => '2',
											),
										),
									),
									'wrapper' => array(
										'width' => '80',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5767e27098edd',
									'label' => 'Header',
									'name' => 'rails_header',
									'type' => 'textarea',
									'instructions' => '',
									'required' => '',
									'conditional_logic' => '',
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 2,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_5767e27098f69',
									'label' => 'Paragraph',
									'name' => 'rails_paragraph',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_57e58dc29f5ca',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_5767e26f08694',
							'label' => 'Content',
							'name' => 'content_wysiwyg',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f0819b',
										'operator' => '==',
										'value' => 'free',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_5767e270a7167',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_5767e270a7167',
									'label' => 'WYSIWYG Content',
									'name' => 'wysiwyg_content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '<h3>Sed Dignissim Lacinia</h3><p>Morbi in dui quis est pulvinar ullamcorper. Nulla facilisi integer lacinia sollicitudin massa.</p>',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 0,
									'delay' => 1,
								),
								array(
									'key' => 'field_57e58dd59f5cb',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class_wysiwyg',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_57ea96712f049',
							'label' => 'Content',
							'name' => 'content_code',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f0819b',
										'operator' => '==',
										'value' => 'code',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_57ea96712f04a',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_57ea96712f04a',
									'label' => 'Code Content',
									'name' => 'code_content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
								),
								array(
									'key' => 'field_57ea96712f04b',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class_code',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_5767e26f08759',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f08807',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5767e26f088c1',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f0897c',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bf9f90782f',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e5346916b44',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'5820f9d439a19' => array(
					'key' => '5820f9d439a19',
					'name' => 'pattern_content_2',
					'label' => 'Block Content: Custom',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5820f9d439a1a',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5820f9d439a1b',
							'label' => 'Content',
							'name' => 'content',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_5820f9e939a26',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content Block',
							'sub_fields' => array(
								array(
									'key' => 'field_5820f9e939a26',
									'label' => 'Type',
									'name' => 'type',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'column' => 'Column',
										'code' => 'Code',
										'break' => 'Break',
									),
									'default_value' => array(
										0 => 'column',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820fa3b39a27',
									'label' => 'Break',
									'name' => 'break',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f9e939a26',
												'operator' => '==',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '80',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'xs' => 'X-Small',
										'sm' => 'Small',
										'md' => 'Medium',
										'lg' => 'Large',
									),
									'default_value' => array(
										0 => 'xs',
										1 => 'sm',
										2 => 'md',
										3 => 'lg',
									),
									'layout' => 'horizontal',
									'toggle' => 0,
									'return_format' => 'value',
									'allow_custom' => 0,
									'save_custom' => 0,
								),
								array(
									'key' => 'field_5821d3084ad6f',
									'label' => 'X-Small',
									'name' => 'xs',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f9e939a26',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820faa039a29',
									'label' => 'Small',
									'name' => 'sm',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f9e939a26',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820faa739a2a',
									'label' => 'Medium',
									'name' => 'md',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f9e939a26',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820faae39a2b',
									'label' => 'Large',
									'name' => 'lg',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f9e939a26',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820fabf39a2c',
									'label' => 'Column',
									'name' => 'column',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f9e939a26',
												'operator' => '==',
												'value' => 'column',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 1,
									'delay' => 0,
								),
								array(
									'key' => 'field_5820fadc39a2d',
									'label' => 'Code',
									'name' => 'code',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f9e939a26',
												'operator' => '==',
												'value' => 'code',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
								),
								array(
									'key' => 'field_5820fb0339a2e',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f9e939a26',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_5820f9d439a20',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5820f9d439a21',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5820f9d439a22',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5820f9d439a23',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5820f9d439a24',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5820f9d439a25',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57570408c009f' => array(
					'key' => '57570408c009f',
					'name' => 'pattern_figures_2',
					'label' => 'Block Content: Image Blocks',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f0912c',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f091ef',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								3 => 'Three',
								4 => 'Four',
								6 => 'Six',
							),
							'default_value' => array(
								0 => 1,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f092af',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'1x1' => 'Square',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '16x9',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f09347',
							'label' => 'Blocks',
							'name' => 'blocks',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Block',
							'sub_fields' => array(
								array(
									'key' => 'field_5767e270e401c',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_5767e270e40ce',
									'label' => 'Text',
									'name' => 'text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
								array(
									'key' => 'field_58091832cb3db',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'post_type' => '',
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
							),
						),
						array(
							'key' => 'field_5767e26f093d1',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f09484',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5767e26f0950d',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f095b5',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bfa3a07831',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e5347316b46',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'58d2b5f8f874e' => array(
					'key' => '58d2b5f8f874e',
					'name' => 'pattern_content_3',
					'label' => 'Block Content: Image List',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_58d2b5f8f874f',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_58d2b633f8760',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'2_10' => '2 and 10',
								'3_9' => '3 and 9',
								'4_8' => '4 and 8',
							),
							'default_value' => array(
								0 => '2_10',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
						array(
							'key' => 'field_58d2b5f8f8750',
							'label' => 'Content',
							'name' => 'content',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_58d2b683f8763',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content Block',
							'sub_fields' => array(
								array(
									'key' => 'field_58d2b671f8761',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 'medium',
									'library' => 'all',
									'min_width' => '',
									'min_height' => '',
									'min_size' => '',
									'max_width' => '',
									'max_height' => '',
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_58d2b679f8762',
									'label' => 'Image Caption',
									'name' => 'image_caption',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
								array(
									'key' => 'field_58d2b683f8763',
									'label' => 'Content',
									'name' => 'content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'full',
									'media_upload' => 0,
									'delay' => 0,
								),
							),
						),
						array(
							'key' => 'field_58d2b5f8f875a',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_58d2b5f8f875b',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_58d2b5f8f875c',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_58d2b5f8f875d',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_58d2b5f8f875e',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_58d2b5f8f875f',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'5750829d77e7d' => array(
					'key' => '5750829d77e7d',
					'name' => 'pattern_figures_1',
					'label' => 'Figures',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f08a38',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f08af9',
							'label' => 'Figure or Gallery',
							'name' => 'figure_or_gallery',
							'type' => 'select',
							'instructions' => 'Galleries should be for three or more images.',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'figure' => 'Figure',
								'gallery' => 'Gallery',
							),
							'default_value' => array(
								0 => 'figure',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f08b9e',
							'label' => 'Figures',
							'name' => 'figures',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f08af9',
										'operator' => '==',
										'value' => 'figure',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 2,
							'layout' => 'block',
							'button_label' => 'Add Figure',
							'sub_fields' => array(
								array(
									'key' => 'field_5767e270b9289',
									'label' => 'Ratio',
									'name' => 'ratio',
									'type' => 'select',
									'instructions' => 1,
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1x1' => 'Square',
										'3x2' => '3:2',
										'16x9' => '16:9',
									),
									'default_value' => array(
										0 => '3:2',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5767e270b9340',
									'label' => 'Caption?',
									'name' => 'caption',
									'type' => 'select',
									'instructions' => 'Caption',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'none' => 'None',
										'below' => 'Below',
										'right' => 'Right',
									),
									'default_value' => array(
										0 => 'none',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5767e270b91c5',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_5767e270b93e5',
									'label' => 'Caption Content',
									'name' => 'content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5767e270b9340',
												'operator' => '!=',
												'value' => 'none',
											),
										),
									),
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 3,
									'new_lines' => 'br',
								),
							),
						),
						array(
							'key' => 'field_5767e26f08c44',
							'label' => 'Columns',
							'name' => 'columns_gallery',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f08af9',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								3 => 'Three',
								4 => 'Four',
								6 => 'Six',
							),
							'default_value' => array(
								0 => 1,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f08d00',
							'label' => 'Caption Position',
							'name' => 'caption_gallery',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f08af9',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Center',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f08dc2',
							'label' => 'Gallery',
							'name' => 'gallery',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5767e26f08af9',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Gallery Image',
							'sub_fields' => array(
								array(
									'key' => 'field_5767e270cad70',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '35',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_5767e270cae02',
									'label' => 'Ratio',
									'name' => 'ratio',
									'type' => 'select',
									'instructions' => 1,
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '15',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1x1' => 'Square',
										'3x2' => '3:2',
										'16x9' => '16:9',
									),
									'default_value' => array(
										0 => '3:2',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5767e270cae8e',
									'label' => 'Caption Content',
									'name' => 'content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => 35,
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 3,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
							),
						),
						array(
							'key' => 'field_5767e26f08e4c',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f08ed6',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5767e26f08f5f',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f08fe9',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bfa0e07830',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e5346e16b45',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'579255a26b14d' => array(
					'key' => '579255a26b14d',
					'name' => 'pattern_media_1',
					'label' => 'Media',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_579255a26b14e',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_579255a26b14f',
							'label' => 'Show Media Descriptions?',
							'name' => 'media',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_579255d56b159',
							'label' => 'Media Description Before',
							'name' => 'media_description_before',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_579255a26b14f',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 0,
							'delay' => 1,
						),
						array(
							'key' => 'field_579255fa6b15a',
							'label' => 'Media Description After',
							'name' => 'media_description_after',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_579255a26b14f',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 0,
							'delay' => 1,
						),
						array(
							'key' => 'field_579256156b15b',
							'label' => 'Media Type',
							'name' => 'media_type',
							'type' => 'radio',
							'instructions' => 'Select a type of content you wish to add. Media will fill the width of the container.',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'youtube' => 'YouTube ID',
								'soundcloud' => 'SoundCloud ID',
								'gallery' => 'Gallery',
								'embed' => 'Embed Code',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'save_other_choice' => 0,
							'default_value' => '',
							'layout' => 'horizontal',
							'return_format' => 'value',
						),
						array(
							'key' => 'field_579256486b15c',
							'label' => 'YouTube ID',
							'name' => 'youtube_id',
							'type' => 'text',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_579256156b15b',
										'operator' => '==',
										'value' => 'youtube',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
							'readonly' => 0,
							'disabled' => 0,
						),
						array(
							'key' => 'field_579256ae6b15d',
							'label' => 'SoundCloud ID',
							'name' => 'soundcloud_id',
							'type' => 'text',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_579256156b15b',
										'operator' => '==',
										'value' => 'soundcloud',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
							'readonly' => 0,
							'disabled' => 0,
						),
						array(
							'key' => 'field_579256c36b15e',
							'label' => 'Gallery Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_579256156b15b',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'1x1' => 'Square',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_579256e56b15f',
							'label' => 'Gallery Columns',
							'name' => 'gallery_columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_579256156b15b',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								3 => 'Three',
								4 => 'Four',
								6 => 'Six',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_579257046b160',
							'label' => 'Gallery Captions',
							'name' => 'gallery_captions',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_579256156b15b',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'No Captions',
								'left' => 'Left',
								'center' => 'Center',
							),
							'default_value' => array(
								0 => 'none',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5792571b6b161',
							'label' => 'Gallery Images',
							'name' => 'gallery_images',
							'type' => 'gallery',
							'instructions' => 'Note: Gallery thumbnails will be linked to the original uploaded file. Please be mindful of your file sizes.',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_579256156b15b',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 's3-md-16x9',
							'insert' => 'append',
							'library' => 'all',
							'min' => '',
							'max' => '',
							'min_width' => 600,
							'min_height' => 600,
							'min_size' => '',
							'max_width' => 2400,
							'max_height' => 2400,
							'max_size' => '',
							'mime_types' => '',
						),
						array(
							'key' => 'field_579257336b162',
							'label' => 'Embed Code',
							'name' => 'embed_code',
							'type' => 'textarea',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_579256156b15b',
										'operator' => '==',
										'value' => 'embed',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'maxlength' => '',
							'rows' => '',
							'new_lines' => '',
							'readonly' => 0,
							'disabled' => 0,
						),
						array(
							'key' => 'field_579255a26b154',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_579257e26b164',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'vertical',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_579255a26b156',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_579255a26b157',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_579255a26b158',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e5347916b47',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'574da56c3e3ac' => array(
					'key' => '574da56c3e3ac',
					'name' => 'pattern_content_1',
					'label' => 'Normal Content',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f09660',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f096f4',
							'label' => 'Content',
							'name' => 'content',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content Block',
							'sub_fields' => array(
								array(
									'key' => 'field_5767e27102c0a',
									'label' => 'Columns',
									'name' => 'columns',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										1 => 'One',
										2 => 'Two',
									),
									'default_value' => array(
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5767e27102c99',
									'label' => 'Split',
									'name' => 'split',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5767e27102c0a',
												'operator' => '==',
												'value' => '2',
											),
										),
									),
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1_11' => '1 and 11',
										'2_10' => '2 and 10',
										'3_9' => '3 and 9',
										'4_8' => '4 and 8',
										'5_7' => '5 and 7',
										'6_6' => '6 and 6',
										'7_5' => '7 and 5',
										'8_4' => '8 and 4',
										'9_3' => '9 and 3',
										'10_2' => '10 and 2',
										'11_1' => '11 and 1',
									),
									'default_value' => array(
										0 => '6_6',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5767e27102cfb',
									'label' => 'Content',
									'name' => 'content_1',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'full',
									'media_upload' => 1,
									'delay' => 0,
								),
								array(
									'key' => 'field_5767e27102d82',
									'label' => 'Content',
									'name' => 'content_2',
									'type' => 'wysiwyg',
									'instructions' => 'Less content than the first.',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5767e27102c0a',
												'operator' => '==',
												'value' => '2',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 1,
									'delay' => 0,
								),
							),
						),
						array(
							'key' => 'field_5767e26f097b0',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5767e26f09867',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5767e26f0991c',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5767e26f099a6',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576bfa5107832',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e5347e16b48',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57619e1bcff82' => array(
					'key' => '57619e1bcff82',
					'name' => 'reusable_content',
					'label' => 'Reusable Content',
					'display' => 'table',
					'sub_fields' => array(
						array(
							'key' => 'field_5767e26f09a2f',
							'label' => 'Reusable Content ID',
							'name' => 'reusable_content_id',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
							'readonly' => 0,
							'disabled' => 0,
						),
					),
					'min' => '',
					'max' => '',
				),
			),
			'button_label' => 'Add Content Container Block',
			'min' => '',
			'max' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-1.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-2.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-3.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-4.php',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
	),
	'menu_order' => 90,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

endif;



