<?php

if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_573b27e1dc2ef',
	'title' => 'Flexible Content (Above)',
	'fields' => array(
		array(
			'key' => 'field_573b27ef289a1',
			'label' => 'Content Above Editor',
			'name' => 'content_above',
			'type' => 'flexible_content',
			'instructions' => 'This area appears before the main content of your site.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layouts' => array(
				'573b27f70af6c' => array(
					'key' => '573b27f70af6c',
					'name' => 'pattern_slider_1',
					'label' => 'Slider: Banner',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_574f32fecc53e',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_573b37b9372d1',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x1' => '3:1',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x1',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573f50411defc',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573b2d4a289a2',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_577d4580ca635',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_577d4580ca635',
									'label' => 'Display',
									'name' => 'display',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => '',
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'image' => 'Image',
										'banner' => 'Banner',
									),
									'default_value' => array(
										0 => 'image',
										1 => 'banner',
									),
									'layout' => 'horizontal',
									'toggle' => 0,
									'allow_custom' => 0,
									'save_custom' => 0,
									'return_format' => 'value',
								),
								array(
									'key' => 'field_573b2edb289a3',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d4580ca635',
												'operator' => '==',
												'value' => 'image',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_573b30ff289a5',
									'label' => 'Color',
									'name' => 'block_color',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d4580ca635',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'c' => 'Canvas',
										'w' => 'White',
										'gt' => 'Garnet',
										'gd' => 'Gold',
										'gd1c' => 'Gold + 1 Canvas',
										'gd2c' => 'Gold + 2 Canvas',
										'gd3c' => 'Gold + 3 Canvas',
										'n2w' => 'Neutral + 2 White',
										'n1w' => 'Neutral + 1 White',
										'n' => 'Neutral',
										'n2s' => 'Neutral + 2 Slate',
										's' => 'Slate',
										'k' => 'Black',
									),
									'default_value' => array(
										0 => 'c',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_573b74151d3fb',
									'label' => 'Position',
									'name' => 'block_position',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d4580ca635',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'left' => 'Left',
										'right' => 'Right',
									),
									'default_value' => array(
										0 => 'left',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_573b3267289a7',
									'label' => 'Design',
									'name' => 'embellishment',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d4580ca635',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'none' => 'None',
										'arrow' => 'Arrow',
										'point' => 'Point',
									),
									'default_value' => array(
										0 => 'none',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_573b322c289a6',
									'label' => 'Content Header',
									'name' => 'block_content_header',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d4580ca635',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_573c84b9bde5c',
									'label' => 'Content Paragraph',
									'name' => 'block_content_paragraph',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d4580ca635',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
								),
								array(
									'key' => 'field_573c7ca8f5b6e',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_577d4580ca635',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '10',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'ui' => 0,
									'ui_on_text' => '',
									'ui_off_text' => '',
								),
								array(
									'key' => 'field_573b3070289a4',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_573c7ca8f5b6e',
												'operator' => '==',
												'value' => '1',
											),
											array(
												'field' => 'field_577d4580ca635',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_573c7cd9b4759',
									'label' => 'Link Text',
									'name' => 'link_text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_573c7ca8f5b6e',
												'operator' => '==',
												'value' => '1',
											),
											array(
												'field' => 'field_577d4580ca635',
												'operator' => '==',
												'value' => 'banner',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'default_value' => 'Read More',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_574f3312cc53f',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57459e7b4f863',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_574899ad2a15f',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57459e2e4f860',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be0c34f4dc',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574dbee4293dc',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e53108e595d',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'573ca7b7dc751' => array(
					'key' => '573ca7b7dc751',
					'name' => 'pattern_slider_3',
					'label' => 'Slider: Description Below Image',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_574f35308f429',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_573ca7b7dc752',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x1' => '3:1',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x1',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573f597941071',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573cb2ed8d802',
							'label' => 'Block Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573ca7b7dc753',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_573ca7b7dc754',
							'min' => 2,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_573ca7b7dc754',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_573ca7b7dc755',
									'label' => 'Content Header',
									'name' => 'block_content_header',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_573ca7b7dc756',
									'label' => 'Content Paragraph',
									'name' => 'block_content_paragraph',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
								),
								array(
									'key' => 'field_573ca7b7dc757',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '10',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'ui' => 0,
									'ui_on_text' => '',
									'ui_off_text' => '',
								),
								array(
									'key' => 'field_573ca7b7dc758',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_573ca7b7dc757',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_573ca7b7dc75a',
									'label' => 'Link Text',
									'name' => 'link_text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_573ca7b7dc757',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'default_value' => 'Read More',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_574f353e8f42a',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57459d9da7d4b',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_574899e82a161',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57459dada7d4c',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be0f74f4de',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57459dbda7d4d',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e53112e595f',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'573cc254d9c29' => array(
					'key' => '573cc254d9c29',
					'name' => 'pattern_slider_4',
					'label' => 'Slider: Split',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_574f356f8f42b',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_573f02d6de394',
							'label' => 'Columns',
							'name' => 'columns_3x2',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_573b27ef289a1',
										'operator' => '!=empty',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'4_8' => '(4 and 8) or (8 and 4)',
								'6_6' => '(6 and 6)',
							),
							'default_value' => array(
								0 => '4_8',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573f5a263aab1',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573cc254d9c2b',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_573cc254d9c2c',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_573cc254d9c2c',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_573cc254d9c2d',
									'label' => 'Color',
									'name' => 'block_color',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'c' => 'Canvas',
										'w' => 'White',
										'gt' => 'Garnet',
										'gd' => 'Gold',
										'gd1c' => 'Gold + 1 Canvas',
										'gd2c' => 'Gold + 2 Canvas',
										'gd3c' => 'Gold + 3 Canvas',
										'n2w' => 'Neutral + 2 White',
										'n1w' => 'Neutral + 1 White',
										'n' => 'Neutral',
										'n2s' => 'Neutral + 2 Slate',
										's' => 'Slate',
										'k' => 'Black',
									),
									'default_value' => array(
										0 => 'c',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_573cc254d9c2e',
									'label' => 'Position',
									'name' => 'block_position',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'left' => 'Left',
										'right' => 'Right',
									),
									'default_value' => array(
										0 => 'left',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_573cc254d9c30',
									'label' => 'Content Header',
									'name' => 'block_content_header',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_573cc254d9c31',
									'label' => 'Content Paragraph',
									'name' => 'block_content_paragraph',
									'type' => 'textarea',
									'instructions' => '* Does not show on smallest display.',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_573cc254d9c32',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '10',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'ui' => 0,
									'ui_on_text' => '',
									'ui_off_text' => '',
								),
								array(
									'key' => 'field_573cc254d9c33',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_573cc254d9c32',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_573cc254d9c34',
									'label' => 'Link Text',
									'name' => 'link_text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_573cc254d9c32',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '45',
										'class' => '',
										'id' => '',
									),
									'default_value' => 'Read More',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_574f357c8f42c',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57459cbdd34e2',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_574899922a15e',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57459d65a7d49',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be1134f4df',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5745e4f1eb52c',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e53118e5960',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'574dbee3293d8' => array(
					'key' => '574dbee3293d8',
					'name' => 'pattern_slider_5',
					'label' => 'Slider: Split With Static Message',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_574f35b08f42d',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_574dbee4293de',
							'label' => 'Columns',
							'name' => 'columns_3x2',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'4_8' => '(4 and 8) or (8 and 4)',
								'6_6' => '(6 and 6)',
							),
							'default_value' => array(
								0 => '4_8',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574dbee4293e1',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574dbee4293e4',
							'label' => 'Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574dbee4293e5',
							'label' => 'Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574dbee4293e6',
							'label' => 'Content',
							'name' => 'block_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<p class="h3 s3-fs-xs-4 text-center">Lorem Ipsum Dolor Sit Amet Consectetur Adipiscing Elit</p><hr class=" text-center" ><p class="text-center"><a class="btn btn-link btn-go" href="#">Read more </a></p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_574dbee4293e2',
							'label' => 'Slides',
							'name' => 'slide',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_574dbee4293e3',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
							),
						),
						array(
							'key' => 'field_574f35c08f42e',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_574dbee4293d9',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_574dbee4293da',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574dbee4293db',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be12e4f4e0',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57459e9d4f865',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5311de5961',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'574de4a4690f9' => array(
					'key' => '574de4a4690f9',
					'name' => 'pattern_slider_6',
					'label' => 'Slider: Carousel',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_574f342bcc542',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_574de5c76910b',
							'label' => 'Display Message?',
							'name' => 'message',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_574de4a469104',
							'label' => 'Message Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_574de5c76910b',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574de4a469100',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_574de5c76910b',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3_9' => '(3 and 9) or (9 and 3)',
								'4_8' => '(4 and 8) or (8 and 4)',
							),
							'default_value' => array(
								0 => '4_8',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574de59f6910a',
							'label' => 'Message Content',
							'name' => 'message_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_574de5c76910b',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'basic',
							'media_upload' => 0,
							'delay' => 1,
						),
						array(
							'key' => 'field_574de54869109',
							'label' => 'Show Images',
							'name' => 'image',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_574de4a469102',
							'label' => 'Arrow Color',
							'name' => 'arrow_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '66',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'White',
								's' => 'Slate',
							),
							'default_value' => array(
								0 => 's',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574de4a469103',
							'label' => 'Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574dedc5d1b9e',
							'label' => 'Banner Height',
							'name' => 'block_height',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'feature-fixed-1' => 'Large',
								'feature-fixed-2' => 'Medium',
								'feature-fixed-3' => 'Small',
							),
							'default_value' => array(
								0 => 'feature-fixed-2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574de6f06910c',
							'label' => 'Design',
							'name' => 'embellishment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'arrow' => 'Arrow',
								'point' => 'Point',
							),
							'default_value' => array(
								0 => 'arrow',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574de4a469106',
							'label' => 'Slides',
							'name' => 'slides',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'table',
							'button_label' => 'Add Slide',
							'sub_fields' => array(
								array(
									'key' => 'field_574de4a469107',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '.4',
									'mime_types' => 'jpg, png, gif',
								),
								array(
									'key' => 'field_574de51a69108',
									'label' => 'Content',
									'name' => 'content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '33',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 0,
									'delay' => 1,
								),
							),
						),
						array(
							'key' => 'field_574f343fcc543',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_574de4a4690fa',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_574de4a4690fb',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574de4a4690fc',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be1464f4e1',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574de4a4690fd',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e53122e5962',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'573f663817335' => array(
					'key' => '573f663817335',
					'name' => 'pattern_feature_1',
					'label' => 'Feature: Background Cover with Banner',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_574f336acc540',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_573f66381733b',
							'label' => 'Image',
							'name' => 'image',
							'type' => 'image',
							'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 's3-md-16x9',
							'library' => 'all',
							'min_width' => 600,
							'min_height' => 300,
							'min_size' => '',
							'max_width' => 2400,
							'max_height' => 2400,
							'max_size' => '.4',
							'mime_types' => 'jpg, png, gif',
						),
						array(
							'key' => 'field_573f663817336',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '16x9',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573f66381733e',
							'label' => 'Design',
							'name' => 'embellishment',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'arrow' => 'Arrow',
								'point' => 'Point',
							),
							'default_value' => array(
								0 => 'none',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573f66381733c',
							'label' => 'Banner Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573f66381733d',
							'label' => 'Banner Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573f681a17344',
							'label' => 'Banner Width',
							'name' => 'block_width',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_573f66381733d',
										'operator' => '!=',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								4 => 'Four/Five Columns',
								5 => 'Five Columns',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573f77461d29a',
							'label' => 'Banner Width',
							'name' => 'block_width_center',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_573f66381733d',
										'operator' => '==',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								4 => 'Four Columns',
								6 => 'Six Columns',
								8 => 'Eight Columns',
								10 => 'Ten Columns',
								12 => 'Twelve Columns',
							),
							'default_value' => array(
								0 => 'Four Columns',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573f66381733f',
							'label' => 'Banner Content',
							'name' => 'block_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<h3 class="s3-fs-sm-3">Patria feugait quis valetudo.</h3><p class="s3-fs-sm-1">Dolore regula pagus exerci minim bis quidne. Illum premo quidem dignissim melior exerci sed letatio in tum.</p><p class="h4 s3-fs-sm-2"><a href="#">Read More <span class="fa fa-chevron-right"></span></a></p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_574f3381cc541',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57459d46a7d48',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_574899722a15d',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57459d07d34e3',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be15d4f4e2',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_573f7040b28ef',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e53128e5963',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57431f40dcbed' => array(
					'key' => '57431f40dcbed',
					'name' => 'pattern_feature_2',
					'label' => 'Feature: Background Cover',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_574f3229716ec',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57431f40dcbef',
							'label' => 'Image',
							'name' => 'image',
							'type' => 'image',
							'instructions' => '600x300 Min | 2400x2400 Max; JPG@50-70% Compression; (Target: < 250K)',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 's3-md-16x9',
							'library' => 'all',
							'min_width' => 600,
							'min_height' => 300,
							'min_size' => '',
							'max_width' => 2400,
							'max_height' => 2400,
							'max_size' => '.4',
							'mime_types' => 'jpg, png, gif',
						),
						array(
							'key' => 'field_57431f40dcbee',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '16x9',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57431f40dcbf0',
							'label' => 'Banner Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57431f40dcbf1',
							'label' => 'Banner Position',
							'name' => 'block_position',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Center',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57431f40dcbf2',
							'label' => 'Banner Width',
							'name' => 'block_width',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57431f40dcbf1',
										'operator' => '!=',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								3 => 'Three Columns',
								4 => 'Four Columns',
								5 => 'Five Columns',
								6 => 'Six Columns',
							),
							'default_value' => array(
								0 => 3,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57431f40dcbf3',
							'label' => 'Banner Width',
							'name' => 'block_width_center',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57431f40dcbf1',
										'operator' => '==',
										'value' => 'center',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								4 => 'Four Columns',
								6 => 'Six Columns',
								8 => 'Eight Columns',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57431f40dcbf4',
							'label' => 'Banner Content',
							'name' => 'block_content',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<h3 class="s3-fs-sm-3">Patria feugait quis valetudo.</h3><p class="s3-fs-sm-1">Dolore regula pagus exerci minim bis quidne. Illum premo quidem dignissim melior exerci sed letatio in tum.</p><p class="h4 s3-fs-sm-2"><a href="#">Read More <span class="fa fa-chevron-right"></span></a></p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_574f3238716ed',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57459c71d34e0',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_574899512a15c',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57459c92d34e1',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be1734f4e3',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57431f40dcbf6',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5312de5964',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57435b0bf31f8' => array(
					'key' => '57435b0bf31f8',
					'name' => 'pattern_feature_3',
					'label' => 'Feature: Banners',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_574f31f9716ea',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57435dd29ea10',
							'label' => 'Banner Color Background',
							'name' => 'banner_color_background',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57435b0bf31fb',
							'label' => 'Banner Color',
							'name' => 'block_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'c',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5745f840bdb5d',
							'label' => 'Banner Height',
							'name' => 'block_height',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'feature-fixed-1' => 'Large',
								'feature-fixed-2' => 'Medium',
								'feature-fixed-3' => 'Small',
							),
							'default_value' => array(
								0 => 'feature-fixed-2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57435b42f3201',
							'label' => 'Design',
							'name' => 'embellishment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'arrow' => 'Arrow',
								'point' => 'Point',
							),
							'default_value' => array(
								0 => 'arrow',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57435b97f3202',
							'label' => 'Block',
							'name' => 'block',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_57435bd2f3203',
							'min' => 2,
							'max' => 4,
							'layout' => 'block',
							'button_label' => 'Add Block Content',
							'sub_fields' => array(
								array(
									'key' => 'field_57435bd2f3203',
									'label' => 'Block Content',
									'name' => 'block_content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '<h3 class="s3-fs-sm-3">Patria feugait quis valetudo.</h3><p class="s3-fs-sm-1">Dolore regula pagus exerci minim bis quidne. Illum premo quidem dignissim melior exerci sed letatio in tum.</p><p class="h4 s3-fs-sm-2"><a href="#">Read More <span class="fa fa-chevron-right"></span></a></p>',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 0,
									'delay' => 1,
								),
							),
						),
						array(
							'key' => 'field_574f320a716eb',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57459a3988942',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_574899292a15b',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57459a4c88943',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be1894f4e4',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57435b0bf3200',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e53132e5965',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57444c75f9c06' => array(
					'key' => '57444c75f9c06',
					'name' => 'pattern_hero_1',
					'label' => 'Hero',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_574f31a8716e8',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57444cd9f9c08',
							'label' => 'Content Type',
							'name' => 'content_type',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'rails' => 'On Rails (Predefined Types)',
								'free' => 'Custom (WYSIWYG)',
							),
							'default_value' => array(
								0 => 'rails',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574456892d405',
							'label' => 'Alignment',
							'name' => 'rails_alignment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57444cd9f9c08',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Centered',
								'right' => 'Right',
							),
							'default_value' => array(
								0 => 'center',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5744533c62153',
							'label' => 'Content',
							'name' => 'content_rails',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57444cd9f9c08',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '100',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_574456c12d406',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_5744535562154',
									'label' => 'Content',
									'name' => 'rails_type',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_57444cd9f9c08',
												'operator' => '==',
												'value' => 'rails',
											),
										),
									),
									'wrapper' => array(
										'width' => 20,
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'h1' => 'Heading 1 Style',
										'h2' => 'Heading 2 Style',
										'h3' => 'Heading 3 Style',
										'h4' => 'Heading 4 Style',
										'h5' => 'Heading 5 Style',
										'h6' => 'Heading 6 Style',
										'lead' => 'Lead Paragraph',
										'p' => 'Paragraph',
									),
									'default_value' => array(
										0 => 'h2',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'placeholder' => '',
									'disabled' => 0,
									'readonly' => 0,
									'return_format' => 'value',
								),
								array(
									'key' => 'field_574456c12d406',
									'label' => 'Content',
									'name' => 'rails_content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => 80,
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 3,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
							),
						),
						array(
							'key' => 'field_574457022d407',
							'label' => 'Content',
							'name' => 'content_wysiwyg',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_57444cd9f9c08',
										'operator' => '==',
										'value' => 'free',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '<h2>Commoveo te a neque amet paratus.</h2><p class="h5 text-uppercase">Commoveo te a neque amet paratus.</p><p class="lead">Feugait magna singularis iustum causa neo turpis plaga genitus. Ratis a sed a. Nutus melior in duis esse probo amet importunus eros macto wisi. Eum tation ad duis aliquam verto vel. Lucidus roto praesent plaga importunus dolor vulpes importunus lucidus.</p>',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 1,
							'delay' => 1,
						),
						array(
							'key' => 'field_574f31b8716e9',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5744b579e8bf2',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_57444cb1f9c07',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5744b71baa8ab',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be19d4f4e5',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574470cbd7e47',
							'label' => 'Wider Feature?',
							'name' => 'wider_feature',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '20',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_57e5313be5966',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '80',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'575721126957b' => array(
					'key' => '575721126957b',
					'name' => 'background_divider_saw',
					'label' => 'Background Divider: Saw',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_575721ab6957f',
							'label' => 'Top DIV Color',
							'name' => 'saw_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 'gd',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 1,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
						array(
							'key' => 'field_575721846957e',
							'label' => 'Bottom DIV Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 1,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
						array(
							'key' => 'field_5757213b6957c',
							'label' => 'Saw Size',
							'name' => 'size',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'xs' => 'X-Small',
								'sm' => 'Small',
								'md' => 'Medium',
								'lg' => 'Large',
							),
							'default_value' => array(
								0 => 'md',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'5746e81f0017b' => array(
					'key' => '5746e81f0017b',
					'name' => 'pattern_blocks_1',
					'label' => 'Block Content',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_574efa62a3b34',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5746e81f00180',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => 'Note: Left-aligned square images will be set at two columns.',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								'2_2' => 'Two (Two on XS)',
								3 => 'Three',
								4 => 'Four',
								'4_2' => 'Four (Two on XS)',
								6 => 'Six',
								'6_2' => 'Six (Two on XS)',
							),
							'default_value' => array(
								0 => 1,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5746e81f00181',
							'label' => 'Content Type',
							'name' => 'content_type',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'rails' => 'On Rails (Predefined Types)',
								'free' => 'Custom (WYSIWYG)',
								'code' => 'Custom (Code)',
							),
							'default_value' => array(
								0 => 'rails',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5746e81f00182',
							'label' => 'Alignment',
							'name' => 'rails_alignment',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5746e81f00181',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Centered',
							),
							'default_value' => array(
								0 => 'center',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5746e8d300188',
							'label' => 'Image',
							'name' => 'rails_image_available',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5746e81f00181',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_574703e65292f',
							'label' => 'Image Ratio',
							'name' => 'rails_image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5746e8d300188',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'1x1' => 'Square',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574dd06817f22',
							'label' => 'Image Effect',
							'name' => 'rails_image_effect',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5746e8d300188',
										'operator' => '==',
										'value' => '1',
									),
									array(
										'field' => 'field_574703e65292f',
										'operator' => '==',
										'value' => '1x1',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'circle' => 'Circle',
								'thumbnail' => 'Thumbnail',
							),
							'default_value' => array(
								0 => 'none',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5746e81f00184',
							'label' => 'Header Style',
							'name' => 'rails_header_type',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5746e81f00181',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'h3' => 'Heading 3 Style',
								'h4' => 'Heading 4 Style',
								'h5' => 'Heading 5 Style',
								'h6' => 'Heading 6 Style',
							),
							'default_value' => array(
								0 => 'h2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'disabled' => 0,
							'readonly' => 0,
							'return_format' => 'value',
						),
						array(
							'key' => 'field_5746e81f00183',
							'label' => 'Content',
							'name' => 'content_rails',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5746e81f00181',
										'operator' => '==',
										'value' => 'rails',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_5746eedac39de',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_5746e87d00187',
									'label' => 'Image',
									'name' => 'rails_image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5746e8d300188',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_574d8923d99be',
									'label' => 'Linked',
									'name' => 'linked',
									'type' => 'select',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										1 => 'Internal',
										2 => 'External',
										3 => 'No',
									),
									'default_value' => array(
										0 => 3,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_574d8942d99bf',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_574d8923d99be',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '80',
										'class' => '',
										'id' => '',
									),
									'post_type' => array(
										0 => 'post',
										1 => 'page',
									),
									'taxonomy' => array(
									),
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
								array(
									'key' => 'field_59930b209224c',
									'label' => 'URL',
									'name' => 'url',
									'type' => 'url',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_574d8923d99be',
												'operator' => '==',
												'value' => '2',
											),
										),
									),
									'wrapper' => array(
										'width' => '80',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5746eedac39de',
									'label' => 'Header',
									'name' => 'rails_header',
									'type' => 'textarea',
									'instructions' => '',
									'required' => '',
									'conditional_logic' => '',
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 2,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_5746ef37c39df',
									'label' => 'Paragraph',
									'name' => 'rails_paragraph',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
								array(
									'key' => 'field_57e58bfaba638',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_5746e81f00186',
							'label' => 'Content',
							'name' => 'content_wysiwyg',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5746e81f00181',
										'operator' => '==',
										'value' => 'free',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_57470c789b1f1',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_57470c789b1f1',
									'label' => 'WYSIWYG Content',
									'name' => 'wysiwyg_content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '<h3>Sed Dignissim Lacinia</h3><p>Morbi in dui quis est pulvinar ullamcorper. Nulla facilisi integer lacinia sollicitudin massa.</p>',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 0,
									'delay' => 1,
								),
								array(
									'key' => 'field_57e58c11ba639',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class_wysiwyg',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_57ea94482025c',
							'label' => 'Content',
							'name' => 'content_code',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5746e81f00181',
										'operator' => '==',
										'value' => 'code',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_57ea94482025d',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content',
							'sub_fields' => array(
								array(
									'key' => 'field_57ea94482025d',
									'label' => 'Code Content',
									'name' => 'code_content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
								),
								array(
									'key' => 'field_57ea94482025e',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class_code',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_574efa76a3b35',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5746e81f0017c',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5746e81f0017f',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5746e81f0017d',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be1bd4f4e6',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e53145e5967',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'5820f7fab89ed' => array(
					'key' => '5820f7fab89ed',
					'name' => 'pattern_content_2',
					'label' => 'Block Content: Custom',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5820f7fab89ee',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5820f7fab89ef',
							'label' => 'Content',
							'name' => 'content',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_5820f822b89fa',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Block',
							'sub_fields' => array(
								array(
									'key' => 'field_5820f822b89fa',
									'label' => 'Type',
									'name' => 'type',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'column' => 'Column',
										'code' => 'Code',
										'break' => 'Break',
									),
									'default_value' => array(
										0 => 'column',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820f853b89fb',
									'label' => 'Break',
									'name' => 'break',
									'type' => 'checkbox',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f822b89fa',
												'operator' => '==',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '80',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'xs' => 'X-Small',
										'sm' => 'Small',
										'md' => 'Medium',
										'lg' => 'Large',
									),
									'default_value' => array(
										0 => 'xs',
										1 => 'sm',
										2 => 'md',
										3 => 'lg',
									),
									'layout' => 'horizontal',
									'toggle' => 0,
									'return_format' => 'value',
									'allow_custom' => 0,
									'save_custom' => 0,
								),
								array(
									'key' => 'field_5820f88eb89fc',
									'label' => 'X-Small',
									'name' => 'xs',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f822b89fa',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820f8d3b89fd',
									'label' => 'Small',
									'name' => 'sm',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f822b89fa',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820f8dbb89fe',
									'label' => 'Medium',
									'name' => 'md',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f822b89fa',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820f8e2b89ff',
									'label' => 'Large',
									'name' => 'lg',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f822b89fa',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '20',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'hide' => 'Hide',
										1 => '1',
										2 => '2',
										3 => '3',
										4 => '4',
										5 => '5',
										6 => '6',
										7 => '7',
										8 => '8',
										9 => '9',
										10 => '10',
										11 => '11',
										12 => '12',
									),
									'default_value' => array(
										0 => 12,
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_5820f8f4b8a00',
									'label' => 'Column',
									'name' => 'column',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f822b89fa',
												'operator' => '==',
												'value' => 'column',
											),
										),
									),
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 1,
									'delay' => 0,
								),
								array(
									'key' => 'field_5820f916b8a01',
									'label' => 'Code',
									'name' => 'code',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f822b89fa',
												'operator' => '==',
												'value' => 'code',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 4,
									'new_lines' => '',
								),
								array(
									'key' => 'field_5820f93eb8a02',
									'label' => 'Custom Block CSS Class',
									'name' => 'custom_block_css_class',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5820f822b89fa',
												'operator' => '!=',
												'value' => 'break',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
							),
						),
						array(
							'key' => 'field_5820f7fab89f4',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5820f7fab89f5',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5820f7fab89f6',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5820f7fab89f7',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5820f7fab89f8',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5820f7fab89f9',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57570408c009f' => array(
					'key' => '57570408c009f',
					'name' => 'pattern_figures_2',
					'label' => 'Block Content: Image Blocks',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_57570408c00a0',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57570408c00a7',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								3 => 'Three',
								4 => 'Four',
								6 => 'Six',
							),
							'default_value' => array(
								0 => 1,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57570408c00a4',
							'label' => 'Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'1x1' => 'Square',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3:2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57570408c00a2',
							'label' => 'Blocks',
							'name' => 'blocks',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Block',
							'sub_fields' => array(
								array(
									'key' => 'field_57570408c00a3',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_57570408c00a6',
									'label' => 'Text',
									'name' => 'text',
									'type' => 'text',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
								array(
									'key' => 'field_580918187cf7f',
									'label' => 'Link',
									'name' => 'link',
									'type' => 'page_link',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'post_type' => '',
									'taxonomy' => '',
									'allow_null' => 0,
									'allow_archives' => 1,
									'multiple' => 0,
								),
							),
						),
						array(
							'key' => 'field_57570408c00ad',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_57570408c00ae',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_57570408c00af',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57570408c00b0',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be1e74f4e8',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e53153e5969',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'58d2b3181a2d9' => array(
					'key' => '58d2b3181a2d9',
					'name' => 'pattern_content_3',
					'label' => 'Block Content: Image List',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_58d2b3181a2da',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_58d2b32c1a2eb',
							'label' => 'Columns',
							'name' => 'columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'2_10' => '2 and 10',
								'3_9' => '3 and 9',
								'4_8' => '4 and 8',
							),
							'default_value' => array(
								0 => '2_10',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'ajax' => 0,
							'return_format' => 'value',
							'placeholder' => '',
						),
						array(
							'key' => 'field_58d2b4051a2ec',
							'label' => 'Content',
							'name' => 'content',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_58d2b44f1a2ef',
							'min' => 0,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content Block',
							'sub_fields' => array(
								array(
									'key' => 'field_58d2b4241a2ed',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 'medium',
									'library' => 'all',
									'min_width' => '',
									'min_height' => '',
									'min_size' => '',
									'max_width' => '',
									'max_height' => '',
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_58d2b42e1a2ee',
									'label' => 'Image Caption',
									'name' => 'image_caption',
									'type' => 'text',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'prepend' => '',
									'append' => '',
									'maxlength' => '',
								),
								array(
									'key' => 'field_58d2b44f1a2ef',
									'label' => 'Content',
									'name' => 'content',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'full',
									'media_upload' => 0,
									'delay' => 0,
								),
							),
						),
						array(
							'key' => 'field_58d2b3181a2e5',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_58d2b3181a2e6',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_58d2b3181a2e7',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_58d2b3181a2e8',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_58d2b3181a2e9',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_58d2b3181a2ea',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'5750829d77e7d' => array(
					'key' => '5750829d77e7d',
					'name' => 'pattern_figures_1',
					'label' => 'Figures',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_5750829d77e7e',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5750877677e92',
							'label' => 'Figure or Gallery',
							'name' => 'figure_or_gallery',
							'type' => 'select',
							'instructions' => 'Galleries should be for three or more images.',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'figure' => 'Figure',
								'gallery' => 'Gallery',
							),
							'default_value' => array(
								0 => 'figure',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_575087ff77e93',
							'label' => 'Figures',
							'name' => 'figures',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5750877677e92',
										'operator' => '==',
										'value' => 'figure',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_5750882e77e94',
							'min' => 1,
							'max' => 2,
							'layout' => 'block',
							'button_label' => 'Add Figure',
							'sub_fields' => array(
								array(
									'key' => 'field_57509bc3dbb02',
									'label' => 'Ratio',
									'name' => 'ratio',
									'type' => 'select',
									'instructions' => 1,
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1x1' => 'Square',
										'3x2' => '3:2',
										'16x9' => '16:9',
									),
									'default_value' => array(
										0 => '3:2',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5750899f77e96',
									'label' => 'Caption?',
									'name' => 'caption',
									'type' => 'select',
									'instructions' => 'Caption',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'none' => 'None',
										'below' => 'Below',
										'right' => 'Right',
									),
									'default_value' => array(
										0 => 'none',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5750882e77e94',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_5750896c77e95',
									'label' => 'Caption Content',
									'name' => 'content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_5750899f77e96',
												'operator' => '!=',
												'value' => 'none',
											),
										),
									),
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 3,
									'new_lines' => 'br',
								),
							),
						),
						array(
							'key' => 'field_5750829d77e7f',
							'label' => 'Columns',
							'name' => 'columns_gallery',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5750877677e92',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								3 => 'Three',
								4 => 'Four',
								6 => 'Six',
							),
							'default_value' => array(
								0 => 1,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57557b0cb0dc7',
							'label' => 'Caption Position',
							'name' => 'caption_gallery',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5750877677e92',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'left' => 'Left',
								'center' => 'Center',
							),
							'default_value' => array(
								0 => 'left',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5755794fd2844',
							'label' => 'Gallery',
							'name' => 'gallery',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5750877677e92',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => 'field_5755794fd2845',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Gallery Image',
							'sub_fields' => array(
								array(
									'key' => 'field_5755794fd2845',
									'label' => 'Image',
									'name' => 'image',
									'type' => 'image',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '35',
										'class' => '',
										'id' => '',
									),
									'return_format' => 'array',
									'preview_size' => 's3-md-16x9',
									'library' => 'all',
									'min_width' => 600,
									'min_height' => 300,
									'min_size' => '',
									'max_width' => 2400,
									'max_height' => 2400,
									'max_size' => '',
									'mime_types' => '',
								),
								array(
									'key' => 'field_5755794fd2846',
									'label' => 'Ratio',
									'name' => 'ratio',
									'type' => 'select',
									'instructions' => 1,
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '15',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1x1' => 'Square',
										'3x2' => '3:2',
										'16x9' => '16:9',
									),
									'default_value' => array(
										0 => '3:2',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'return_format' => 'value',
									'ajax' => 0,
									'placeholder' => '',
								),
								array(
									'key' => 'field_5755794fd2848',
									'label' => 'Caption Content',
									'name' => 'content',
									'type' => 'textarea',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => 35,
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'placeholder' => '',
									'maxlength' => '',
									'rows' => 3,
									'new_lines' => 'br',
									'readonly' => 0,
									'disabled' => 0,
								),
							),
						),
						array(
							'key' => 'field_5750829d77e8e',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5750829d77e8f',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_5750829d77e90',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5750829d77e91',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be1d24f4e7',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e5314ae5968',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'579251c471209' => array(
					'key' => '579251c471209',
					'name' => 'pattern_media_1',
					'label' => 'Media',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_579251c47120a',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_5792527871215',
							'label' => 'Show Media Descriptions?',
							'name' => 'media',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => '',
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_5792530971216',
							'label' => 'Media Description Before',
							'name' => 'media_description_before',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5792527871215',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 0,
							'delay' => 1,
						),
						array(
							'key' => 'field_5792532e71217',
							'label' => 'Media Description After',
							'name' => 'media_description_after',
							'type' => 'wysiwyg',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5792527871215',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'tabs' => 'all',
							'toolbar' => 'full',
							'media_upload' => 0,
							'delay' => 1,
						),
						array(
							'key' => 'field_5792534571218',
							'label' => 'Media Type',
							'name' => 'media_type',
							'type' => 'radio',
							'instructions' => 'Select a type of content you wish to add. Media will fill the width of the container.',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'youtube' => 'YouTube ID',
								'soundcloud' => 'SoundCloud ID',
								'gallery' => 'Gallery',
								'embed' => 'Embed Code',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'save_other_choice' => 0,
							'default_value' => '',
							'layout' => 'horizontal',
							'return_format' => 'value',
						),
						array(
							'key' => 'field_5792538a71219',
							'label' => 'YouTube ID',
							'name' => 'youtube_id',
							'type' => 'text',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5792534571218',
										'operator' => '==',
										'value' => 'youtube',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
							'readonly' => 0,
							'disabled' => 0,
						),
						array(
							'key' => 'field_579253ab7121a',
							'label' => 'SoundCloud ID',
							'name' => 'soundcloud_id',
							'type' => 'text',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5792534571218',
										'operator' => '==',
										'value' => 'soundcloud',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
							'readonly' => 0,
							'disabled' => 0,
						),
						array(
							'key' => 'field_579253bc7121b',
							'label' => 'Gallery Image Ratio',
							'name' => 'image_ratio',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5792534571218',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'1x1' => 'Square',
								'3x2' => '3:2',
								'16x9' => '16:9',
							),
							'default_value' => array(
								0 => '3x2',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_579253ee7121c',
							'label' => 'Gallery Columns',
							'name' => 'gallery_columns',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5792534571218',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								1 => 'One',
								2 => 'Two',
								3 => 'Three',
								4 => 'Four',
								6 => 'Six',
							),
							'default_value' => array(
								0 => 4,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_579254097121d',
							'label' => 'Gallery Captions',
							'name' => 'gallery_captions',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5792534571218',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'No Captions',
								'left' => 'Left',
								'center' => 'Center',
							),
							'default_value' => array(
								0 => 'none',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_5792542a7121e',
							'label' => 'Gallery Images',
							'name' => 'gallery_images',
							'type' => 'gallery',
							'instructions' => 'Note: Gallery thumbnails will be linked to the original uploaded file. Please be mindful of your file sizes.',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5792534571218',
										'operator' => '==',
										'value' => 'gallery',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'preview_size' => 's3-md-16x9',
							'insert' => 'append',
							'library' => 'all',
							'min' => '',
							'max' => '',
							'min_width' => 600,
							'min_height' => 300,
							'min_size' => '',
							'max_width' => 2400,
							'max_height' => 2400,
							'max_size' => '',
							'mime_types' => '',
						),
						array(
							'key' => 'field_5792545a7121f',
							'label' => 'Embed Code',
							'name' => 'embed_code',
							'type' => 'textarea',
							'instructions' => 'Note: Gallery thumbnails will be linked to the original uploaded file. Please be mindful of your file sizes.',
							'required' => 1,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_5792534571218',
										'operator' => '==',
										'value' => 'embed',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'maxlength' => '',
							'rows' => '',
							'new_lines' => '',
							'readonly' => 0,
							'disabled' => 0,
						),
						array(
							'key' => 'field_579251c571210',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_579251c571211',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_579251c571212',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_579251c571213',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_579251c571214',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e53159e596a',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'574da56c3e3ac' => array(
					'key' => '574da56c3e3ac',
					'name' => 'pattern_content_1',
					'label' => 'Normal Content',
					'display' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_574ef8eeda3ba',
							'label' => 'Content Area',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_574da56c3e3bc',
							'label' => 'Content',
							'name' => 'content',
							'type' => 'repeater',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'collapsed' => '',
							'min' => 1,
							'max' => 0,
							'layout' => 'block',
							'button_label' => 'Add Content Block',
							'sub_fields' => array(
								array(
									'key' => 'field_574ef3a155d07',
									'label' => 'Columns',
									'name' => 'columns',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										1 => 'One',
										2 => 'Two',
									),
									'default_value' => array(
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_574ef5a455d08',
									'label' => 'Split',
									'name' => 'split',
									'type' => 'select',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_574ef3a155d07',
												'operator' => '==',
												'value' => '2',
											),
										),
									),
									'wrapper' => array(
										'width' => '50',
										'class' => '',
										'id' => '',
									),
									'choices' => array(
										'1_11' => '1 and 11',
										'2_10' => '2 and 10',
										'3_9' => '3 and 9',
										'4_8' => '4 and 8',
										'5_7' => '5 and 7',
										'6_6' => '6 and 6',
										'7_5' => '7 and 5',
										'8_4' => '8 and 4',
										'9_3' => '9 and 3',
										'10_2' => '10 and 2',
										'11_1' => '11 and 1',
									),
									'default_value' => array(
										0 => '6_6',
									),
									'allow_null' => 0,
									'multiple' => 0,
									'ui' => 0,
									'ajax' => 0,
									'return_format' => 'value',
									'placeholder' => '',
								),
								array(
									'key' => 'field_574ef6e855d09',
									'label' => 'Content',
									'name' => 'content_1',
									'type' => 'wysiwyg',
									'instructions' => '',
									'required' => 1,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'full',
									'media_upload' => 1,
									'delay' => 0,
								),
								array(
									'key' => 'field_574ef70e55d0a',
									'label' => 'Content',
									'name' => 'content_2',
									'type' => 'wysiwyg',
									'instructions' => 'Less content than the first.',
									'required' => 1,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_574ef3a155d07',
												'operator' => '==',
												'value' => '2',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'tabs' => 'all',
									'toolbar' => 'basic',
									'media_upload' => 1,
									'delay' => 0,
								),
							),
						),
						array(
							'key' => 'field_574ef8a618008',
							'label' => 'Container Style',
							'name' => '',
							'type' => 'tab',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'placement' => 'top',
							'endpoint' => 0,
						),
						array(
							'key' => 'field_574da56c3e3ad',
							'label' => 'Display Type',
							'name' => 'display_type',
							'type' => 'radio',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inset' => 'Inset Breakout',
								'fluid' => 'Fluid Breakout',
							),
							'allow_null' => 0,
							'other_choice' => 0,
							'default_value' => 'inset',
							'layout' => 'horizontal',
							'return_format' => 'value',
							'save_other_choice' => 0,
						),
						array(
							'key' => 'field_574da56c3e3ae',
							'label' => 'Background Color',
							'name' => 'background_color',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								't' => 'Transparent',
								'c' => 'Canvas',
								'w' => 'White',
								'gt' => 'Garnet',
								'gd' => 'Gold',
								'gd1c' => 'Gold + 1 Canvas',
								'gd2c' => 'Gold + 2 Canvas',
								'gd3c' => 'Gold + 3 Canvas',
								'n2w' => 'Neutral + 2 White',
								'n1w' => 'Neutral + 1 White',
								'n' => 'Neutral',
								'n1s' => 'Neutral + 1 Slate',
								'n2s' => 'Neutral + 2 Slate',
								's' => 'Slate',
								'k' => 'Black',
								'bg-c' => 'Canvas Background',
								'bg-w' => 'White Background',
								'bg-gt' => 'Garnet Background',
								'bg-gd' => 'Gold Background',
								'bg-gd1c' => 'Gold + 1 Canvas Background',
								'bg-gd2c' => 'Gold + 2 Canvas Background',
								'bg-gd3c' => 'Gold + 3 Canvas Background',
								'bg-n2w' => 'Neutral + 2 White Background',
								'bg-n1w' => 'Neutral + 1 White Background',
								'bg-n' => 'Neutral Background',
								'bg-n1s' => 'Neutral + 1 Slate Background',
								'bg-n2s' => 'Neutral + 2 Slate Background',
								'bg-s' => 'Slate Background',
								'bg-k' => 'Black Background',
							),
							'default_value' => array(
								0 => 't',
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_574da56c3e3af',
							'label' => 'Container Margin Top',
							'name' => 'container_margin_top',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_576be1fb4f4e9',
							'label' => 'Container Margin Bottom',
							'name' => 'container_margin_bottom',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								0 => 'Level 0 (0)',
								1 => 'Level 1 (0.178em)',
								2 => 'Level 2 (0.238em)',
								3 => 'Level 3 (0.317em)',
								4 => 'Level 4 (0.422em)',
								5 => 'Level 5 (0.563em)',
								6 => 'Level 6 (0.75em)',
								7 => 'Level 7 (1em)',
								8 => 'Level 8 (1.333em)',
								9 => 'Level 9 (1.777em)',
								10 => 'Level 10 (2.369em)',
								11 => 'Level 11 (3.157em)',
								12 => 'Level 12 (4.209em)',
								13 => 'Level 13 (5.61em)',
								14 => 'Level 14 (7.478em)',
								15 => 'Level 15 (9.969em)',
							),
							'default_value' => array(
								0 => 0,
							),
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
						),
						array(
							'key' => 'field_57e53160e596b',
							'label' => 'Custom CSS Classes',
							'name' => 'custom_css_classes',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
					'min' => '',
					'max' => '',
				),
				'57602040beeed' => array(
					'key' => '57602040beeed',
					'name' => 'reusable_content',
					'label' => 'Reusable Content',
					'display' => 'table',
					'sub_fields' => array(
						array(
							'key' => 'field_5760205bbeeee',
							'label' => 'Reusable Content ID',
							'name' => 'reusable_content_id',
							'type' => 'number',
							'instructions' => 'Insert the reusable content ID from the options page (Options > Reusable Content).',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => 1,
							'prepend' => '',
							'append' => '',
							'min' => 1,
							'max' => 99,
							'step' => 1,
							'readonly' => 0,
							'disabled' => 0,
						),
					),
					'min' => '',
					'max' => '',
				),
			),
			'button_label' => 'Add Content Container Block',
			'min' => '',
			'max' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-1.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-2.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-3.php',
			),
			array(
				'param' => 'page_template',
				'operator' => '!=',
				'value' => 'page-custom-4.php',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'post',
			),
		),
	),
	'menu_order' => 70,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

endif;



