<?php

# Flexible Content
if ( ! function_exists( 'acf_content_flexible' ) ) {
	function acf_content_flexible ($input, $location='content_above', $rcid=false, $passthrough=false) {
		#displayVar($input);
		#displayVar($location);
		# Set up the content container
		$content = array();

		# Set up an empty $options variable to check for reusable content
		$options = false;
		# $rcid is the Reusable Content ID
		if ($rcid) {
			$options = 'option';
		}

		# Collect the content
		while ( have_rows($location, $options) ) {
			$output = array();
			$output['location'] = $location;
			$output['passthrough'] = $passthrough;
			the_row();

			# Processing reusable content
			if ($options) {
				# $cid is the Content ID from the specific call
				$cid = get_sub_field('content_id');
				# Unfortunately, it appears we need to loop through all the Options content in order to pull out the specific content
				# If the content ID does not match the requested ID then continue
				if ($rcid != $cid) {
					continue;
				}
			}

			# Set up the output to process through functions based upon layout type
			$layout = get_row_layout();

			# Reusable Content
			if ( $layout == 'reusable_content' ) {
				# If the content is within the editor area then set passthrough to true and process within acf_flexible_container to not wrap the contents within a container
				if ($location == 'content_within') {
					$output['passthrough'] = true;
				} else {
					$output['passthrough'] = false;
				}

				# Get the ID for the reusable content that needs to load
				$reusable_content_id = get_sub_field('reusable_content_id');
				$reusable = have_rows('content_options', 'option');
				$content[] = acf_content_flexible($reusable, 'content_options', $reusable_content_id, $output['passthrough']);
			} else {
				# Display Type
				if ($display_type = get_sub_field('display_type')) {
					$output['display_type'] = $display_type;
				} elseif ($location == 'content_within') {
					$output['display_type'] = 'default';
				} else {
					$output['display_type'] = 'default';
				}

				# Background Color
				if ($background = get_sub_field('background_color')) {
					$output['background_color'] = $background;
				} else {
					$output['background_color'] = 't';
				}
				if ($output['background_color'] == 't') {
					$output['background_color'] = _SITE_CONTENT;
				}
				if ( ($location == 'content_above') && ($output['background_color'] == 't') ) {
					$output['background_color'] = _SITE_CONTENT_ABOVE;
				}
				if ( ($location == 'content_below') && ($output['background_color'] == 't') ) {
					$output['background_color'] = _SITE_CONTENT_BELOW;
				}

				# Margin Top
				$margin_top = get_sub_field('container_margin_top');
				if (is_array($margin_top)) {
					$output['margin_top'] = $margin_top[0];
				} else {
					$output['margin_top'] = $margin_top;
				}

				# Margin Bottom
				$margin_bottom = get_sub_field('container_margin_bottom');
				if (is_array($margin_bottom)) {
					$output['margin_bottom'] = $margin_bottom[0];
				} else {
					$output['margin_bottom'] = $margin_bottom;
				}

				# Wider Feature
				$output['wider_feature']      = get_sub_field('wider_feature');

				# Custom CSS Classes
				$output['custom_css_classes'] = get_sub_field('custom_css_classes');
			}

			# Slider: Banner
			if ( $layout == 'pattern_slider_1' ) {
				if ($output['background_color'] != 't') {
					$output['background_color'] = 'bg-' . $output['background_color'];
				}
				$output['image_ratio']  = get_sub_field('image_ratio');
				$output['arrow_change'] = get_sub_field('arrow_change');
				$output['arrow_color']  = get_sub_field('arrow_color');
				$output['arrow_shape']  = get_sub_field('arrow_shape');
				$output['arrows']       = acf_slider_arrows($output['arrow_change'], $output['arrow_color'], $output['arrow_shape']);
				if ( have_rows('slide') ) {
					$count = 0;
					while ( have_rows('slide') ) {
						the_row();
						if ($slider_display = get_sub_field('display')) {
							$output['content'][$count]['display'] = $slider_display;
						} else {
							$output['content'][$count]['display'] = array('image', 'banner');
						}
						$image = get_sub_field('image');
						$output['content'][$count]['image']         = acf_image_selector($image, 'lg', $output['image_ratio']);
						#$output['content'][$count]['image_alt']     = $image['alt'];
						$output['content'][$count]['color']         = get_sub_field('block_color');
						$output['content'][$count]['position']      = get_sub_field('block_position');
						$output['content'][$count]['header']        = get_sub_field('block_content_header');
						$output['content'][$count]['paragraph']     = get_sub_field('block_content_paragraph');
						$output['content'][$count]['embellishment'] = get_sub_field('embellishment');
						if (get_sub_field('linked')) {
							$output['content'][$count]['linked']    = true;
							$output['content'][$count]['link']      = get_sub_field('link');
							$output['content'][$count]['link_text'] = get_sub_field('link_text');
						} else {
							$output['content'][$count]['linked']    = false;
						}
						$count++;
					}
				}
				$content[] = acf_flexible_slider_1($output);
			}



			# Slider: Description Below Image
			if ( $layout == 'pattern_slider_3' ) {
				$output['image_ratio']  = get_sub_field('image_ratio');
				$output['arrow_change'] = get_sub_field('arrow_change');
				$output['arrow_color']  = get_sub_field('arrow_color');
				$output['arrow_shape']  = get_sub_field('arrow_shape');
				$output['arrows']       = acf_slider_arrows($output['arrow_change'], $output['arrow_color'], $output['arrow_shape']);
				$output['color']        = get_sub_field('block_color');
				if ( have_rows('slide') ) {
					$count = 0;
					while ( have_rows('slide') ) {
						the_row();
						$image = get_sub_field('image');
	#					$output['content'][$count]['image']         = $image['sizes']['s3-lg-' . $output['image_ratio'] ];
						$output['content'][$count]['image']         = acf_image_selector($image, 'lg', $output['image_ratio']);
						$output['content'][$count]['image_alt']     = $image['alt'];
						$output['content'][$count]['header']        = get_sub_field('block_content_header');
						$output['content'][$count]['paragraph']     = get_sub_field('block_content_paragraph');
						if (get_sub_field('linked')) {
							$output['content'][$count]['linked']    = true;
							$output['content'][$count]['link']      = get_sub_field('link');
							$output['content'][$count]['link_text'] = get_sub_field('link_text');
						} else {
							$output['content'][$count]['linked']    = false;
						}
						$count++;
					}
				}
				$content[] = acf_flexible_slider_3($output);
			}


			# Slider: Split
			if ( $layout == 'pattern_slider_4' ) {
				if ($output['background_color'] != 't') {
					$output['background_color'] = 'bg-' . $output['background_color'];
				}
				if ($image_ratio = get_sub_field('image_ratio')) {
					$output['image_ratio']  = $image_ratio;
				} else {
					$output['image_ratio']  = '3x2';
				}
				$output['columns']      = get_sub_field('columns_3x2');
				$output['arrow_change'] = get_sub_field('arrow_change');
				$output['arrow_color']  = get_sub_field('arrow_color');
				$output['arrow_shape']  = 'default';
				$output['arrows']       = acf_slider_arrows($output['arrow_change'], $output['arrow_color'], $output['arrow_shape']);
				if ( have_rows('slide') ) {
					$count = 0;
					while ( have_rows('slide') ) {
						the_row();
						$image = get_sub_field('image');
						$output['content'][$count]['image']         = acf_image_selector($image, 'lg', $output['image_ratio']);
						$output['content'][$count]['image_alt']     = $image['alt'];
						$output['content'][$count]['color']         = get_sub_field('block_color');
						$output['content'][$count]['position']      = get_sub_field('block_position');
						$output['content'][$count]['header']        = get_sub_field('block_content_header');
						$output['content'][$count]['paragraph']     = get_sub_field('block_content_paragraph');
						if (get_sub_field('linked')) {
							$output['content'][$count]['linked']    = true;
							$output['content'][$count]['link']      = get_sub_field('link');
							$output['content'][$count]['link_text'] = get_sub_field('link_text');
						} else {
							$output['content'][$count]['linked']    = false;
						}
						$count++;
					}
				}
				$content[] = acf_flexible_slider_4($output);
			}


			# Slider: Split With Static Message
			if ( $layout == 'pattern_slider_5' ) {
				if ($output['background_color'] != 't') {
					$output['background_color'] = 'bg-' . $output['background_color'];
				}

				if ($image_ratio = get_sub_field('image_ratio')) {
					$output['image_ratio']  = $image_ratio;
				} else {
					$output['image_ratio']  = '3x2';
				}
				$output['columns']      = get_sub_field('columns_3x2');

				$output['arrow_change'] = get_sub_field('arrow_change');
				$output['arrow_color']  = get_sub_field('arrow_color');
				$output['arrow_shape']  = 'default';
				$output['arrows']       = acf_slider_arrows($output['arrow_change'], $output['arrow_color'], $output['arrow_shape']);
				$output['color']        = get_sub_field('block_color');
				$output['position']     = get_sub_field('block_position');
				$output['content']      = get_sub_field('block_content');
				if ( have_rows('slide') ) {
					$count = 0;
					while ( have_rows('slide') ) {
						the_row();
						$image = get_sub_field('image');
						$output['images'][$count]['graphic'] = acf_image_selector($image, 'lg', $output['image_ratio']);
						$output['images'][$count]['alt']     = $image['alt'];

						$count++;
					}
				}
				$content[] = acf_flexible_slider_5($output);
			}


			# Slider: Carousel
			if ( $layout == 'pattern_slider_6' ) {
				$output['arrow_change']  = get_sub_field('arrow_change');
				$output['arrow_color']   = get_sub_field('arrow_color');
				$output['arrow_shape']   = 'default';
				$output['arrows']        = acf_slider_arrows($output['arrow_change'], $output['arrow_color'], $output['arrow_shape']);
				$output['embellishment'] = get_sub_field('embellishment');
				$output['block_height']  = get_sub_field('block_height');
				$output['color']         = get_sub_field('block_color');
				if ($output['message'] = get_sub_field('message') ) {
					$output['columns']         = get_sub_field('columns');
					$output['position']        = get_sub_field('block_position');
					$output['message_content'] = get_sub_field('message_content');

				}
				if ($output['image'] = get_sub_field('image')) {
					if ($image_ratio = get_sub_field('image_ratio')) {
						$output['image_ratio']  = $image_ratio;
					} else {
						$output['image_ratio']  = '3x2';
					}
				}
				if ( have_rows('slides') ) {
					$count = 0;
					while ( have_rows('slides') ) {
						the_row();
						if ($output['image']) {
							if ($image = get_sub_field('image')) {
								$output['slides'][$count]['image']     = acf_image_selector($image, 'lg', $output['image_ratio']);
								$output['slides'][$count]['image_alt'] = $image['alt'];
							}
						}
						$output['slides'][$count]['content'] = get_sub_field('content');
						$count++;
					}
				}
				$content[] = acf_flexible_slider_6($output);
			}


			# Feature: Background Cover with Banner
			if ( $layout == 'pattern_feature_1' ) {
				if ($output['background_color'] != 't') {
					$output['background_color'] = 'bg-' . $output['background_color'];
				}
				$output['image_ratio']   = get_sub_field('image_ratio');
				$image                   = get_sub_field('image');
				$output['image']         = acf_image_selector($image, 'lg', $output['image_ratio']);
				#$output['image_alt']     = $image['alt'];
				$output['color']         = get_sub_field('block_color');
				$output['position']      = get_sub_field('block_position');
				$output['width']         = get_sub_field('block_width');
				$output['width_center']  = get_sub_field('block_width_center');
				$output['embellishment'] = get_sub_field('embellishment');
				$output['content']       = get_sub_field('block_content');
				$content[] = acf_flexible_feature_1($output);
			}


			# Feature: Background Cover
			if ( $layout == 'pattern_feature_2' ) {
				if ($output['background_color'] != 't') {
					$output['background_color'] = 'bg-' . $output['background_color'];
				}
				$output['image_ratio']   = get_sub_field('image_ratio');
				$image                   = get_sub_field('image');
				$output['image']         = acf_image_selector($image, 'lg', $output['image_ratio']);
				#$output['image_alt']     = $image['alt'];
				$output['color']         = get_sub_field('block_color');
				$output['position']      = get_sub_field('block_position');
				$output['width']         = get_sub_field('block_width');
				$output['width_center']  = get_sub_field('block_width_center');
				$output['embellishment'] = get_sub_field('embellishment');
				$output['content']       = get_sub_field('block_content');
				$content[] = acf_flexible_feature_2($output);
			}


			# Feature: Banners
			if ( $layout == 'pattern_feature_3' ) {
				if ($output['background_color'] != 't') {
					$output['background_color'] = 'bg-' . $output['background_color'];
				}
				$output['banner_background'] = get_sub_field('banner_color_background');
				$output['color']             = get_sub_field('block_color');
				$output['block-height']      = get_sub_field('block_height');
				$output['embellishment']     = get_sub_field('embellishment');
				if ( have_rows('block') ) {
					$count = 0;
					while ( have_rows('block') ) {
						the_row();
						$output['content'][$count]['content'] = get_sub_field('block_content');
						$count++;
					}
				}
				$content[] = acf_flexible_feature_3($output);
			}


			# Hero
			if ( $layout == 'pattern_hero_1' ) {
				$output['content_type']     = get_sub_field('content_type');
				if ( $output['content_type'] == 'rails' ) {
					$content_rails = get_sub_field('content_rails');
					$output['rails_alignment'] = get_sub_field('rails_alignment');
					foreach ($content_rails as $key => $value) {
						$output['content_rails'][$key]['rails_type']    = $value['rails_type'];
						$output['content_rails'][$key]['rails_content'] = $value['rails_content'];
					}
				} else {
					$output['content_wysiwyg'] = get_sub_field('content_wysiwyg');
				}
				$content[] = acf_flexible_hero_1($output);
			}


			# Background Divider: Saw
			if ( $layout == 'background_divider_saw' ) {
				$output['background_color'] = get_sub_field('background_color');
				$output['saw_color']        = get_sub_field('saw_color');
				$output['size']             = get_sub_field('size');
				$content[] = acf_flexible_bg_saw($output);
			}


			# Blocks
			if ( $layout == 'pattern_blocks_1' ) {
				$output['columns']      = get_sub_field('columns');
				$output['content_type'] = get_sub_field('content_type');
				if ( $output['content_type'] == 'rails' ) {
					$output['rails_alignment']          = get_sub_field('rails_alignment');
					$output['rails_header_type']        = get_sub_field('rails_header_type');
					$output['rails_image_available']    = get_sub_field('rails_image_available');
					if ($output['rails_image_available']) {
						$output['rails_image_ratio']  = get_sub_field('rails_image_ratio');
						if ($output['rails_image_ratio'] != 'square') {
							$output['rails_image_effect'] = 'none';
						}
					}
	#				$output['rails_image_effect'] = get_sub_field('rails_image_effect');
					
					$content_rails = get_sub_field('content_rails');
					foreach ($content_rails as $key => $value) {
						if ($output['rails_image_available']) {
							$output['content_rails'][$key]['rails_image']     = acf_image_selector($value['rails_image'], 'md', $output['rails_image_ratio']);
							$output['content_rails'][$key]['rails_image_alt'] = $value['rails_image']['alt'];

						} else {
							$output['content_rails'][$key]['rails_image'] = false;
						}
						$output['content_rails'][$key]['rails_header']    = $value['rails_header'];
						$output['content_rails'][$key]['rails_paragraph'] = $value['rails_paragraph'];

						if ($value['linked'] == '1') {
							$output['content_rails'][$key]['linked']      = true;
							$output['content_rails'][$key]['destination'] = 'internal';
							$output['content_rails'][$key]['link']        = $value['link'];
						} elseif ($value['linked'] == '2') {
							$output['content_rails'][$key]['linked']      = true;
							$output['content_rails'][$key]['destination'] = 'external';
							$output['content_rails'][$key]['link']        = $value['url'];
						} else {
							$output['content_rails'][$key]['linked'] = false;
						}


						if ($custom_block_css_class = $value['custom_block_css_class'] ) {
							$output['content_rails'][$key]['custom_block_css_class'] = $custom_block_css_class;
						}
					}
				} elseif ( $output['content_type'] == 'free' ) {
					$content_wysiwyg = get_sub_field('content_wysiwyg');
					foreach ($content_wysiwyg as $key => $value) {
						$output['content_wysiwyg'][$key]['wysiwyg_content'] = $value['wysiwyg_content'];
						if ($custom_block_css_class_wysiwyg = $value['custom_block_css_class_wysiwyg'] ) {
							$output['content_wysiwyg'][$key]['custom_block_css_class'] = $custom_block_css_class_wysiwyg;
						}
					}
				} elseif ( $output['content_type'] == 'code' ) {
					$content_code = get_sub_field('content_code');
					foreach ($content_code as $key => $value) {
						$output['content_code'][$key]['code_content'] = $value['code_content'];
						if ($custom_block_css_class_code = $value['custom_block_css_class_code'] ) {
							$output['content_code'][$key]['custom_block_css_class'] = $custom_block_css_class_code;
						}
					}
				}
				$content[] = acf_flexible_blocks_1($output);
			}


			# Figures
			if ( $layout == 'pattern_figures_1' ) {
				$output['figure_or_gallery'] = get_sub_field('figure_or_gallery');
				$output['ratio'] = get_sub_field('ratio');
				if ($output['figure_or_gallery'] == 'figure') {
					$figures = get_sub_field('figures');
					foreach ($figures as $key => $value) {
						$output['images'][$key]['image']     = acf_image_selector($value['image'], 'lg', $output['ratio']);
						$output['images'][$key]['image_alt'] = $value['image']['alt'];
						if ($value['caption'] != 'none') {
							$output['images'][$key]['content'] = $value['content'];
							$output['images'][$key]['caption'] = $value['caption'];
						} else {
							$output['images'][$key]['caption'] = false;
						}
					}
				} elseif ($output['figure_or_gallery'] == 'gallery') {
					$gallery = get_sub_field('gallery');
					$output['columns']  = get_sub_field('columns_gallery');
					$output['position'] = get_sub_field('caption_gallery');
					foreach ($gallery as $key => $value) {
						$output['images'][$key]['image']     = acf_image_selector($value['image'], 'lg', $output['ratio']);
						$output['images'][$key]['image_alt'] = $value['image']['alt'];
						if ($value['content']) {
							$output['images'][$key]['content'] = $value['content'];
						}
					}
				} else {
					$output['figure_or_gallery'] = 'figure';
					$figures = get_sub_field('figures');
					$output['caption'] = get_sub_field('caption');
					foreach ($figures as $key => $value) {
						$output['images'][$key]['image']     = acf_image_selector($value['image'], 'lg', $output['ratio']);
						$output['images'][$key]['image_alt'] = $value['image']['alt'];
						if ($output['caption'] != 'none') {
							$output['images'][$key]['content'] = $value['content'];
							$output['images'][$key]['caption'] = $output['caption'];
						} else {
							$output['images'][$key]['caption'] = false;
						}
					}
				}
				$content[] = acf_flexible_figures_1($output);
			}


			# Image Blocks
			if ( $layout == 'pattern_figures_2' ) {
				if ($output['background_color'] != 't') {
					$output['background_color'] = 'bg-' . $output['background_color'];
				}
				$output['columns']     = get_sub_field('columns');
				$output['image_ratio'] = get_sub_field('image_ratio');
				$blocks                = get_sub_field('blocks');
				foreach ($blocks as $key => $value) {
					$output['blocks'][$key]['image'] = acf_image_selector($value['image'], 'lg', $output['image_ratio']);
					$output['blocks'][$key]['text']  = $value['text'];
					if (isset($value['link'])) {
						$output['blocks'][$key]['link']  = $value['link'];
					}
				}
				$content[] = acf_flexible_figures_2($output);
			}


			# Media
			if ( $layout == 'pattern_media_1' ) {
				$output['media']      = get_sub_field('media');
				if ($output['media']) {
					$output['media_description_before'] = get_sub_field('media_description_before');
					$output['media_description_after']  = get_sub_field('media_description_after');
				}
				$output['media_type'] = get_sub_field('media_type');
				if ($output['media_type'] == 'youtube') {
					$output['youtube_id']       = get_sub_field('youtube_id');
				}
				if ($output['media_type'] == 'soundcloud') {
					$output['soundcloud_id']    = get_sub_field('soundcloud_id');
				}
				if ($output['media_type'] == 'gallery') {
					$output['image_ratio']      = get_sub_field('image_ratio');
					$output['gallery_columns']  = get_sub_field('gallery_columns');
					$output['gallery_captions'] = get_sub_field('gallery_captions');
					$gallery_images = get_sub_field('gallery_images');
					foreach ($gallery_images as $key => $value ) {
						$output['gallery'][$key]['id']          = $value['ID'];
						$output['gallery'][$key]['thumb']       = acf_image_selector($value, 'sm', $output['image_ratio']);
						$output['gallery'][$key]['large']       = acf_image_selector($value, 'url', 'full');
						$output['gallery'][$key]['alt']         = $value['alt'];
						$output['gallery'][$key]['caption']     = $value['caption'];
						$output['gallery'][$key]['description'] = $value['description'];
					}
				}
				if ($output['media_type'] == 'embed') {
					$output['embed_code']       = get_sub_field('embed_code');
				}
				$content[] = acf_flexible_media_1($output);
			}

			# Normal Content
			if ( $layout == 'pattern_content_1' ) {
				$normal = get_sub_field('content');
				$count = 0;
				foreach ($normal as $key => $value) {
					$output['content'][$count]['columns']   = $value['columns'];
					$output['content'][$count]['content_1'] = $value['content_1'];
					if ($value['columns'] == 2) {
						$output['content'][$count]['split']     = $value['split'];
						$output['content'][$count]['content_2'] = $value['content_2'];
					}
					$count++;
				}
				$content[] = acf_flexible_content_1($output);
			}


			# Block Content
			if ( $layout == 'pattern_content_2' ) {
				$block_content = get_sub_field('content');
				$count = 0;
				foreach ($block_content as $key => $value) {
					$output['content'][$count]['type'] = $value['type'];
					if ( ($value['type'] == 'column') || ($value['type'] == 'code') ) {
						$output['content'][$count]['xs'] = $value['xs'];
						$output['content'][$count]['sm'] = $value['sm'];
						$output['content'][$count]['md'] = $value['md'];
						$output['content'][$count]['lg'] = $value['lg'];
						if ($value['type'] == 'column') {
							$output['content'][$count]['column'] = $value['column'];
						} else {
							$output['content'][$count]['code'] = $value['code'];
						}
						$output['content'][$count]['css'] = $value['custom_block_css_class'];
					} else {
						$output['content'][$count]['break'] = $value['break'];
					}
					$count++;
				}
				$content[] = acf_flexible_content_2($output);
			}


			# Image List
			if ( $layout == 'pattern_content_3' ) {
				$output['columns'] = get_sub_field('columns');
				$block_content     = get_sub_field('content');
				$count = 0;
				foreach ($block_content as $key => $value) {
					$image = $value['image'];
	#				$output['content'][$count]['image'] = acf_image_selector($image, 'sm', '1x1');
					$output['content'][$count]['image']     = acf_image_selector($image, 'md', 'full');
					$output['content'][$count]['image_alt'] = $image['alt'];
					$output['content'][$count]['caption']   = $value['image_caption'];
					$output['content'][$count]['content']   = $value['content'];
					$count++;
				}
				$content[] = acf_flexible_content_3($output);
			}


			unset($output);
		}

		if (isset($content)) {
			$output = implode($content);
			return $output;
		} else {
			return false;
		}
	}
}



