<?php
/**
 * The header for our theme.
 *
 * This is the template that displays all of the <head> section and everything up until </header>
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Strata_Three
 */


$utilities = site_utilities();
$primary_nav_mobile = site_navigation('primary-mobile');
$primary_nav = site_navigation('primary');


?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Open+Sans:ital,wght@0,300..800;1,300..800&family=Open+Sans:ital,wdth,wght@0,75,300..800;1,75,300..800&display=swap" rel="stylesheet">

<?php wp_head(); ?>

<!-- BEGIN - Florida State University - Google Tag Manager Header Script -->
<!-- CODE UPDATE - 10/26/2017 -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'//www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-5P9ZCB');</script>
<!-- END Florida State University - Google Tag Manager Header Script -->
</head>

<body <?php body_class('s3-bg-' . _SITE_BODY); ?>>
<!-- BEGIN - Florida State University - Google Tag Manager NoScript -->
<!-- CODE UPDATE - 10/26/2017 -->
<noscript><iframe src="//www.googletagmanager.com/ns.html?id=GTM-5P9ZCB"
height="0" width="0" style="display:none;visibility:hidden" title="Tracking"></iframe></noscript>
<!-- END - Florida State University - Google Tag Manager NoScript -->

<div class="hfeed site" id="fsu-strata-three">
<header id="fsu-header" role="banner">
    <div class="s3-k"><a href="#content" class="sr-only sr-only-focusable btn btn-tab"><?php esc_html_e( 'Skip to content', 's3' ); ?></a></div>
	<div class="s3-<?php echo _SITE_GLOBAL; ?> 3-scored s3-plain-top s3-p-2" id="fsu-global">
		<div class="container">
			<div class="row">

      <div id="fsu-home" class="col-xs-7 col-sm-5">
					<a href="https://www.fsu.edu/">
						<!-- <img src="<?php print get_template_directory_uri(); ?>/s3.3/img/wordmark/fsu-wordmark-gold.svg" alt="Florida State University Home" class="fsu-wordmark fsu-wordmark-mobile visible-xs">
						<img src="<?php print get_template_directory_uri(); ?>/s3.3/img/wordmark/fsu-lockup-gold.svg" alt="Florida State University Home" class="fsu-wordmark hidden-xs"> -->
						<img src="<?php print get_template_directory_uri(); ?>/s3.3/img/175/FSU175-logo-horizontal-on-garnet.svg" alt="Florida State University Home" class="lockup-175">
  				</a>
        </div>
				<div class="col-xs-7 col-sm-8 hidden small text-uppercase" id="fsu-top" ><p><a href="https://fsu.edu">FSU</a> | <a href="./"><?php echo get_bloginfo( 'name' ); ?></a></p></div>
 				<div class="col-xs-5 col-sm-5 col-sm-offset-2" id="fsu-nav-utility">
<nav aria-label="Utility Navigation" class="fsu-nav-utility">
	<ul class="nav navbar-nav navbar-right">
	<li><a aria-controls="fsu-global-nav" aria-expanded="false" aria-label="Navigation" data-parent=".fsu-utilities" data-toggle="collapse" href="#fsu-global-nav" title="Navigation" ><span class="fa fa-bars"></span><span class="hidden">Navigation</span></a></li>
<?php site_utilities_format($utilities, 'icons'); ?>
	</ul>
</nav>
				</div>

			</div>
		</div>
	</div><!-- fsu-global -->

	<div class="s3-<?php echo _SITE_UTILITIES; ?> fsu-utilities" id="fsu-utility">

<?php site_utilities_format($utilities, 'drawers'); ?>

		<div id="fsu-global-nav" class="collapse" aria-expanded="false">
			<div class="container text-center small">

				<div class="clearfix s3-p-5"></div>

				<div class="row s3-m-10 s3-m-t0">
					<div class="col-xs-12">

						<div class="row s3-<?php echo _SITE_GLOBAL; ?>">
							<div class="col-xs-6 visible-xs col-sm-12 text-left">
                                <h2 id="site-navigation" class="sr-only">Site Navigation</h2>
								<nav class="fsu-nav-global" aria-labelledby="site-navigation">
<?php
if ($primary_nav_mobile) {
	echo $primary_nav_mobile;
}
?>
								</nav>
							</div>

							<div class="col-xs-6 col-sm-12 fsu-global-menu">
                                <h2 id="global-navigation" class="sr-only">Global Navigation</h2>
								<nav class="fsu-nav-global" aria-labelledby="global-navigation">
									<ul class="nav navbar-nav">
										<li><a href="https://www.fsu.edu/academics/">Academics</a></li>
										<li><a href="https://admissions.fsu.edu/">Admissions</a></li>
										<li><a href="https://research.fsu.edu/">Research</a></li>
										<li><a href="https://faculty.fsu.edu/">Faculty</a></li>
										<li><a href="https://www.fsu.edu/students/">Students</a></li>
										<li><a href="https://veterans.fsu.edu/">Veterans</a></li>
										<li><a href="https://www.fsu.edu/support-fsu/">Support FSU</a></li>
									</ul>
									<a class="sr-only sr-only-focusable btn btn-tab btn-sm" aria-controls="fsu-global-nav" aria-expanded="false" aria-label="Close Navigation" data-parent=".fsu-utilities" data-toggle="collapse" href="#fsu-global-nav" title="Close Navigation" >Close Menu</a>
								</nav>

							</div>
						</div>

					</div>
				</div>

			</div>
		</div><!-- fsu-global-nav -->

	</div><!-- .fsu-utilities -->


	<div class="s3-<?php echo _SITE_MASTHEAD; ?>" id="fsu-masthead">
		<div class="container">
			<div class="row">
				<div class="col-xs-12">
<?php
if ( is_front_page() ) {
	echo '<h1 id="fsu-title"><a href="' . esc_url( home_url( '/' ) ) . '" rel="home">' . get_bloginfo( 'name' ) . '</a></h1>' . "\n";
} else {
	echo '<p id="fsu-title"><a href="' . esc_url( home_url( '/' ) ) . '" rel="home">' . get_bloginfo( 'name' ) . '</a></p>' . "\n";
}

if ( $fsuSubhead = get_bloginfo( 'description' ) ) {
	echo '<p id="fsu-subheading">' . $fsuSubhead . '</p>' . "\n";
}
?>
				</div>
			</div>
		</div>
	</div><!-- fsu-masthead -->

<?php
if ($primary_nav) {
?>

	<div class="hidden-xs">
		<div class="s3-<?php echo _SITE_NAVIGATION; ?>" id="fsu-nav-primary">
      <p id="fsu-nav-primary" class="sr-only">Primary Navigation</p>
      <nav aria-labelledby="fsu-nav-primary" class="navbar text-center">
<?php echo $primary_nav; ?>
			</nav>
		</div>
	</div>
<?php
}
?>

</header>




