<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Strata_Three
 */

?>


<footer id="fsu-footer">
    <?php echo site_footer(); ?>
	<div class="s3-<?php echo _SITE_FOOTER; ?>">
		<div class="container small">
			<div class="row s3-mt-8 s3-mb-10">

				<div class="col-sm-12">
					<div class="row">

						<div class="col-xs-6 col-sm-3">
							<p>&copy; Florida State University
							<br>Tallahassee, FL 32306</p>
						</div>

						<div class="col-xs-6 col-sm-3">
							<ul class="list-unstyled">
								<li><a href="https://directory.fsu.edu/">FSU Directory Assistance</a></li>
								<li><a href="https://fsu.edu/misc/comments.html">Questions or Comments</a></li>
							</ul>
						</div>

						<div class="clearfix visible-xs"></div>

						<div class="col-xs-6 col-sm-3">
							<ul class="list-unstyled">
								<li><a href="https://fsu.edu/misc/policy.html">Privacy Policy</a></li>
								<li><a href="https://fsu.edu/misc/copyright.html">Copyright</a></li>
							</ul>
						</div>

						<div class="col-xs-6 col-sm-3">
							<nav aria-label="Social Media" class="nav-icons branded">
								<ul class="menu clearfix">
                  <li><a href="https://www.facebook.com/floridastate" target="_blank"><span class="fa-brands fa-facebook"></span><span class="sr-only">Like Florida State on Facebook</span></a></li>
                  <li><a href="https://instagram.com/floridastateuniversity/" target="_blank"><span class="fa-brands fa-instagram"></span><span class="sr-only">Follow Florida State on Instagram</span></a></li>
                  <li><a href="https://x.com/floridastate" target="_blank"><span class="fa-brands fa-x-twitter"></span><span class="sr-only">Follow Florida State on X</span></a></li>
                  <li><a href="https://www.youtube.com/FloridaState" target="_blank"><span class="fa-brands fa-youtube"></span><span class="sr-only">Follow Florida State on Youtube</span></a></li>
                  <li><a href="https://www.linkedin.com/edu/school?id=18100" target="_blank"><span class="fa-brands fa-linkedin"></span><span class="sr-only">Connect with Florida State on LinkedIn</span></a></li>
                  <li><a href="https://www.fsu.edu/socialmedia/"><span class="fa-solid fa-ellipsis"></span><span class="sr-only">More FSU Social Media</span></a></li>
								</ul>
							</nav>
						</div>

					</div>
				</div>

			</div>
		</div>
	</div>
</footer>
<?php wp_footer(); ?>

</body>
</html>

