<?php
/**
 * The template for displaying all single posts.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Strata_Three
 */

get_header();

# Check if the page content area needs to be adjusted
$content = s3_layout_content();
$content_format = s3_content_format($content);

// Check if the page needs to be adjusted for a sidebar
$sidebar = s3_layout_sidebar();
$sidebar_format = s3_sidebar_format($sidebar, 'second');

$breadcrumbs = s3_breadcrumbs();
echo $breadcrumbs['first'];
?>


<?php
// check if the flexible content field has rows of data
if ( $content = have_rows('content_above') ) {
	echo acf_content_flexible($content, 'content_above');
}
?>


<div class="s3-<?php echo _SITE_CONTENT; ?>">
<?php echo $breadcrumbs['second']; ?>


<?php
	echo $content_format;

	# Creates the properly columned div
	if ($sidebar['sidebar'] == 'yes') {
		echo $sidebar_format['content'];
	} else {
		echo $sidebar_format;
	}
?>


<!-- Single page: Begin -->
<main id="content">
		<?php while ( have_posts() ) : the_post(); ?>

			<?php get_template_part( 'template-parts/content', 'attachment' ); ?>

			<?php
				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;
			?>

			<?php
			the_post_navigation( array(
				'next_text' => '<span class="meta-nav" aria-hidden="true">' . __( 'Next Article <i class="fa fa-angle-right" title="Next"></i>', 's3' ) . '</span> ' .
					'<span class="screen-reader-text">' . __( 'Next Article:', 's3' ) . '</span> ' .
					'<span class="post-title">%title</span>',
				'prev_text' => '<span class="meta-nav" aria-hidden="true">' . __( '<i class="fa fa-angle-left" title="Previous"></i> Previous Article', 's3' ) . '</span> ' .
					'<span class="screen-reader-text">' . __( 'Previous Article:', 's3' ) . '</span> ' .
					'<span class="post-title">%title</span>',
				'in_same_term' => true,
#				'taxonomy' => __( 'category' ),
			) );
			?>

		<?php endwhile; // End of the loop. ?>
</main>
<!-- Single page: End -->


		</div><!-- /sidebar or primary content div -->

<?php
if ($sidebar['sidebar'] == 'yes') {
	echo $sidebar_format['sidebar'];
	get_sidebar($sidebar['widget']);
	echo '</div>';
}
?>
		</div><!-- .row -->
	</div><!-- .content -->
</div><!-- s3-<?php echo _SITE_CONTENT; ?> -->


<?php
// check if the flexible content field has rows of data
if ( $content = have_rows('content_below') ) {
	echo acf_content_flexible($content, 'content_below');
}
?>


<?php
get_footer();



