<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Strata_Three
 */

get_header();

# Check if the page content area needs to be adjusted
$content = s3_layout_content();
$content_format = s3_content_format($content);

// Check if the page needs to be adjusted for a sidebar
$sidebar = s3_layout_sidebar();
$sidebar_format = s3_sidebar_format($sidebar, 'second');

$breadcrumbs = s3_breadcrumbs();
echo $breadcrumbs['first'];
?>


<div class="s3-<?php echo _SITE_CONTENT; ?>">
<?php echo $breadcrumbs['second']; ?>


<?php
	echo $content_format;

	# Creates the properly columned div
	if ($sidebar['sidebar'] == 'yes') {
		echo $sidebar_format['content'];
	} else {
		echo $sidebar_format;
	}
?>


<!-- Archive page: Begin -->
<main id="content">
		<?php if ( have_posts() ) : ?>

				<?php
					#the_archive_title( '<h1 class="page-title">News: ', '</h1>' );
					echo '<h1 class="page-title">';
					printf( __( '%s', 's3-child-news' ), '<span>' . single_cat_title( '', false ) . '</span>' );
					echo '</h1>';
					the_archive_description( '<div class="s3-c"><div class="s3-bs s3-p-8 text-center lead">', '</div></div>' );
				?>

			<?php /* Start the Loop */ ?>
			<?php while ( have_posts() ) : the_post(); ?>

				<?php

					/*
					 * Include the Post-Format-specific template for the content.
					 * If you want to override this in a child theme, then include a file
					 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
					 */
					get_template_part( 'template-parts/content', get_post_format() );
				?>

			<?php endwhile; ?>

			<div class="clearfix"></div>

			<?php s3_paging_nav(); ?>

		<?php else : ?>

			<?php get_template_part( 'template-parts/content', 'none' ); ?>

		<?php endif; ?>
</main>
<!-- Archive page: End -->


		</div><!-- /sidebar or primary content div -->

<?php
if ($sidebar['sidebar'] == 'yes') {
	echo $sidebar_format['sidebar'];
	get_sidebar($sidebar['widget']);
	echo '</div>';
}
?>
		</div><!-- .row -->
	</div><!-- .content -->
</div><!-- s3-<?php echo _SITE_CONTENT; ?> -->


<?php
// check if the flexible content field has rows of data
if ( $content = have_rows('content_below') ) {
	echo acf_content_flexible($content, 'content_below');
}
?>


<?php
get_footer();



