<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Strata_Three
 */

get_header();
?>


<div class="s3 s3-<?php echo _SITE_CONTENT; ?>">
	<div class="container">
		<div class="row s3-m-10">
			<div class="col-xs-12 col-md-8">


			<main id="content">
			<section class="error-404 not-found">
				<header class="page-header">
					<h1 class="page-title"><?php esc_html_e( 'Sorry! That page can&rsquo;t be found.', 's3' ); ?></h1>
				</header><!-- .page-header -->

				<div class="page-content">
					<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 's3' ); ?></p>

					<div class="s3-n2w s3-p-9 s3-bs">
						<?php get_search_form(); ?>
					</div>

					<hr />

						<div class="row">
							<div class="col-xs-12 col-sm-6">
								<?php the_widget( 'WP_Widget_Recent_Posts' ); ?>
							</div>
							<div class="col-xs-12 col-sm-6">
								<?php
									/* translators: %1$s: smiley */
									$archive_content = '<p>' . sprintf( esc_html__( 'Try looking in the monthly archives. %1$s', 's3' ), convert_smilies( ':)' ) ) . '</p>';
									the_widget( 'WP_Widget_Archives', 'dropdown=1', "after_title=</h2>$archive_content" );
								?>
							</div>
						</div>

				</div><!-- .page-content -->
			</section><!-- .error-404 -->
			</main>

			</div><!-- /sidebar or primary content div -->

			<div class="col-xs-12 col-sm-4 hidden-xs hidden-sm">
				<?php s3_decoration(); ?>
			</div><!-- .col -->
		</div><!-- .row -->
	</div><!-- .content -->
</div><!-- s3-<?php echo _SITE_CONTENT; ?> -->


<?php
get_footer();






